/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.internal.ms.System.Security.Cryptography;

import com.aspose.pdf.internal.l76k.l0n;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l0l;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l0y;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l3if;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l3p;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.l4t;
import com.aspose.pdf.internal.ms.System.Security.Cryptography.lc;
import com.aspose.pdf.internal.ms.System.l13v;
import com.aspose.pdf.internal.ms.System.l4v;
import com.aspose.pdf.internal.ms.System.l5f;
import com.aspose.pdf.internal.ms.System.l5p;
import com.aspose.pdf.internal.ms.System.l8t;
import com.aspose.pdf.internal.ms.System.lk;

public abstract class SymmetricAlgorithm
implements l5f {
    protected int lj;
    protected byte[] lt;
    protected int lb;
    protected byte[] ld;
    protected l3p[] lu;
    protected l3p[] le;
    protected int lh;
    protected int lk = 1;
    protected int lv = 2;
    private boolean lI = false;

    protected SymmetricAlgorithm() {
    }

    @Override
    public void dispose() {
        this.lf(true);
        l5p.lI(this);
    }

    public void clear() {
        this.lf(true);
    }

    protected void lf(boolean bl) {
        if (!this.lI) {
            if (this.ld != null) {
                l13v.lf(this.ld, 0, this.ld.length);
                this.ld = null;
            }
            if (bl) {
                // empty if block
            }
            this.lI = true;
        }
    }

    public int getBlockSize() {
        return this.lj;
    }

    public void setBlockSize(int value) {
        if (!l3p.lI(this.lu, value)) {
            throw new l0y(l0n.lI("block size not supported by algorithm"));
        }
        if (this.lj != value) {
            this.lj = value;
            this.lt = null;
        }
    }

    public int getFeedbackSize() {
        return this.lh;
    }

    public void setFeedbackSize(int value) {
        if (value <= 0 || value > this.lj) {
            throw new l0y(l0n.lI("feedback size larger than block size"));
        }
        this.lh = value;
    }

    public byte[] getIV() {
        if (this.lt == null) {
            this.generateIV();
        }
        return (byte[])this.lt.clone();
    }

    public void setIV(byte[] value) {
        if (value == null) {
            throw new lk("value");
        }
        if (value.length << 3 != this.lj) {
            throw new l0y(l0n.lI("IV length is different than block size"));
        }
        this.lt = (byte[])value.clone();
    }

    public byte[] getKey() {
        if (this.ld == null) {
            this.generateKey();
        }
        return (byte[])this.ld.clone();
    }

    public void setKey(byte[] value) {
        if (value == null) {
            throw new lk("value");
        }
        int n = value.length << 3;
        if (!l3p.lI(this.le, n)) {
            throw new l0y(l0n.lI("Key size not supported by algorithm"));
        }
        this.lb = n;
        this.ld = (byte[])value.clone();
    }

    public int getKeySize() {
        return this.lb;
    }

    public void setKeySize(int value) {
        if (!l3p.lI(this.le, value)) {
            throw new l0y(l0n.lI("Key size not supported by algorithm"));
        }
        this.lb = value;
        this.ld = null;
    }

    public l3p[] getLegalBlockSizes() {
        return this.lu;
    }

    public l3p[] getLegalKeySizes() {
        return this.le;
    }

    public int getMode() {
        return this.lk;
    }

    public void setMode(int value) {
        if (!l4v.isDefined(lc.class, (long)value)) {
            throw new l0y(l0n.lI("Cipher mode not available"));
        }
        this.lk = value;
    }

    public int getPadding() {
        return this.lv;
    }

    public void setPadding(int value) {
        if (!l4v.isDefined(l4t.class, (long)value)) {
            throw new l0y(l0n.lI("Padding mode not available"));
        }
        this.lv = value;
    }

    public l3if createDecryptor() {
        return this.createDecryptor(this.getKey(), this.getIV());
    }

    public abstract l3if createDecryptor(byte[] var1, byte[] var2);

    public l3if createEncryptor() {
        return this.createEncryptor(this.getKey(), this.getIV());
    }

    public abstract l3if createEncryptor(byte[] var1, byte[] var2);

    public abstract void generateIV();

    public abstract void generateKey();

    public boolean validKeySize(int bitLength) {
        return l3p.lI(this.le, bitLength);
    }

    public static SymmetricAlgorithm create() {
        return SymmetricAlgorithm.create("System.Security.Cryptography.SymmetricAlgorithm");
    }

    public static SymmetricAlgorithm create(String algName) {
        return (SymmetricAlgorithm)l0l.lI(algName);
    }

    public String toString() {
        String string = l8t.lI(this).l0h().substring(l8t.lI(this).l0h().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

