/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.abstract;
import com.aspose.slides.ms.System.int;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BitArray
implements ICollection,
abstract {
    private int[] do;
    private int if;
    private int for = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.if = bits.if;
        this.do = new int[(this.if + 31) / 32];
        if (this.do.length == 1) {
            this.do[0] = bits.do[0];
        } else {
            int.do(int.do((Object)bits.do), 0, int.do((Object)this.do), 0, this.do.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.if = values.length;
        this.do = new int[(this.if + 31) / 32];
        for (int i10 = 0; i10 < values.length; ++i10) {
            this.set_Item(i10, values[i10]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.if = bytes.length * 8;
        this.do = new int[(this.if + 31) / 32];
        for (int i10 = 0; i10 < bytes.length; ++i10) {
            this.do(i10, bytes[i10]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n10 = values.length;
        this.if = n10 * 32;
        this.do = new int[n10];
        int.do(int.do((Object)values), 0, int.do((Object)this.do), 0, n10);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.if = length;
        this.do = new int[(this.if + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i10 = 0; i10 < this.do.length; ++i10) {
                this.do[i10] = -1;
            }
        }
    }

    private byte do(int n10) {
        int n11 = n10 / 4;
        int n12 = n10 % 4 * 8;
        int n13 = this.do[n11] & 255 << n12;
        return (byte)(n13 >> n12 & 0xFF);
    }

    private void do(int n10, byte by2) {
        int n11 = n10 / 4;
        int n12 = n10 % 4 * 8;
        int n13 = n11;
        this.do[n13] = this.do[n13] & ~(255 << n12);
        int n14 = n11;
        this.do[n14] = this.do[n14] | (by2 & 0xFF) << n12;
        ++this.for;
    }

    private void if(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.if != this.if) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.if;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.if;
    }

    public void setLength(int value) {
        if (this.if == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.if) {
            int n10 = (value + 31) / 32;
            int n11 = (this.if + 31) / 32;
            if (n10 > this.do.length) {
                int[] nArray = new int[n10];
                int.do(int.do((Object)this.do), 0, int.do((Object)nArray), 0, this.do.length);
                this.do = nArray;
            } else {
                int.do(int.do((Object)this.do), n11, n10 - n11);
            }
            int n12 = this.if % 32;
            if (n12 > 0) {
                int n13 = n11 - 1;
                this.do[n13] = this.do[n13] & (1 << n12) - 1;
            }
        }
        this.if = value;
        ++this.for;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(int array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.int() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.new() && this.if > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = int.do(array);
        if (object instanceof Boolean[]) {
            if (array.new() - index < this.if) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i10 = 0; i10 < this.if; ++i10) {
                booleanArray[index + i10] = this.get_Item(i10);
            }
        } else if (object instanceof boolean[]) {
            if (array.new() - index < this.if) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i11 = 0; i11 < this.if; ++i11) {
                blArray[index + i11] = this.get_Item(i11);
            }
        } else if (object instanceof Byte[]) {
            int n10 = (this.if + 7) / 8;
            if (array.new() - index < n10) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i12 = 0; i12 < n10; ++i12) {
                byteArray[index + i12] = this.do(i12);
            }
        } else if (object instanceof byte[]) {
            int n11 = (this.if + 7) / 8;
            if (array.new() - index < n11) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i13 = 0; i13 < n11; ++i13) {
                byArray[index + i13] = this.do(i13);
            }
        } else if (object instanceof Integer[]) {
            int.do(int.do((Object)this.do), 0, array, index, (this.if + 31) / 32);
        } else if (object instanceof int[]) {
            int.do(int.do((Object)this.do), 0, array, index, (this.if + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n10 = (this.if + 31) / 32;
        for (int i10 = 0; i10 < n10; ++i10) {
            this.do[i10] = ~this.do[i10];
        }
        ++this.for;
        return this;
    }

    public BitArray and(BitArray value) {
        this.if(value);
        int n10 = (this.if + 31) / 32;
        for (int i10 = 0; i10 < n10; ++i10) {
            int n11 = i10;
            this.do[n11] = this.do[n11] & value.do[i10];
        }
        ++this.for;
        return this;
    }

    public BitArray or(BitArray value) {
        this.if(value);
        int n10 = (this.if + 31) / 32;
        for (int i10 = 0; i10 < n10; ++i10) {
            int n11 = i10;
            this.do[n11] = this.do[n11] | value.do[i10];
        }
        ++this.for;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.if(value);
        int n10 = (this.if + 31) / 32;
        for (int i10 = 0; i10 < n10; ++i10) {
            int n11 = i10;
            this.do[n11] = this.do[n11] ^ value.do[i10];
        }
        ++this.for;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.if) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.do[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.if) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n10 = index >> 5;
            this.do[n10] = this.do[n10] | 1 << (index & 0x1F);
        } else {
            int n11 = index >> 5;
            this.do[n11] = this.do[n11] & ~(1 << (index & 0x1F));
        }
        ++this.for;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i10 = 0; i10 < this.do.length; ++i10) {
                this.do[i10] = -1;
            }
        } else {
            int.do(int.do((Object)this.do), 0, this.do.length);
        }
        ++this.for;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class BitArrayEnumerator
    implements IEnumerator,
    abstract,
    Cloneable {
        private BitArray do;
        private boolean if;
        private int for;
        private int int;

        @Override
        public Object deepClone() {
            return this.do();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.for = -1;
            this.do = ba2;
            this.int = ba2.for;
        }

        @Override
        public Object next() {
            if (this.for == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.for >= this.do.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.if;
        }

        @Override
        public boolean hasNext() {
            this.if();
            if (this.for < this.do.size() - 1) {
                this.if = this.do.get_Item(++this.for);
                return true;
            }
            this.for = this.do.size();
            return false;
        }

        @Override
        public void reset() {
            this.if();
            this.for = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void if() {
            if (this.int != this.do.for) {
                throw new InvalidOperationException();
            }
        }

        protected Object do() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.do = this.do;
            bitArrayEnumerator.if = this.if;
            bitArrayEnumerator.for = this.for;
            bitArrayEnumerator.int = this.int;
            return bitArrayEnumerator;
        }
    }
}

