/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.AxesCompositionNotCombinableException;
import com.aspose.slides.AxesManager;
import com.aspose.slides.CannotCombine2DAnd3DChartsException;
import com.aspose.slides.Chart;
import com.aspose.slides.ChartData;
import com.aspose.slides.ChartDataCell;
import com.aspose.slides.ChartDataWorkbook;
import com.aspose.slides.ChartSeries;
import com.aspose.slides.ChartTypeCharacterizer;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.DomObject;
import com.aspose.slides.IChart;
import com.aspose.slides.IChartCellCollection;
import com.aspose.slides.IChartDataCell;
import com.aspose.slides.IChartSeries;
import com.aspose.slides.IChartSeriesCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.a0;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.ms.System.v8;
import com.aspose.slides.ms.System.vr;
import com.aspose.slides.nx3;
import com.aspose.slides.rt;
import com.aspose.slides.xc;
import com.aspose.slides.xhh;

public class ChartSeriesCollection
extends DomObject<ChartData>
implements IChartSeriesCollection {
    private Chart v2;
    private final nx3<IChartSeries> hn;

    ChartSeriesCollection(ChartData parentImmediate) {
        super(parentImmediate);
        this.hn = new nx3(parentImmediate);
    }

    @Override
    public final IChartSeries get_Item(int index) {
        return (IChartSeries)this.hn.get_Item(index);
    }

    @Override
    public final int size() {
        return this.hn.size();
    }

    @Override
    public final IChartSeries add(int type) {
        ChartSeries chartSeries = new ChartSeries(this, type, false);
        boolean bl2 = this.v2(chartSeries);
        chartSeries.v2(bl2);
        this.hn.addItem(chartSeries);
        chartSeries.hn();
        return chartSeries;
    }

    @Override
    public final IChartSeries insert(int index, int type) {
        ChartSeries chartSeries = new ChartSeries(this, type, false);
        boolean bl2 = this.v2(chartSeries);
        chartSeries.v2(bl2);
        this.hn.insertItem(index, chartSeries);
        chartSeries.hn();
        return chartSeries;
    }

    private boolean v2(ChartSeries chartSeries) {
        if (this.hn.size() > 0) {
            IChartSeries iChartSeries = (IChartSeries)this.hn.get_Item(0);
            boolean bl2 = ChartTypeCharacterizer.is3DChart(iChartSeries.getType());
            for (int i = 1; i < this.hn.size(); ++i) {
                iChartSeries = (IChartSeries)this.hn.get_Item(i);
            }
            if (bl2 != ChartTypeCharacterizer.is3DChart(chartSeries.getType())) {
                if (bl2) {
                    throw new CannotCombine2DAnd3DChartsException(vr.v2(new String[]{"Cannot combine 2D and 3D chart types ", "(the series to be added is 2D and present series is/are 3D)."}));
                }
                throw new CannotCombine2DAnd3DChartsException(vr.v2(new String[]{"Cannot combine 2D and 3D chart types ", "(the series to be added is 3D and present series is/are 2D)."}));
            }
        }
        if (((AxesManager)this.v2().getAxes()).v2(chartSeries.getType(), false)) {
            return false;
        }
        if (((AxesManager)this.v2().getAxes()).v2(chartSeries.getType(), true)) {
            return true;
        }
        throw new AxesCompositionNotCombinableException(vr.v2("Some chart types cannot be combined with other chart types. Select a different chart type. ", "Details: axes composition of the series to be added is not combinable with present ", "axes composition in chart. So series of this type cannot be added to this chart. ", "Preferred axes composition for the series to be added is \"", ChartTypeCharacterizer.cl(ChartTypeCharacterizer.v2(chartSeries.getType())), "\"."));
    }

    final void v2(int n, IChartSeries iChartSeries) {
        if (this.hn.containsItem(iChartSeries)) {
            this.hn.removeItem(iChartSeries);
            this.hn.insertItem(n, iChartSeries);
        }
    }

    @Override
    public final IChartSeries add(IChartDataCell cellWithSeriesName, int type) {
        for (IChartSeries iChartSeries : this.hn) {
            if (iChartSeries.getName().getDataSourceType() != 0 || iChartSeries.getName().getAsCells().getCount() != 1 || !iChartSeries.getName().getAsCells().get_Item(0).equals(cellWithSeriesName)) continue;
            return iChartSeries;
        }
        IChartSeries iChartSeries = this.add(type);
        ((ChartData)this.cc).hn().v2(cellWithSeriesName);
        iChartSeries.getName().setFromOneCell(cellWithSeriesName);
        return iChartSeries;
    }

    @Override
    public final IChartSeries add(IChartCellCollection cellsWithSeriesName, int type) {
        for (IChartSeries iChartSeries : this.hn) {
            if (iChartSeries.getName().getDataSourceType() != 0 || iChartSeries.getName().getAsCells().getCount() != cellsWithSeriesName.getCount() || !vr.s0(iChartSeries.getName().getAsCells().getConcatenatedValuesFromCells(), cellsWithSeriesName.getConcatenatedValuesFromCells())) continue;
            return iChartSeries;
        }
        IChartSeries iChartSeries = this.add(type);
        iChartSeries.getName().setAsCells(cellsWithSeriesName);
        return iChartSeries;
    }

    @Override
    public final IChartSeries add(String name, int type) {
        ChartDataCell chartDataCell = ((ChartDataWorkbook)this.v2().getChartData().getChartDataWorkbook()).na();
        chartDataCell.setValue(name);
        return this.add(chartDataCell, type);
    }

    final IChartSeries v2(int n, IChartSeriesGroup iChartSeriesGroup, boolean bl2) {
        ChartSeries chartSeries = new ChartSeries(this, n, true);
        chartSeries.v2(bl2);
        this.hn.addItem(chartSeries);
        ((AxesManager)this.v2().getAxes()).hn();
        ((xc)iChartSeriesGroup.getSeries()).v2(chartSeries);
        return chartSeries;
    }

    final IChartSeries v2(int n, boolean bl2) {
        ChartSeries chartSeries = new ChartSeries(this, n, true);
        chartSeries.v2(bl2);
        this.hn.addItem(chartSeries);
        ((AxesManager)this.v2().getAxes()).hn();
        ((rt)this.v2().getChartData().getSeriesGroups()).cl(chartSeries);
        return chartSeries;
    }

    @Override
    public final int indexOf(IChartSeries value) {
        return this.hn.indexOf(value);
    }

    @Override
    public final void remove(IChartSeries value) {
        if (this.hn.indexOf(value) == -1) {
            throw new ArgumentException("The value parameter was not found in the collection.");
        }
        this.hn.removeItem(value);
        ((AxesManager)this.v2().getAxes()).hn();
        ((rt)this.v2().getChartData().getSeriesGroups()).hn((ChartSeries)value);
    }

    @Override
    public final void removeAt(int index) {
        this.remove((IChartSeries)this.hn.get_Item(index));
    }

    @Override
    public final void clear() {
        while (this.hn.size() > 0) {
            this.removeAt(this.hn.size() - 1);
        }
    }

    final IChart v2() {
        if (this.v2 == null) {
            Chart[] chartArray = new Chart[]{this.v2};
            xhh.v2(Chart.class, (a0)this.cc, chartArray);
            this.v2 = chartArray[0];
        }
        return this.v2;
    }

    @Override
    public final IGenericEnumerator<IChartSeries> iterator() {
        return this.hn.iterator();
    }

    @Override
    public final IGenericEnumerator<IChartSeries> iteratorJava() {
        return this.hn.iteratorJava();
    }

    @Override
    public final void copyTo(v8 array, int index) {
        this.hn.copyTo(array, index);
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final Object getSyncRoot() {
        return this;
    }
}

