/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import com.aspose.slides.ms.System.wp;
import java.util.Arrays;

@v5
public class Queue
implements ICollection,
IEnumerable,
wp {
    private Object[] v2;
    private int hn = 0;
    private int cl = 0;
    private int v8 = 0;
    private int s0;
    private int cc = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.v2 = new Object[capacity];
        this.s0 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.cl;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(v8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.v8() > 1 || index != 0 && index >= array.s0() || this.cl > array.s0() - index) {
            throw new ArgumentException();
        }
        int n = this.v2.length;
        int n10 = n - this.hn;
        com.aspose.slides.ms.System.v8.v2(com.aspose.slides.ms.System.v8.v2(this.v2), this.hn, array, index, Math.min(this.cl, n10));
        if (this.cl > n10) {
            com.aspose.slides.ms.System.v8.v2(com.aspose.slides.ms.System.v8.v2(this.v2), 0, array, index + n10, this.cl - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.v2.length);
        queue.s0 = this.s0;
        com.aspose.slides.ms.System.v8.v2(this.v2, 0, queue.v2, 0, this.v2.length);
        queue.hn = this.hn;
        queue.cl = this.cl;
        queue.v8 = this.v8;
        return queue;
    }

    public void clear() {
        ++this.cc;
        this.hn = 0;
        this.cl = 0;
        this.v8 = 0;
        for (int i = this.v2.length - 1; i >= 0; --i) {
            this.v2[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.hn + this.cl;
        if (obj == null) {
            for (int i = this.hn; i < n; ++i) {
                if (this.v2[i % this.v2.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.hn; i < n; ++i) {
                if (!obj.equals(this.v2[i % this.v2.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.cc;
        if (this.cl < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.v2[this.hn];
        this.v2[this.hn] = null;
        this.hn = (this.hn + 1) % this.v2.length;
        --this.cl;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.cc;
        if (this.cl == this.v2.length) {
            this.v2();
        }
        this.v2[this.v8] = obj;
        this.v8 = (this.v8 + 1) % this.v2.length;
        ++this.cl;
    }

    public Object peek() {
        if (this.cl < 1) {
            throw new InvalidOperationException();
        }
        return this.v2[this.hn];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.cl) {
            return Arrays.copyOf(this.v2, this.cl, a.getClass());
        }
        System.arraycopy(this.v2, 0, a, 0, this.cl);
        if (a.length > this.cl) {
            a[this.cl] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.cc;
        Object[] objectArray = new Object[this.cl];
        this.copyTo(com.aspose.slides.ms.System.v8.v2(objectArray), 0);
        this.v2 = objectArray;
        this.hn = 0;
        this.v8 = 0;
    }

    private void v2() {
        int n = this.v2.length * this.s0 / 100;
        if (n < this.v2.length + 1) {
            n = this.v2.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.v8.v2(objectArray), 0);
        this.v2 = objectArray;
        this.hn = 0;
        this.v8 = this.hn + this.cl;
    }

    @v5
    private static class QueueEnumerator
    implements IEnumerator,
    wp {
        private Queue v2;
        private int hn;
        private int cl;

        QueueEnumerator(Queue q) {
            this.v2 = q;
            this.hn = q.cc;
            this.cl = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.v2);
            queueEnumerator.hn = this.hn;
            queueEnumerator.cl = this.cl;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.hn != this.v2.cc || this.cl < 0 || this.cl >= this.v2.cl) {
                throw new InvalidOperationException();
            }
            return this.v2.v2[(this.v2.hn + this.cl) % this.v2.v2.length];
        }

        @Override
        public boolean hasNext() {
            if (this.hn != this.v2.cc) {
                throw new InvalidOperationException();
            }
            if (this.cl >= this.v2.cl - 1) {
                this.cl = Integer.MAX_VALUE;
                return false;
            }
            ++this.cl;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.hn != this.v2.cc) {
                throw new InvalidOperationException();
            }
            this.cl = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue v2;

        SyncQueue(Queue queue) {
            this.v2 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.v2;
            synchronized (queue) {
                return this.v2.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(v8 array, int index) {
            Queue queue = this.v2;
            synchronized (queue) {
                this.v2.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.v2;
            synchronized (queue) {
                return this.v2.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.v2;
            synchronized (queue) {
                return new SyncQueue((Queue)this.v2.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.v2;
            synchronized (queue) {
                this.v2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.v2;
            synchronized (queue) {
                this.v2.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.v2;
            synchronized (queue) {
                return this.v2.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.v2;
            synchronized (queue) {
                return this.v2.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.v2;
            synchronized (queue) {
                this.v2.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.v2;
            synchronized (queue) {
                return this.v2.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.v2;
            synchronized (queue) {
                return this.v2.toArray(a);
            }
        }
    }
}

