/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.cx.m2;
import com.aspose.slides.internal.ny.cl;
import com.aspose.slides.internal.ny.ds;
import com.aspose.slides.ms.System.i2;
import com.aspose.slides.ms.System.mk;

public class BitVector32
extends ds<BitVector32> {
    private int v2;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.v2 = value.v2;
    }

    public BitVector32(int data) {
        this.v2 = data;
    }

    public int getData() {
        return this.v2;
    }

    public int get_Item(Section section) {
        return this.v2 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.v2 &= ~(section.getMask() << section.getOffset());
        this.v2 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.v2 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.v2 = value ? (this.v2 |= bit) : (this.v2 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.v2(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.v2(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(cl.hn((Object)n10, 9), cl.hn((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return cl.hn(o, BitVector32.class) && this.v2 == cl.v8((Object)o, BitVector32.class).v2;
    }

    public int hashCode() {
        return mk.v2(this.v2);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        m2 m22 = new m2();
        m22.v2("BitVector32{");
        for (long i = cl.cc((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            m22.v2(((long)value.v2 & i) == 0L ? (char)'0' : '1');
        }
        m22.v2('}');
        return m22.toString();
    }

    private static int v2(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.v2 = this.v2;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends ds<Section> {
        private short v2;
        private short hn;

        public Section() {
        }

        Section(short mask, short offset) {
            this.v2 = mask;
            this.hn = offset;
        }

        public short getMask() {
            return this.v2;
        }

        public short getOffset() {
            return this.hn;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.v2 == b.v2 && a.hn == b.hn;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.v2 != b.v2 || a.hn != b.hn;
        }

        public boolean equals(Section obj) {
            return this.v2 == obj.v2 && this.hn == obj.hn;
        }

        public boolean equals(Object o) {
            if (!cl.hn(o, Section.class)) {
                return false;
            }
            Section section = cl.v8(o, Section.class).Clone();
            return this.v2 == section.v2 && this.hn == section.hn;
        }

        public int hashCode() {
            return this.v2 << this.hn;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            m2 m22 = new m2();
            m22.v2("Section{0x");
            m22.v2(i2.v2(value.getMask(), 16));
            m22.v2(", 0x");
            m22.v2(i2.v2(value.getOffset(), 16));
            m22.v2("}");
            return m22.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.v2 = this.v2;
            that.hn = this.hn;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

