/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IChartDataPoint;
import com.aspose.slides.IChartDataPointCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.IPieSplitCustomPointCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.ny.cl;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.vr;

public class PieSplitCustomPointCollection
implements IPieSplitCustomPointCollection {
    private final IChartSeriesGroup v2;
    private final List<IChartDataPoint> hn;

    @Override
    public final IChartDataPoint get_Item(int index) {
        return this.hn.get_Item(index);
    }

    @Override
    public final void add(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.v2.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(vr.v2("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        IChartDataPoint iChartDataPoint = iChartDataPointCollection.get_Item(dataPointIndex);
        if (this.hn.containsItem(iChartDataPoint)) {
            throw new ArgumentException("Data point is already added");
        }
        this.hn.addItem(iChartDataPoint);
    }

    @Override
    public void addItem(IChartDataPoint dataPoint) {
        this.v2(dataPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void v2(IChartDataPoint iChartDataPoint) {
        IChartDataPointCollection iChartDataPointCollection = this.v2.get_Item(0).getDataPoints();
        IGenericEnumerator iGenericEnumerator = iChartDataPointCollection.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IChartDataPoint iChartDataPoint2 = (IChartDataPoint)iGenericEnumerator.next();
                if (iChartDataPoint2 != iChartDataPoint) continue;
                this.hn.addItem(iChartDataPoint);
                return;
            }
        }
        finally {
            if (cl.v2(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        throw new ArgumentException("Coudn't find dataPoint in parent series. Allowed adding dataPoint only from same chart and parent series");
    }

    @Override
    public boolean removeItem(IChartDataPoint dataPoint) {
        return this.hn(dataPoint);
    }

    final boolean hn(IChartDataPoint iChartDataPoint) {
        return this.hn.removeItem(iChartDataPoint);
    }

    @Override
    public final void remove(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.v2.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(vr.v2("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        this.hn.removeItem(iChartDataPointCollection.get_Item(dataPointIndex));
    }

    @Override
    public final void clear() {
        this.hn.clear();
    }

    @Override
    public boolean containsItem(IChartDataPoint item) {
        return this.cl(item);
    }

    final boolean cl(IChartDataPoint iChartDataPoint) {
        return this.hn.containsItem(iChartDataPoint);
    }

    public void copyToTArray(IChartDataPoint[] array, int arrayIndex) {
        this.v2(array, arrayIndex);
    }

    final void v2(IChartDataPoint[] iChartDataPointArray, int n) {
        this.hn.copyToTArray((IChartDataPoint[])iChartDataPointArray, n);
    }

    @Override
    public final int size() {
        return this.hn.size();
    }

    @Override
    public final boolean isReadOnly() {
        return this.hn.isReadOnly();
    }

    public final boolean isSynchronized() {
        return false;
    }

    public final Object getSyncRoot() {
        return this;
    }

    @Override
    public final IGenericEnumerator<IChartDataPoint> iterator() {
        return this.hn.iterator();
    }

    public final IGenericEnumerator<IChartDataPoint> iteratorJava() {
        return this.hn.iteratorJava();
    }

    PieSplitCustomPointCollection(IChartSeriesGroup parentSeriesGroup) {
        this.v2 = parentSeriesGroup;
        this.hn = new List();
    }
}

