/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.g0;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.ju;
import com.aspose.slides.ms.System.ra;
import com.aspose.slides.ms.System.u1;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@u1
public class ArrayList
implements IList,
List {
    private Object[] l0;
    private int ql;
    private int r2;
    private static Object[] ic = new Object[0];

    protected int getVersion() {
        return this.r2;
    }

    public ArrayList() {
        this.l0 = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.l0 = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.l0("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.l0 = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.l0 = null;
    }

    private ArrayList(ic array, int index, int count) {
        this.l0 = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.ic.l0(array, index, com.aspose.slides.ms.System.ic.l0(this.l0), 0, count);
        this.ql = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.ql) {
            ArrayList.l0("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.l0[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.ql) {
            ArrayList.l0("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.l0[index] = value;
        ++this.r2;
    }

    @Override
    public int size() {
        return this.ql;
    }

    public int getCapacity() {
        return this.l0.length;
    }

    public void setCapacity(int value) {
        if (value < this.ql) {
            ArrayList.l0("Capacity", (Object)value, "Must be more than count.");
        }
        this.l0 = value > 0 ? Arrays.copyOf(this.l0, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void l0(int n) {
        int n10;
        if (n <= this.l0.length) {
            return;
        }
        int n11 = n10 = this.l0.length == 0 ? 4 : this.l0.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void l0(int n, int n10) {
        if (n10 > 0) {
            if (this.ql + n10 > this.l0.length) {
                int n11;
                int n12 = n11 = this.l0.length > 0 ? this.l0.length << 1 : 1;
                while (n11 < this.ql + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.ic.l0(this.l0, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.ic.l0(this.l0, n, objectArray, n + n10, this.ql - n);
                this.l0 = objectArray;
            } else {
                com.aspose.slides.ms.System.ic.l0(this.l0, n, this.l0, n + n10, this.ql - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.ic.l0(this.l0, n13, this.l0, n, this.ql - n13);
            com.aspose.slides.ms.System.ic.l0(this.l0, this.ql + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.l0.length <= this.ql) {
            this.l0(this.ql + 1);
        }
        this.l0[this.ql] = value;
        ++this.r2;
        return this.ql++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, this.ql);
        this.ql = 0;
        ++this.r2;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.ql) > -1;
    }

    boolean l0(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.ql - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.ql) {
            ArrayList.l0("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.l0("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.ql - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.ic.l0(this.l0, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.ql - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return ra.l0(this.l0, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.ql) {
            ArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.l0(index, 1);
        this.l0[index] = value;
        ++this.ql;
        ++this.r2;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.ql) {
            ArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.l0.length < this.ql + n) {
                this.l0(this.ql + n);
            }
            if (index < this.ql) {
                com.aspose.slides.ms.System.ic.l0(this.l0, index, this.l0, index + n, this.ql - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.ic.l0(this.l0, 0, this.l0, index, index);
                com.aspose.slides.ms.System.ic.l0(this.l0, index + n, this.l0, index << 1, this.ql - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.ic.l0(this.l0), index);
            }
            this.ql += c.size();
            ++this.r2;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.ql) {
            ArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.l0.length < this.ql + n) {
                this.l0(this.ql + n);
            }
            if (index < this.ql) {
                com.aspose.slides.ms.System.ic.l0(this.l0, index, this.l0, index + n, this.ql - index);
            }
            com.aspose.slides.ms.System.ic.l0(c).copyTo(com.aspose.slides.ms.System.ic.l0(this.l0), index);
            this.ql += c.length;
            ++this.r2;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.r2;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.ql) {
            ArrayList.l0("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.l0(index, -1);
        --this.ql;
        ++this.r2;
    }

    public void removeRange(int index, int count) {
        ArrayList.l0(index, count, this.ql);
        this.l0(index, -count);
        this.ql -= count;
        ++this.r2;
    }

    public void reverse() {
        ra.l0(this.l0, 0, this.ql);
        ++this.r2;
    }

    public void reverse(int index, int count) {
        ArrayList.l0(index, count, this.ql);
        ra.l0(this.l0, index, count);
        ++this.r2;
    }

    public void copyTo(ic array) {
        com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), 0, array, 0, this.ql);
    }

    @Override
    public void copyTo(ic array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.ql);
    }

    public void copyTo(int index, ic array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ic() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.l0(index, count, this.ql);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.ql, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.ql, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return ra.l0(this.l0, 0, this.ql, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return ra.l0(this.l0, 0, this.ql, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return ra.l0(this.l0, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.l0(index, count, this.ql);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.ql) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.ic.l0(this.l0), index);
        ++this.r2;
    }

    public void trimToSize() {
        this.setCapacity(this.ql);
    }

    public void sort() {
        Arrays.sort(this.l0, 0, this.ql, Comparer.Default);
        ++this.r2;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.l0, 0, this.ql, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.l0(index, count, this.ql);
        Arrays.sort(this.l0, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.ql];
        this.copyTo(com.aspose.slides.ms.System.ic.l0(objectArray));
        return objectArray;
    }

    public ic toArray(ju type) {
        ic ic2 = com.aspose.slides.ms.System.ic.l0(type, this.ql);
        this.copyTo(ic2);
        return ic2;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.ic.l0(this.l0), 0, this.ql);
    }

    static void l0(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.l0("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.l0("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void l0(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.ic.l0(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.ql, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List l0;
        private int ql;

        @Override
        protected int getVersion() {
            return this.l0 instanceof ArrayList ? ((ArrayList)this.l0).getVersion() : this.ql;
        }

        public ArrayListInternalized(List internal) {
            this.l0 = internal;
            if (internal instanceof ArrayList) {
                this.ql = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.l0.set(index, value);
            ++this.ql;
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.l0.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.l0.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.l0.size(); ++i) {
                this.l0.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.l0.size();
            this.l0.add(value);
            ++this.ql;
            return n;
        }

        @Override
        public void clear() {
            this.l0.clear();
            ++this.ql;
        }

        @Override
        public boolean contains(Object item) {
            return this.l0.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.l0.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.l0.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.l0.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.l0.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.l0.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return ra.l0(this.l0.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.l0.add(index, value);
            ++this.ql;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.l0.add(index++, e);
            }
            ++this.ql;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.l0.add(index++, object);
            }
            ++this.ql;
        }

        @Override
        public void removeItem(Object obj) {
            this.l0.remove(obj);
            ++this.ql;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.l0.remove(index);
            ++this.ql;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.l0.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.l0.remove(index);
            }
            ++this.ql;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.l0.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.l0.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.l0.size() - 1; n < i; ++n, --i) {
                Object e = this.l0.get(n);
                this.l0.set(n, this.l0.get(i));
                this.l0.set(i, e);
            }
            ++this.ql;
        }

        @Override
        public void copyTo(ic array) {
            com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0.toArray()), 0, array, 0, this.l0.size());
        }

        @Override
        public void copyTo(ic array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.l0.size());
        }

        @Override
        public void copyTo(int index, ic array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ic() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.ic.l0(com.aspose.slides.ms.System.ic.l0(this.l0.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.l0(index, count, this.l0.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.l0.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return ra.l0(this.l0.toArray(), 0, this.l0.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return ra.l0(this.l0.toArray(), 0, this.l0.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return ra.l0(this.l0.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.l0(index, count, this.l0.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.l0.set(index++, e);
            }
            ++this.ql;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.l0, null);
            ++this.ql;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.l0, comparer);
            ++this.ql;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.l0.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.l0.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.l0.set(i, list.get(i - index));
            }
            ++this.ql;
        }

        @Override
        public Object[] toArray() {
            return this.l0.toArray();
        }

        @Override
        public ic toArray(ju type) {
            ic ic2 = com.aspose.slides.ms.System.ic.l0(type, this.l0.size());
            this.copyTo(ic2);
            return ic2;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.l0.size()];
            com.aspose.slides.ms.System.ic.l0(this.l0.toArray(), 0, objectArray, 0, this.l0.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e : arrayList) {
                arrayList.add(e);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.l0.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.l0.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.ql;
            return this.l0.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.ql;
            return this.l0.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.l0.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.ql;
            return this.l0.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.ql;
            return this.l0.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.ql;
            return this.l0.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.ql;
            return this.l0.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.l0.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.ql;
            return this.l0.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.l0.add(index, element);
            ++this.ql;
        }

        @Override
        public Object remove(int index) {
            ++this.ql;
            return this.l0.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.l0.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.l0.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.l0.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.l0 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.l0 != 0;
        }

        @Override
        public int nextIndex() {
            return this.l0;
        }

        @Override
        public int previousIndex() {
            return this.l0 - 1;
        }

        public Object previous() {
            int n = this.l0 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.l0;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.l0 = n;
            this.ql = n;
            return objectArray[this.ql];
        }

        public void set(Object e) {
            if (this.ql < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).l0[this.ql] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.l0;
                ArrayList.this.add(n, e);
                this.l0 = n + 1;
                this.ql = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int l0;
        int ql = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.l0 != ArrayList.this.size();
        }

        public Object next() {
            int n = this.l0;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.l0;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.l0 = n + 1;
            this.ql = n;
            return objectArray[this.ql];
        }

        @Override
        public void remove() {
            if (this.ql < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.ql);
                this.l0 = this.ql;
                this.ql = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @u1
    private static class ListWrapper
    implements IList {
        protected IList l0;

        public ListWrapper(IList innerList) {
            this.l0 = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.l0.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.l0.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.l0.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.l0.addItem(value);
        }

        @Override
        public void clear() {
            this.l0.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.l0.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.l0.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.l0.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.l0.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.l0.removeAt(index);
        }

        @Override
        public void copyTo(ic array, int index) {
            this.l0.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.l0.iterator();
        }
    }

    @u1
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String l0() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.l0());
        }
    }

    @u1
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String l0() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.l0());
        }
    }

    @u1
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object ql;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.ql = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.ql;
            synchronized (object) {
                this.l0.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array, int index) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.iterator();
            }
        }
    }

    @u1
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int ql;
        private int r2;
        private int ic;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.ql = index;
            this.r2 = count;
            this.ic = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.r2) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.l0.get_Item(this.ql + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.r2) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.l0.set_Item(this.ql + index, value);
        }

        @Override
        public int size() {
            this.l0();
            return this.r2;
        }

        @Override
        public int getCapacity() {
            return this.l0.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.r2) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void l0() {
            if (this.ic != this.l0.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.l0();
            this.l0.insertItem(this.ql + this.r2, value);
            this.ic = this.l0.getVersion();
            return ++this.r2;
        }

        @Override
        public void clear() {
            this.l0();
            this.l0.removeRange(this.ql, this.r2);
            this.r2 = 0;
            this.ic = this.l0.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.l0.l0(value, this.ql, this.r2);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.r2 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.r2) {
                RangedArrayList.l0("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.l0("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.r2 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.l0.indexOf(value, this.ql + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.ql;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.r2 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.l0("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.l0("count", (Object)count, "count is negative.");
            }
            if ((n = this.l0.lastIndexOf(value, this.ql + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.ql;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.l0();
            if (index < 0 || index > this.r2) {
                RangedArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.l0.insertItem(this.ql + index, value);
            ++this.r2;
            this.ic = this.l0.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.l0();
            if (index < 0 || index > this.r2) {
                RangedArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.l0.insertRange(this.ql + index, c);
            this.r2 += c.size();
            this.ic = this.l0.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.l0();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.ic = this.l0.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.l0();
            if (index < 0 || index > this.r2) {
                RangedArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.l0.removeAt(this.ql + index);
            --this.r2;
            this.ic = this.l0.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.l0();
            RangedArrayList.l0(index, count, this.r2);
            this.l0.removeRange(this.ql + index, count);
            this.r2 -= count;
            this.ic = this.l0.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.r2);
        }

        @Override
        public void reverse(int index, int count) {
            this.l0();
            RangedArrayList.l0(index, count, this.r2);
            this.l0.reverse(this.ql + index, count);
            this.ic = this.l0.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.l0();
            if (index < 0 || index > this.r2) {
                RangedArrayList.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.l0.setRange(this.ql + index, c);
            this.ic = this.l0.getVersion();
        }

        @Override
        public void copyTo(ic array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(ic array, int index) {
            this.copyTo(0, array, index, this.r2);
        }

        @Override
        public void copyTo(int index, ic array, int arrayIndex, int count) {
            RangedArrayList.l0(index, count, this.r2);
            this.l0.copyTo(this.ql + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.r2);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.l0(index, count, this.r2);
            return this.l0.iterator(this.ql + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.l0();
            this.l0.insertRange(this.r2, c);
            this.r2 += c.size();
            this.ic = this.l0.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.r2, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.r2, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.l0(index, count, this.r2);
            return this.l0.binarySearch(this.ql + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.l0.deepClone(), this.ql, this.r2);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.l0(index, count, this.r2);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.r2, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.l0();
            RangedArrayList.l0(index, count, this.r2);
            this.l0.sort(this.ql + index, count, comparer);
            this.ic = this.l0.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.r2];
            this.l0.copyTo(this.ql, com.aspose.slides.ms.System.ic.l0(objectArray), 0, this.r2);
            return objectArray;
        }

        @Override
        public ic toArray(ju elementType) {
            ic ic2 = com.aspose.slides.ms.System.ic.l0(elementType, this.r2);
            this.l0.copyTo(this.ql, ic2, 0, this.r2);
            return ic2;
        }
    }

    @u1
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String l0() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.l0());
        }
    }

    @u1
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String l0() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.l0());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.l0());
        }
    }

    @u1
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object ql;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.ql = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.ql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.ql;
            synchronized (object) {
                this.l0.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.ql;
            synchronized (object) {
                this.l0.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array, int index) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, ic array, int arrayIndex, int count) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.ql;
            synchronized (object) {
                this.l0.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.ql;
            synchronized (object) {
                this.l0.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.ql;
            synchronized (object) {
                this.l0.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ic toArray(ju elementType) {
            Object object = this.ql;
            synchronized (object) {
                return this.l0.toArray(elementType);
            }
        }
    }

    @u1
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList l0;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.l0 = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.l0.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public int getCapacity() {
            return this.l0.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.l0.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.l0.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.l0.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.l0.addItem(value);
        }

        @Override
        public void clear() {
            this.l0.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.l0.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.l0.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.l0.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.l0.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.l0.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.l0.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.l0.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.l0.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.l0.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.l0.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.l0.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.l0.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.l0.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.l0.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.l0.setRange(index, c);
        }

        @Override
        public void copyTo(ic array) {
            this.l0.copyTo(array);
        }

        @Override
        public void copyTo(ic array, int index) {
            this.l0.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ic array, int arrayIndex, int count) {
            this.l0.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.l0.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.l0.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.l0.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.l0.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.l0.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.l0.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.l0.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.l0.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.l0.trimToSize();
        }

        @Override
        public void sort() {
            this.l0.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.l0.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.l0.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.l0.toArray();
        }

        @Override
        public ic toArray(ju elementType) {
            return this.l0.toArray(elementType);
        }
    }

    @u1
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList l0;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.l0 = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.l0.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public int getCapacity() {
            return this.l0.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.l0.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.l0.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.l0.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.l0.addItem(value);
        }

        @Override
        public void clear() {
            this.l0.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.l0.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.l0.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.l0.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.l0.size()) {
                ArrayListAdapter.l0("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.l0("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.l0.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.l0.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.l0.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.l0.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.l0("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.l0("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.l0("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.l0.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.l0.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.l0.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.l0.size()) {
                ArrayListAdapter.l0("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.l0.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.l0.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.l0.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.l0(index, count, this.l0.size());
            for (int i = 0; i < count; ++i) {
                this.l0.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.l0.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.l0(index, count, this.l0.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.l0.get_Item(i + index);
                this.l0.set_Item(i + index, this.l0.get_Item(index + count - i + index - 1));
                this.l0.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.l0.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.l0.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(ic array) {
            this.l0.copyTo(array, 0);
        }

        @Override
        public void copyTo(ic array, int index) {
            this.l0.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ic array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.l0("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.l0("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.l0("index", (Object)index, "Can't be less than zero.");
            }
            if (array.ic() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.yx() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.l0.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.r2(this.l0.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.l0.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.l0(index, count, this.l0.size());
            return new EnumeratorWithRange(this.l0.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.l0.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.l0.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.l0(index, count, this.l0.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.l0.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.l0);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.l0(index, count, this.l0.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.l0.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.l0(index, count, this.l0.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.l0(this.l0, index, index + count - 1, comparer);
        }

        private static void l0(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void l0(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.l0(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.l0(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.l0(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.l0(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.l0(iList, n12, n13);
            }
            ArrayListAdapter.l0(iList, n10 - 1, n12);
            ArrayListAdapter.l0(iList, n, n12 - 1, comparator);
            ArrayListAdapter.l0(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.l0.size()];
            this.l0.copyTo(com.aspose.slides.ms.System.ic.l0(objectArray), 0);
            return objectArray;
        }

        @Override
        public ic toArray(ju elementType) {
            ic ic2 = com.aspose.slides.ms.System.ic.l0(elementType, this.l0.size());
            this.l0.copyTo(ic2, 0);
            return ic2;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        g0,
        Cloneable {
            private int l0;
            private int ql;
            private int r2;
            private IEnumerator ic;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.ql = 0;
                this.l0 = index;
                this.r2 = count;
                this.ic = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.l0();
            }

            @Override
            public Object next() {
                return this.ic.next();
            }

            @Override
            public boolean hasNext() {
                if (this.ql >= this.r2) {
                    return false;
                }
                ++this.ql;
                return this.ic.hasNext();
            }

            @Override
            public void reset() {
                this.ql = 0;
                this.ic.reset();
                for (int i = 0; i < this.l0; ++i) {
                    this.ic.hasNext();
                }
            }

            protected Object l0() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.l0 = this.l0;
                enumeratorWithRange.ql = this.ql;
                enumeratorWithRange.r2 = this.r2;
                enumeratorWithRange.ic = this.ic;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    g0,
    Cloneable {
        private ArrayList ql;
        private Object r2;
        private int ic;
        private int yx;
        static Object l0 = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.ql = list;
            this.ic = -1;
            this.yx = list.getVersion();
            this.r2 = l0;
        }

        @Override
        public Object deepClone() {
            return this.l0();
        }

        @Override
        public boolean hasNext() {
            if (this.yx != this.ql.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.ic < this.ql.size()) {
                this.r2 = this.ql.get_Item(this.ic);
                return true;
            }
            this.r2 = l0;
            return false;
        }

        @Override
        public Object next() {
            if (this.r2 == l0) {
                if (this.ic == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.r2;
        }

        @Override
        public void reset() {
            if (this.yx != this.ql.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.r2 = l0;
            this.ic = -1;
        }

        protected Object l0() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.ql = this.ql;
            simpleEnumerator.r2 = this.r2;
            simpleEnumerator.ic = this.ic;
            simpleEnumerator.yx = this.yx;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    g0,
    Cloneable {
        private Object l0;
        private ArrayList ql;
        private int r2;
        private int ic;
        private int yx;
        private int ek;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.l0();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.ql = list;
            this.ic = index;
            this.yx = count;
            this.r2 = this.ic - 1;
            this.l0 = null;
            this.ek = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.r2 == this.ic - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.l0;
        }

        @Override
        public boolean hasNext() {
            if (this.ql.getVersion() != this.ek) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.r2;
            if (this.r2 - this.ic < this.yx) {
                this.l0 = this.ql.get_Item(this.r2);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.l0 = null;
            this.r2 = this.ic - 1;
        }

        protected Object l0() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.l0 = this.l0;
            arrayListEnumerator.ql = this.ql;
            arrayListEnumerator.r2 = this.r2;
            arrayListEnumerator.ic = this.ic;
            arrayListEnumerator.yx = this.yx;
            arrayListEnumerator.ek = this.ek;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

