/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.Comparer;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.Collections.Generic.RBTree;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.in.el;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.internal.ph.ae;
import com.aspose.slides.internal.ph.e1;
import com.aspose.slides.internal.ph.wj;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.qu;
import com.aspose.slides.ms.System.u1;
import java.util.Comparator;

@u1
public class SortedDictionary<TKey, TValue>
implements IGenericCollection<KeyValuePair<TKey, TValue>>,
IGenericDictionary<TKey, TValue>,
IGenericEnumerable<KeyValuePair<TKey, TValue>>,
e1 {
    private RBTree l0;
    private NodeHelper ql;

    public SortedDictionary() {
        this((Comparator)null);
    }

    public SortedDictionary(Comparator<TKey> comparer) {
        this.ql = NodeHelper.l0(comparer);
        this.l0 = new RBTree(this.ql);
    }

    public SortedDictionary(IGenericDictionary<TKey, TValue> dictionary) {
        this(dictionary, null);
    }

    public SortedDictionary(IGenericDictionary<TKey, TValue> dictionary, Comparator<TKey> comparer) {
        this(comparer);
        if (dictionary == null) {
            throw new ArgumentNullException("dictionary");
        }
        for (KeyValuePair keyValuePair : dictionary) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    protected SortedDictionary(ae info, wj context) {
        KeyValuePair[] keyValuePairArray;
        this.ql = (NodeHelper)info.l0("Helper", r2.l0(NodeHelper.class));
        this.l0 = new RBTree(this.ql);
        for (KeyValuePair keyValuePair : keyValuePairArray = (KeyValuePair[])info.l0("KeyValuePairs", r2.l0(KeyValuePair[].class))) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    public Comparator<TKey> getComparer() {
        return this.ql.l0;
    }

    int l0() {
        return this.l0.r2();
    }

    @Override
    public int size() {
        return this.l0();
    }

    TValue l0(TKey TKey) {
        Node node = (Node)this.l0.ql(TKey);
        if (node == null) {
            throw new KeyNotFoundException();
        }
        return node.ql;
    }

    @Override
    public TValue get_Item(TKey key) {
        return this.l0(key);
    }

    void l0(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        Node node = (Node)this.l0.l0(TKey, (RBTree.Node)null);
        node.ql = TValue;
    }

    @Override
    public void set_Item(TKey key, TValue value) {
        this.l0(key, value);
    }

    public KeyCollection<TKey, TValue> getKeys() {
        return new KeyCollection(this);
    }

    public ValueCollection<TKey, TValue> getValues() {
        return new ValueCollection(this);
    }

    void ql(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        Node<TKey, TValue> node = new Node<TKey, TValue>(TKey, TValue);
        if (this.l0.l0(TKey, node) != node) {
            throw new ArgumentException("key already present in dictionary", "key");
        }
    }

    @Override
    public void addItem(TKey key, TValue value) {
        this.ql(key, value);
    }

    @Override
    public void addItem(KeyValuePair<TKey, TValue> item) {
        this.addItem(item.getKey(), item.getValue());
    }

    @Override
    public boolean containsItem(KeyValuePair<TKey, TValue> item) {
        Object[] objectArray = new Object[]{null};
        boolean bl2 = this.tryGetValue(item.getKey(), objectArray);
        boolean bl3 = new EqualityComparer.DefaultComparer().equals(item.getValue(), objectArray[0]);
        return bl2 && bl3;
    }

    @Override
    public boolean removeItem(KeyValuePair<TKey, TValue> item) {
        return this.removeItemByKey(item.getKey());
    }

    void ql() {
        this.l0.ql();
    }

    @Override
    public void clear() {
        this.ql();
    }

    boolean ql(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException();
        }
        return this.l0.ql(TKey) != null;
    }

    @Override
    public boolean containsKey(TKey key) {
        return this.ql(key);
    }

    public boolean containsValue(TValue value) {
        EqualityComparer.DefaultComparer defaultComparer = new EqualityComparer.DefaultComparer();
        for (Node node : this.l0.ek()) {
            if (!defaultComparer.equals(value, node.ql)) continue;
            return true;
        }
        return false;
    }

    void l0(KeyValuePair<TKey, TValue>[] keyValuePairArray, int n) {
        if (this.size() == 0) {
            return;
        }
        if (keyValuePairArray == null) {
            throw new ArgumentNullException();
        }
        if (n < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (keyValuePairArray.length <= n) {
            throw new ArgumentException();
        }
        if (keyValuePairArray.length < this.size()) {
            throw new ArgumentException();
        }
        if (keyValuePairArray.length - n < this.size()) {
            throw new ArgumentException();
        }
        for (Node node : this.l0.ek()) {
            keyValuePairArray[n++] = node.l0().Clone();
        }
    }

    public void copyToTArray(KeyValuePair<TKey, TValue>[] array, int index) {
        this.l0(array, index);
    }

    public Enumerator<TKey, TValue> iterator() {
        return new Enumerator(this);
    }

    boolean r2(TKey TKey) {
        return this.l0.l0(TKey) != null;
    }

    @Override
    public boolean removeItemByKey(TKey key) {
        return this.r2(key);
    }

    @Override
    public boolean tryGetValue(TKey key, Object[] valueRef) {
        Node node = (Node)this.l0.ql(key);
        valueRef[0] = node == null ? null : node.ql;
        return node != null;
    }

    @Override
    public void getObjectData(ae info, wj context) {
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        KeyValuePair[] keyValuePairArray = (KeyValuePair[])ic.l0(ic.l0(r2.l0(KeyValuePair.class), this.size()));
        this.copyToTArray(keyValuePairArray, 0);
        info.l0("KeyValuePairs", keyValuePairArray);
        info.l0("Helper", this.ql);
    }

    private TKey ic(Object object) {
        if (object == null) {
            throw new ArgumentNullException("key");
        }
        return (TKey)object;
    }

    private TValue yx(Object object) {
        return (TValue)object;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public IDictionary getIDictionary() {
        return new IDictionary(){

            @Override
            public boolean isFixedSize() {
                return false;
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public Object get_Item(Object o) {
                return SortedDictionary.this.l0(SortedDictionary.this.ic(o));
            }

            @Override
            public void set_Item(Object key, Object value) {
                SortedDictionary.this.l0(SortedDictionary.this.ic(key), SortedDictionary.this.yx(value));
            }

            @Override
            public ICollection getKeys() {
                return new KeyCollection(SortedDictionary.this.r2()).getICollection();
            }

            @Override
            public ICollection getValues() {
                return new ValueCollection(SortedDictionary.this.r2()).getICollection();
            }

            @Override
            public void addItem(Object key, Object value) {
                SortedDictionary.this.ql(SortedDictionary.this.ic(key), SortedDictionary.this.yx(value));
            }

            @Override
            public void removeItem(Object o) {
                SortedDictionary.this.r2(SortedDictionary.this.ic(o));
            }

            @Override
            public void clear() {
                SortedDictionary.this.ql();
            }

            @Override
            public boolean contains(Object key) {
                return SortedDictionary.this.ql(SortedDictionary.this.ic(key));
            }

            @Override
            public IDictionaryEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.r2()).getIDictionaryEnumerator();
            }

            @Override
            public int size() {
                return SortedDictionary.this.l0();
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }

            @Override
            public Object getSyncRoot() {
                return SortedDictionary.this.r2();
            }

            @Override
            public void copyTo(ic objects, int i) {
                Object object = ic.l0(objects);
                if (!(object instanceof KeyValuePair[])) {
                    throw new ArgumentException();
                }
                SortedDictionary.this.l0((KeyValuePair[])ic.l0(objects), i);
            }
        };
    }

    public ICollection getICollection() {
        return new ICollection(){

            @Override
            public int size() {
                return SortedDictionary.this.l0();
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }

            @Override
            public Object getSyncRoot() {
                return SortedDictionary.this.r2();
            }

            @Override
            public void copyTo(ic array, int index) {
                if (this.size() == 0) {
                    return;
                }
                if (array == null) {
                    throw new ArgumentNullException();
                }
                if (index < 0) {
                    throw new ArgumentOutOfRangeException();
                }
                if (array.yx() <= index) {
                    throw new ArgumentException();
                }
                if (array.yx() - index < this.size()) {
                    throw new ArgumentException();
                }
                if (!(ic.l0(array) instanceof KeyValuePair[])) {
                    throw new ArgumentException();
                }
                for (Node node : SortedDictionary.this.l0.ek()) {
                    array.r2(node.l0().Clone(), index++);
                }
            }

            @Override
            public IEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.r2()).getIEnumerator();
            }
        };
    }

    public IEnumerable getIEnumerable() {
        return new IEnumerable(){

            public IEnumerator iterator() {
                return new Enumerator(SortedDictionary.this.r2()).getIEnumerator();
            }
        };
    }

    public IGenericEnumerable<KeyValuePair<TKey, TValue>> getIGenericEnumerable() {
        return new IGenericEnumerable<KeyValuePair<TKey, TValue>>(){

            @Override
            public IGenericEnumerator<KeyValuePair<TKey, TValue>> iterator() {
                return new Enumerator(SortedDictionary.this.r2());
            }
        };
    }

    SortedDictionary<TKey, TValue> r2() {
        return this;
    }

    public static class Enumerator<TKey, TValue>
    extends el<Enumerator>
    implements IGenericEnumerator<KeyValuePair<TKey, TValue>>,
    IDisposable {
        private RBTree.NodeEnumerator ql = new RBTree.NodeEnumerator();
        private KeyValuePair<TKey, TValue> r2 = new KeyValuePair();

        public Enumerator() {
        }

        Enumerator(SortedDictionary<TKey, TValue> dic) {
            this();
            ((SortedDictionary)dic).l0.ic().CloneTo(this.ql);
        }

        KeyValuePair<TKey, TValue> l0() {
            return this.r2;
        }

        @Override
        public KeyValuePair<TKey, TValue> next() {
            return this.l0();
        }

        boolean ql() {
            if (!this.ql.hasNext()) {
                return false;
            }
            ((Node)this.ql.next()).l0().CloneTo(this.r2);
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.ql();
        }

        @Override
        public void dispose() {
            this.ql.dispose();
        }

        private Node yx() {
            this.ql.ql();
            return (Node)this.ql.next();
        }

        public IDictionaryEnumerator getIDictionaryEnumerator() {
            return new IDictionaryEnumerator(){

                @Override
                public DictionaryEntry getEntry() {
                    return Enumerator.this.yx().ql();
                }

                @Override
                public Object getKey() {
                    return ((Enumerator)Enumerator.this).yx().l0;
                }

                @Override
                public Object getValue() {
                    return ((Enumerator)Enumerator.this).yx().ql;
                }

                @Override
                public Object next() {
                    return Enumerator.this.l0();
                }

                @Override
                public boolean hasNext() {
                    return Enumerator.this.ql();
                }

                @Override
                public void reset() {
                    Enumerator.this.r2();
                }

                @Override
                public void remove() {
                    Enumerator.this.ic();
                }
            };
        }

        public IEnumerator getIEnumerator() {
            return new IEnumerator(){

                @Override
                public Object next() {
                    return Enumerator.this.yx().l0();
                }

                @Override
                public boolean hasNext() {
                    return Enumerator.this.ql();
                }

                @Override
                public void reset() {
                    Enumerator.this.r2();
                }

                @Override
                public void remove() {
                    Enumerator.this.ic();
                }
            };
        }

        void r2() {
            this.ql.reset();
        }

        @Override
        public void reset() {
            this.r2();
        }

        void ic() {
            throw new NotSupportedException();
        }

        @Override
        public void remove() {
            this.ic();
        }

        @Override
        public void CloneTo(Enumerator that) {
            this.ql.CloneTo(that.ql);
            this.r2.CloneTo(that.r2);
        }

        @Override
        public Enumerator Clone() {
            Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean ql(Enumerator enumerator) {
            return qu.l0(enumerator.ql, this.ql) && qu.l0(enumerator.r2, this.r2);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.ql((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.ql != null ? this.ql.hashCode() : 0;
            n = 31 * n + (this.r2 != null ? this.r2.hashCode() : 0);
            return n;
        }
    }

    @u1
    public static final class KeyCollection<TKey, TValue>
    implements IGenericCollection<TKey>,
    IGenericEnumerable<TKey> {
        private SortedDictionary<TKey, TValue> l0;

        public KeyCollection(SortedDictionary<TKey, TValue> dictionary) {
            this.l0 = dictionary;
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        void l0(TKey[] TKeyArray, int n) {
            if (this.size() == 0) {
                return;
            }
            if (TKeyArray == null) {
                throw new ArgumentNullException();
            }
            if (n < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (TKeyArray.length <= n) {
                throw new ArgumentException();
            }
            if (TKeyArray.length - n < this.size()) {
                throw new ArgumentException();
            }
            for (Node node : ((SortedDictionary)this.l0).l0.ek()) {
                TKeyArray[n++] = node.l0;
            }
        }

        public void copyTo(TKey[] array, int index) {
            this.l0(array, index);
        }

        public Enumerator<TKey, TValue> iterator() {
            return new Enumerator<TKey, TValue>(this.l0);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(TKey tKey) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public boolean containsItem(TKey item) {
            return this.l0.containsKey(item);
        }

        @Override
        public void copyToTArray(TKey[] tKeys, int i) {
            this.l0(tKeys, i);
        }

        @Override
        public boolean removeItem(TKey tKey) {
            throw new NotSupportedException();
        }

        public ICollection getICollection() {
            return new ICollection(){

                @Override
                public int size() {
                    return KeyCollection.this.l0.size();
                }

                @Override
                public boolean isSynchronized() {
                    return false;
                }

                @Override
                public Object getSyncRoot() {
                    return KeyCollection.this.l0();
                }

                @Override
                public void copyTo(ic array, int index) {
                    if (this.size() == 0) {
                        return;
                    }
                    if (array == null) {
                        throw new ArgumentNullException();
                    }
                    if (index < 0 || array.yx() <= index) {
                        throw new ArgumentOutOfRangeException();
                    }
                    if (array.yx() - index < this.size()) {
                        throw new ArgumentException();
                    }
                    for (Node node : KeyCollection.this.l0.l0.ek()) {
                        array.r2(node.l0, index++);
                    }
                }

                @Override
                public IEnumerator iterator() {
                    return new Enumerator(KeyCollection.this.l0).getIEnumerator();
                }
            };
        }

        public IEnumerable getIEnumerable() {
            return new IEnumerable(){

                public IEnumerator iterator() {
                    return new Enumerator(KeyCollection.this.l0).getIEnumerator();
                }
            };
        }

        Object l0() {
            return this.l0;
        }

        public static class Enumerator<TKey, TValue>
        extends el<Enumerator>
        implements IGenericEnumerator<TKey>,
        IDisposable {
            private RBTree.NodeEnumerator ql = new RBTree.NodeEnumerator();
            private TKey r2;

            public Enumerator() {
            }

            Enumerator(SortedDictionary<TKey, TValue> dic) {
                this();
                ((SortedDictionary)dic).l0.ic().CloneTo(this.ql);
            }

            TKey l0() {
                return this.r2;
            }

            @Override
            public TKey next() {
                return this.l0();
            }

            boolean ql() {
                if (!this.ql.hasNext()) {
                    return false;
                }
                this.r2 = ((Node)this.ql.next()).l0;
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.ql();
            }

            @Override
            public void dispose() {
                this.ql.dispose();
            }

            public IEnumerator getIEnumerator() {
                return new IEnumerator(){

                    @Override
                    public Object next() {
                        Enumerator.this.ql.ql();
                        return Enumerator.this.r2;
                    }

                    @Override
                    public boolean hasNext() {
                        return Enumerator.this.ql();
                    }

                    @Override
                    public void reset() {
                        Enumerator.this.r2();
                    }

                    @Override
                    public void remove() {
                        Enumerator.this._remove();
                    }
                };
            }

            void r2() {
                this.ql.reset();
            }

            @Override
            public void reset() {
                this.r2();
            }

            public void _remove() {
                throw new NotSupportedException();
            }

            @Override
            public void remove() {
                this._remove();
            }

            @Override
            public void CloneTo(Enumerator that) {
                this.ql.CloneTo(that.ql);
                that.r2 = this.r2;
            }

            @Override
            public Enumerator Clone() {
                Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
                this.CloneTo(enumerator);
                return enumerator;
            }

            public Object clone() {
                return this.Clone();
            }

            private boolean r2(Enumerator enumerator) {
                return qu.l0(enumerator.ql, this.ql) && qu.l0(enumerator.r2, this.r2);
            }

            public boolean equals(Object obj) {
                assert (obj != null);
                if (qu.ql(null, obj)) {
                    return false;
                }
                if (qu.ql(this, obj)) {
                    return true;
                }
                if (!(obj instanceof Enumerator)) {
                    return false;
                }
                return this.r2((Enumerator)obj);
            }

            public static boolean equals(Enumerator obj1, Enumerator obj2) {
                return obj1.equals(obj2);
            }

            public int hashCode() {
                int n = this.ql != null ? this.ql.hashCode() : 0;
                n = 31 * n + (this.r2 != null ? this.r2.hashCode() : 0);
                return n;
            }
        }
    }

    @u1
    public static final class ValueCollection<TKey, TValue>
    implements IGenericCollection<TValue>,
    IGenericEnumerable<TValue> {
        private SortedDictionary<TKey, TValue> l0;

        public ValueCollection(SortedDictionary<TKey, TValue> dictionary) {
            this.l0 = dictionary;
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        void l0(TValue[] TValueArray, int n) {
            if (this.size() == 0) {
                return;
            }
            if (TValueArray == null) {
                throw new ArgumentNullException();
            }
            if (n < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (TValueArray.length <= n) {
                throw new ArgumentException();
            }
            if (TValueArray.length - n < this.size()) {
                throw new ArgumentException();
            }
            for (Node node : ((SortedDictionary)this.l0).l0.ek()) {
                TValueArray[n++] = node.ql;
            }
        }

        public void copyTo(TValue[] array, int index) {
            this.l0(array, index);
        }

        public Enumerator<TKey, TValue> iterator() {
            return new Enumerator<TKey, TValue>(this.l0);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(TValue tValue) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public boolean containsItem(TValue item) {
            return this.l0.containsValue(item);
        }

        @Override
        public void copyToTArray(TValue[] tValues, int i) {
            this.l0(tValues, i);
        }

        @Override
        public boolean removeItem(TValue tValue) {
            throw new NotSupportedException();
        }

        public ICollection getICollection() {
            return new ICollection(){

                @Override
                public int size() {
                    return ValueCollection.this.l0.size();
                }

                @Override
                public boolean isSynchronized() {
                    return false;
                }

                @Override
                public Object getSyncRoot() {
                    return ValueCollection.this.l0;
                }

                @Override
                public void copyTo(ic array, int index) {
                    if (this.size() == 0) {
                        return;
                    }
                    if (array == null) {
                        throw new ArgumentNullException();
                    }
                    if (index < 0 || array.yx() <= index) {
                        throw new ArgumentOutOfRangeException();
                    }
                    if (array.yx() - index < this.size()) {
                        throw new ArgumentException();
                    }
                    for (Node node : ValueCollection.this.l0.l0.ek()) {
                        array.r2(node.ql, index++);
                    }
                }

                @Override
                public IEnumerator iterator() {
                    return new Enumerator(ValueCollection.this.l0).getIEnumerator();
                }
            };
        }

        public IEnumerable getIEnumerable() {
            return new IEnumerable(){

                public IEnumerator iterator() {
                    return new Enumerator(ValueCollection.this.l0).getIEnumerator();
                }
            };
        }

        public static class Enumerator<TKey, TValue>
        extends el<Enumerator>
        implements IGenericEnumerator<TValue>,
        IDisposable {
            private RBTree.NodeEnumerator ql = new RBTree.NodeEnumerator();
            private TValue r2;

            public Enumerator() {
            }

            Enumerator(SortedDictionary<TKey, TValue> dictionary) {
                this();
                ((SortedDictionary)dictionary).l0.ic().CloneTo(this.ql);
            }

            TValue l0() {
                return this.r2;
            }

            @Override
            public TValue next() {
                return this.l0();
            }

            boolean ql() {
                if (!this.ql.hasNext()) {
                    return false;
                }
                this.r2 = ((Node)this.ql.next()).ql;
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.ql();
            }

            @Override
            public void dispose() {
                this.ql.dispose();
            }

            public IEnumerator getIEnumerator() {
                return new IEnumerator(){

                    @Override
                    public Object next() {
                        Enumerator.this.ql.ql();
                        return Enumerator.this.r2;
                    }

                    @Override
                    public boolean hasNext() {
                        return Enumerator.this.ql();
                    }

                    @Override
                    public void reset() {
                        Enumerator.this.r2();
                    }

                    @Override
                    public void remove() {
                        Enumerator.this.ic();
                    }
                };
            }

            void r2() {
                this.ql.reset();
            }

            @Override
            public void reset() {
                this.r2();
            }

            void ic() {
                throw new NotSupportedException();
            }

            @Override
            public void remove() {
                this.ic();
            }

            @Override
            public void CloneTo(Enumerator that) {
                this.ql.CloneTo(that.ql);
                that.r2 = this.r2;
            }

            @Override
            public Enumerator Clone() {
                Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>();
                this.CloneTo(enumerator);
                return enumerator;
            }

            public Object clone() {
                return this.Clone();
            }

            private boolean r2(Enumerator enumerator) {
                return qu.l0(enumerator.ql, this.ql) && qu.l0(enumerator.r2, this.r2);
            }

            public boolean equals(Object obj) {
                assert (obj != null);
                if (qu.ql(null, obj)) {
                    return false;
                }
                if (qu.ql(this, obj)) {
                    return true;
                }
                if (!(obj instanceof Enumerator)) {
                    return false;
                }
                return this.r2((Enumerator)obj);
            }

            public static boolean equals(Enumerator obj1, Enumerator obj2) {
                return obj1.equals(obj2);
            }

            public int hashCode() {
                int n = this.ql != null ? this.ql.hashCode() : 0;
                n = 31 * n + (this.r2 != null ? this.r2.hashCode() : 0);
                return n;
            }
        }
    }

    @u1
    private static class NodeHelper<TKey>
    implements RBTree.INodeHelper<TKey> {
        public Comparator<TKey> l0;
        static NodeHelper ql = new NodeHelper(Comparer.getDefault());

        @Override
        public int compare(TKey key, RBTree.Node node) {
            return this.l0.compare(key, ((Node)node).l0);
        }

        @Override
        public RBTree.Node createNode(TKey key) {
            return new Node(key);
        }

        private NodeHelper(Comparator<TKey> cmp) {
            this.l0 = cmp;
        }

        public static NodeHelper l0(Comparator comparator) {
            if (comparator == null || comparator == Comparer.getDefault()) {
                return ql;
            }
            return new NodeHelper(comparator);
        }
    }

    private static class Node<TKey, TValue>
    extends RBTree.Node {
        public TKey l0;
        public TValue ql;

        public Node(TKey key) {
            this.l0 = key;
        }

        public Node(TKey key, TValue value) {
            this.l0 = key;
            this.ql = value;
        }

        @Override
        public void swapValue(RBTree.Node other) {
            Node node = (Node)other;
            TKey TKey = this.l0;
            this.l0 = node.l0;
            node.l0 = TKey;
            TValue TValue = this.ql;
            this.ql = node.ql;
            node.ql = TValue;
        }

        public KeyValuePair<TKey, TValue> l0() {
            return new KeyValuePair<TKey, TValue>(this.l0, this.ql);
        }

        public DictionaryEntry ql() {
            return new DictionaryEntry(this.l0, this.ql);
        }
    }
}

