/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IChartDataPoint;
import com.aspose.slides.IChartDataPointCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.IPieSplitCustomPointCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.qn;

public class PieSplitCustomPointCollection
implements IPieSplitCustomPointCollection {
    private final IChartSeriesGroup l0;
    private final List<IChartDataPoint> ql;

    @Override
    public final IChartDataPoint get_Item(int index) {
        return this.ql.get_Item(index);
    }

    @Override
    public final void add(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.l0.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(qn.l0("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        IChartDataPoint iChartDataPoint = iChartDataPointCollection.get_Item(dataPointIndex);
        if (this.ql.containsItem(iChartDataPoint)) {
            throw new ArgumentException("Data point is already added");
        }
        this.ql.addItem(iChartDataPoint);
    }

    @Override
    public void addItem(IChartDataPoint dataPoint) {
        this.l0(dataPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void l0(IChartDataPoint iChartDataPoint) {
        IChartDataPointCollection iChartDataPointCollection = this.l0.get_Item(0).getDataPoints();
        IGenericEnumerator iGenericEnumerator = iChartDataPointCollection.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IChartDataPoint iChartDataPoint2 = (IChartDataPoint)iGenericEnumerator.next();
                if (iChartDataPoint2 != iChartDataPoint) continue;
                this.ql.addItem(iChartDataPoint);
                return;
            }
        }
        finally {
            if (r2.l0(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        throw new ArgumentException("Coudn't find dataPoint in parent series. Allowed adding dataPoint only from same chart and parent series");
    }

    @Override
    public boolean removeItem(IChartDataPoint dataPoint) {
        return this.ql(dataPoint);
    }

    final boolean ql(IChartDataPoint iChartDataPoint) {
        return this.ql.removeItem(iChartDataPoint);
    }

    @Override
    public final void remove(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.l0.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(qn.l0("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        this.ql.removeItem(iChartDataPointCollection.get_Item(dataPointIndex));
    }

    @Override
    public final void clear() {
        this.ql.clear();
    }

    @Override
    public boolean containsItem(IChartDataPoint item) {
        return this.r2(item);
    }

    final boolean r2(IChartDataPoint iChartDataPoint) {
        return this.ql.containsItem(iChartDataPoint);
    }

    public void copyToTArray(IChartDataPoint[] array, int arrayIndex) {
        this.l0(array, arrayIndex);
    }

    final void l0(IChartDataPoint[] iChartDataPointArray, int n) {
        this.ql.copyToTArray((IChartDataPoint[])iChartDataPointArray, n);
    }

    @Override
    public final int size() {
        return this.ql.size();
    }

    @Override
    public final boolean isReadOnly() {
        return this.ql.isReadOnly();
    }

    public final boolean isSynchronized() {
        return false;
    }

    public final Object getSyncRoot() {
        return this;
    }

    @Override
    public final IGenericEnumerator<IChartDataPoint> iterator() {
        return this.ql.iterator();
    }

    public final IGenericEnumerator<IChartDataPoint> iteratorJava() {
        return this.ql.iteratorJava();
    }

    PieSplitCustomPointCollection(IChartSeriesGroup parentSeriesGroup) {
        this.l0 = parentSeriesGroup;
        this.ql = new List();
    }
}

