/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.gd;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.yl;

@yl
public final class BitArray
implements ICollection,
gd {
    private int[] pf;
    private int aa;
    private int r3 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.aa = bits.aa;
        this.pf = new int[(this.aa + 31) / 32];
        if (this.pf.length == 1) {
            this.pf[0] = bits.pf[0];
        } else {
            ik.pf(bits.pf, 0, this.pf, 0, this.pf.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.aa = values.length;
        this.pf = new int[(this.aa + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.aa = bytes.length * 8;
        this.pf = new int[(this.aa + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.pf(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.aa = n * 32;
        this.pf = new int[n];
        ik.pf(values, 0, this.pf, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.aa = length;
        this.pf = new int[(this.aa + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.pf.length; ++i) {
                this.pf[i] = -1;
            }
        }
    }

    private byte pf(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.pf[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void pf(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.pf[n12] = this.pf[n12] & ~(255 << n11);
        int n13 = n10;
        this.pf[n13] = this.pf[n13] | (by2 & 0xFF) << n11;
        ++this.r3;
    }

    private void aa(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.aa != this.aa) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.aa;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.aa;
    }

    public void setLength(int value) {
        if (this.aa == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.aa) {
            int n = (value + 31) / 32;
            int n10 = (this.aa + 31) / 32;
            if (n > this.pf.length) {
                int[] nArray = new int[n];
                ik.pf(this.pf, 0, nArray, 0, this.pf.length);
                this.pf = nArray;
            } else {
                ik.pf(ik.pf((Object)this.pf), n10, n - n10);
            }
            int n11 = this.aa % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.pf[n12] = this.pf[n12] & (1 << n11) - 1;
            }
        }
        this.aa = value;
        ++this.r3;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(ik array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ik() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.pd() && this.aa > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = ik.pf(array);
        if (object instanceof Boolean[]) {
            if (array.pd() - index < this.aa) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.aa; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.pd() - index < this.aa) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.aa; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.aa + 7) / 8;
            if (array.pd() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.pf(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.aa + 7) / 8;
            if (array.pd() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.pf(i);
            }
        } else if (object instanceof Integer[]) {
            ik.pf(ik.pf((Object)this.pf), 0, array, index, (this.aa + 31) / 32);
        } else if (object instanceof int[]) {
            ik.pf(ik.pf((Object)this.pf), 0, array, index, (this.aa + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.aa + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.pf[i] = ~this.pf[i];
        }
        ++this.r3;
        return this;
    }

    public BitArray and(BitArray value) {
        this.aa(value);
        int n = (this.aa + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.pf[n10] = this.pf[n10] & value.pf[i];
        }
        ++this.r3;
        return this;
    }

    public BitArray or(BitArray value) {
        this.aa(value);
        int n = (this.aa + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.pf[n10] = this.pf[n10] | value.pf[i];
        }
        ++this.r3;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.aa(value);
        int n = (this.aa + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.pf[n10] = this.pf[n10] ^ value.pf[i];
        }
        ++this.r3;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.aa) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.pf[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.aa) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.pf[n] = this.pf[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.pf[n] = this.pf[n] & ~(1 << (index & 0x1F));
        }
        ++this.r3;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.pf.length; ++i) {
                this.pf[i] = -1;
            }
        } else {
            ik.pf(ik.pf((Object)this.pf), 0, this.pf.length);
        }
        ++this.r3;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @yl
    private static class BitArrayEnumerator
    implements IEnumerator,
    gd,
    Cloneable {
        private BitArray pf;
        private boolean aa;
        private int r3;
        private int ik;

        @Override
        public Object deepClone() {
            return this.pf();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.r3 = -1;
            this.pf = ba2;
            this.ik = ba2.r3;
        }

        @Override
        public Object next() {
            if (this.r3 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.r3 >= this.pf.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.aa;
        }

        @Override
        public boolean hasNext() {
            this.aa();
            if (this.r3 < this.pf.size() - 1) {
                this.aa = this.pf.get_Item(++this.r3);
                return true;
            }
            this.r3 = this.pf.size();
            return false;
        }

        @Override
        public void reset() {
            this.aa();
            this.r3 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void aa() {
            if (this.ik != this.pf.r3) {
                throw new InvalidOperationException();
            }
        }

        protected Object pf() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.pf = this.pf;
            bitArrayEnumerator.aa = this.aa;
            bitArrayEnumerator.r3 = this.r3;
            bitArrayEnumerator.ik = this.ik;
            return bitArrayEnumerator;
        }
    }
}

