/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.nr.iz;
import com.aspose.slides.internal.nr.r3;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.ka;
import com.aspose.slides.ms.System.rg;
import com.aspose.slides.ms.System.yl;
import java.util.Arrays;

@yl
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] pf;
    private int aa;
    private int r3;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.pf = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.aa = collection.size();
            this.pf = new Object[this.aa];
            collection.copyToTArray(this.pf, 0);
        }
    }

    public void clear() {
        if (this.pf != null) {
            ik.pf(this.pf, 0, this.pf.length);
        }
        this.aa = 0;
        ++this.r3;
    }

    public boolean contains(T item) {
        return this.pf != null && ik.pf(this.pf, item, 0, this.aa) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.aa - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.pf != null) {
            ik.pf(this.pf, 0, array, arrayIndex, this.aa);
            ka.pf(array, arrayIndex, this.aa);
        }
    }

    public T peek() {
        if (this.aa == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.pf[this.aa - 1];
    }

    public T pop() {
        if (this.aa == 0) {
            throw new InvalidOperationException();
        }
        ++this.r3;
        Object object = this.pf[--this.aa];
        this.pf[this.aa] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.pf == null || this.aa == this.pf.length) {
            if (this.pf == null) {
                this.pf = new Object[16];
            }
            this.pf = Arrays.copyOf(this.pf, this.aa == 0 ? 16 : 2 * this.aa);
        }
        ++this.r3;
        this.pf[this.aa++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.aa) {
            this.copyTo(ik.pf(array), 0);
            return array;
        }
        ik ik2 = ik.pf(com.aspose.slides.internal.nr.r3.pf(array.getClass().getComponentType()), this.aa);
        this.copyTo(ik2, 0);
        return (Object[])ik.pf(ik2);
    }

    public void trimExcess() {
        if (this.pf != null && (double)this.aa < (double)this.pf.length * 0.9) {
            this.pf = Arrays.copyOf(this.pf, this.aa);
        }
        ++this.r3;
    }

    @Override
    public int size() {
        return this.aa;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ik dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.pf != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.aa) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.aa - idx > dest.pd()) {
                    throw new ArgumentException("idx");
                }
                ik.pf(ik.pf(this.pf), 0, dest, idx, this.aa);
                ik.aa(dest, idx, this.aa);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @yl
    public static class Enumerator<T>
    extends iz<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> aa;
        private int r3;
        private int ik;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.aa = t;
            this.r3 = -2;
            this.ik = ((Stack)t).r3;
        }

        @Override
        public void dispose() {
            this.r3 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.ik != ((Stack)this.aa).r3) {
                throw new IllegalStateException();
            }
            if (this.r3 == -2) {
                this.r3 = ((Stack)this.aa).aa;
            }
            return this.r3 != -1 && --this.r3 != -1;
        }

        @Override
        public T next() {
            if (this.r3 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.aa).pf[this.r3];
        }

        @Override
        public void reset() {
            if (this.ik != ((Stack)this.aa).r3) {
                throw new IllegalStateException();
            }
            this.r3 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.aa = this.aa;
            that.r3 = this.r3;
            that.ik = this.ik;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean pf(Enumerator enumerator) {
            return rg.pf(enumerator.aa, this.aa) && enumerator.r3 == this.r3 && enumerator.ik == this.ik;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (rg.aa(null, obj)) {
                return false;
            }
            if (rg.aa(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.pf((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.aa != null ? this.aa.hashCode() : 0;
            n = 31 * n + this.r3;
            n = 31 * n + this.ik;
            return n;
        }
    }
}

