/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IMathElement;
import com.aspose.slides.IMathMatrix;
import com.aspose.slides.MathElementBase;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.inc;
import com.aspose.slides.internal.nr.r3;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.q0;

public final class MathMatrix
extends MathElementBase
implements IMathMatrix,
q0 {
    private boolean ik;
    private int pd;
    private long ni;
    private int iz;
    private long nq;
    private int aw;
    private long kn;
    private final List<List<IMathElement>> es;
    private int[] vt;
    final inc pf;

    @Override
    public final int getRowCount() {
        return this.es.size();
    }

    @Override
    public final int getColumnCount() {
        return this.es.get_Item(0).size();
    }

    @Override
    public final boolean getHidePlaceholders() {
        return this.ik;
    }

    @Override
    public final void setHidePlaceholders(boolean value) {
        this.ik = value;
    }

    @Override
    public final int getBaseJustification() {
        return this.pd;
    }

    @Override
    public final void setBaseJustification(int value) {
        this.pd = value;
    }

    @Override
    public final long getMinColumnWidth() {
        return this.ni;
    }

    @Override
    public final void setMinColumnWidth(long value) {
        this.ni = value;
    }

    @Override
    public final int getColumnGapRule() {
        return this.iz;
    }

    @Override
    public final void setColumnGapRule(int value) {
        this.iz = value;
    }

    @Override
    public final long getColumnGap() {
        return this.nq;
    }

    @Override
    public final void setColumnGap(long value) {
        this.nq = value;
    }

    @Override
    public final int getRowGapRule() {
        return this.aw;
    }

    @Override
    public final void setRowGapRule(int value) {
        this.aw = value;
    }

    @Override
    public final long getRowGap() {
        return this.kn;
    }

    @Override
    public final void setRowGap(long value) {
        this.kn = value;
    }

    @Override
    public final IMathElement get_Item(int row, int column) {
        return this.es.get_Item(row).get_Item(column);
    }

    @Override
    public final void set_Item(int row, int column, IMathElement value) {
        this.es.get_Item(row).set_Item(column, value);
    }

    @Override
    public final inc getControlCharacterProperties() {
        return this.pf;
    }

    public MathMatrix(int rowCount, int columnCount) {
        if (rowCount < 1) {
            throw new ArgumentOutOfRangeException("rowCount");
        }
        if (columnCount < 1) {
            throw new ArgumentOutOfRangeException("columnCount");
        }
        this.es = new List(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.es.addItem(this.pf(columnCount));
        }
        this.setHidePlaceholders(false);
        this.setBaseJustification(2);
        this.setMinColumnWidth(0L);
        this.setColumnGapRule(0);
        this.vt = new int[columnCount];
        this.setColumnsAlignment(0, (long)this.vt.length & 0xFFFFFFFFL, 2);
        this.pf = new inc();
    }

    @Override
    public final int getColumnAlignment(int columnIndex) {
        if (columnIndex < 0) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        return this.vt[columnIndex];
    }

    @Override
    public final void setColumnAlignment(int columnIndex, int val) {
        this.setColumnsAlignment(columnIndex, 1L, val);
    }

    @Override
    public final void setColumnsAlignment(int columnIndex, long columnsCount, int val) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if ((columnsCount & 0xFFFFFFFFL) < 0L || ((long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL) > (long)this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnsCount");
        }
        long l = (long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n = columnIndex;
        while ((long)n < l) {
            this.vt[n] = val;
            ++n;
        }
    }

    @Override
    public final void insertRowBefore(int rowIndex) {
        this.es.insertItem(rowIndex, this.pf(this.getColumnCount()));
    }

    @Override
    public final void insertRowAfter(int rowIndex) {
        this.insertRowBefore(rowIndex + 1);
    }

    @Override
    public final void deleteRow(int rowIndex) {
        if (this.getRowCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing row in the matrix");
        }
        this.es.removeAt(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertColumnBefore(int columnIndex) {
        IGenericEnumerator iGenericEnumerator = this.es.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.insertItem(columnIndex, null);
            }
        }
        finally {
            if (com.aspose.slides.internal.nr.r3.pf(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public final void insertColumnAfter(int columnIndex) {
        this.insertColumnBefore(columnIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteColumn(int columnIndex) {
        if (this.getColumnCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing column in the matrix");
        }
        IGenericEnumerator iGenericEnumerator = this.es.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.removeAt(columnIndex);
            }
        }
        finally {
            if (com.aspose.slides.internal.nr.r3.pf(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IMathElement[] getChildren() {
        Object object;
        IGenericEnumerator iGenericEnumerator;
        IMathElement[] iMathElementArray;
        int n = 0;
        IGenericEnumerator iGenericEnumerator2 = this.es.iterator();
        try {
            while (iGenericEnumerator2.hasNext()) {
                iMathElementArray = (IMathElement[])iGenericEnumerator2.next();
                iGenericEnumerator = iMathElementArray.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        object = (IMathElement)iGenericEnumerator.next();
                        if (object == null) continue;
                        ++n;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.nr.r3.pf(iGenericEnumerator, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        finally {
            if (com.aspose.slides.internal.nr.r3.pf(iGenericEnumerator2, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator2).dispose();
            }
        }
        if (n == 0) {
            return r3;
        }
        iMathElementArray = new IMathElement[n];
        n = 0;
        iGenericEnumerator = this.es.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object = (List)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator3 = ((List)object).iterator();
                try {
                    while (iGenericEnumerator3.hasNext()) {
                        IMathElement iMathElement = (IMathElement)iGenericEnumerator3.next();
                        if (iMathElement == null) continue;
                        iMathElementArray[n++] = iMathElement;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.nr.r3.pf(iGenericEnumerator3, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator3).dispose();
                }
            }
            return iMathElementArray;
        }
        finally {
            if (com.aspose.slides.internal.nr.r3.pf(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private List<IMathElement> pf(int n) {
        List<IMathElement> list = new List<IMathElement>(n);
        for (int i = 0; i < n; ++i) {
            list.addItem(null);
        }
        return list;
    }
}

