/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.a9;

@a9
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> b6;
    private IGenericEqualityComparer<TKey> t8;
    private int sj;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.t8 = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.sj = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.b6 = new Dictionary(this.t8);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.b6 != null) {
            return this.b6.containsKey(key);
        }
        return this.b6(key) >= 0;
    }

    private int b6(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.t8.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.b6 != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.b6.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.b6(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.t8;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.b6 != null && ((Dictionary.KeyCollection)this.b6.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.b6.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.b6 != null) {
            return this.b6.get_Item(key);
        }
        int n = this.b6(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.t8.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.b6 != null) {
            if (!this.b6.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.b6.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.b6 != null) {
            this.b6.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.b6 != null && this.b6.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.b6 == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.t8.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.b6 != null) {
            this.b6.addItem(TKey, item);
        } else if (this.sj != -1 && this.size() > this.sj) {
            this.b6 = new Dictionary(this.t8);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.b6.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.b6 != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.b6.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.b6 != null) {
            this.b6.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.b6.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.b6;
    }
}

