/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.n0;
import java.util.Arrays;

@a9
public class Queue
implements ICollection,
IEnumerable,
n0 {
    private Object[] b6;
    private int t8 = 0;
    private int sj = 0;
    private int ma = 0;
    private int zn;
    private int yc = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.b6 = new Object[capacity];
        this.zn = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.sj;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ma array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ma() > 1 || index != 0 && index >= array.zn() || this.sj > array.zn() - index) {
            throw new ArgumentException();
        }
        int n = this.b6.length;
        int n10 = n - this.t8;
        com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6), this.t8, array, index, Math.min(this.sj, n10));
        if (this.sj > n10) {
            com.aspose.slides.ms.System.ma.b6(com.aspose.slides.ms.System.ma.b6(this.b6), 0, array, index + n10, this.sj - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.b6.length);
        queue.zn = this.zn;
        com.aspose.slides.ms.System.ma.b6(this.b6, 0, queue.b6, 0, this.b6.length);
        queue.t8 = this.t8;
        queue.sj = this.sj;
        queue.ma = this.ma;
        return queue;
    }

    public void clear() {
        ++this.yc;
        this.t8 = 0;
        this.sj = 0;
        this.ma = 0;
        for (int i = this.b6.length - 1; i >= 0; --i) {
            this.b6[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.t8 + this.sj;
        if (obj == null) {
            for (int i = this.t8; i < n; ++i) {
                if (this.b6[i % this.b6.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.t8; i < n; ++i) {
                if (!obj.equals(this.b6[i % this.b6.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.yc;
        if (this.sj < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.b6[this.t8];
        this.b6[this.t8] = null;
        this.t8 = (this.t8 + 1) % this.b6.length;
        --this.sj;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.yc;
        if (this.sj == this.b6.length) {
            this.b6();
        }
        this.b6[this.ma] = obj;
        this.ma = (this.ma + 1) % this.b6.length;
        ++this.sj;
    }

    public Object peek() {
        if (this.sj < 1) {
            throw new InvalidOperationException();
        }
        return this.b6[this.t8];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.sj) {
            return Arrays.copyOf(this.b6, this.sj, a.getClass());
        }
        System.arraycopy(this.b6, 0, a, 0, this.sj);
        if (a.length > this.sj) {
            a[this.sj] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.yc;
        Object[] objectArray = new Object[this.sj];
        this.copyTo(com.aspose.slides.ms.System.ma.b6(objectArray), 0);
        this.b6 = objectArray;
        this.t8 = 0;
        this.ma = 0;
    }

    private void b6() {
        int n = this.b6.length * this.zn / 100;
        if (n < this.b6.length + 1) {
            n = this.b6.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.ma.b6(objectArray), 0);
        this.b6 = objectArray;
        this.t8 = 0;
        this.ma = this.t8 + this.sj;
    }

    @a9
    private static class QueueEnumerator
    implements IEnumerator,
    n0 {
        private Queue b6;
        private int t8;
        private int sj;

        QueueEnumerator(Queue q) {
            this.b6 = q;
            this.t8 = q.yc;
            this.sj = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.b6);
            queueEnumerator.t8 = this.t8;
            queueEnumerator.sj = this.sj;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.t8 != this.b6.yc || this.sj < 0 || this.sj >= this.b6.sj) {
                throw new InvalidOperationException();
            }
            return this.b6.b6[(this.b6.t8 + this.sj) % this.b6.b6.length];
        }

        @Override
        public boolean hasNext() {
            if (this.t8 != this.b6.yc) {
                throw new InvalidOperationException();
            }
            if (this.sj >= this.b6.sj - 1) {
                this.sj = Integer.MAX_VALUE;
                return false;
            }
            ++this.sj;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.t8 != this.b6.yc) {
                throw new InvalidOperationException();
            }
            this.sj = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue b6;

        SyncQueue(Queue queue) {
            this.b6 = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.b6;
            synchronized (queue) {
                return this.b6.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array, int index) {
            Queue queue = this.b6;
            synchronized (queue) {
                this.b6.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.b6;
            synchronized (queue) {
                return this.b6.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.b6;
            synchronized (queue) {
                return new SyncQueue((Queue)this.b6.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.b6;
            synchronized (queue) {
                this.b6.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.b6;
            synchronized (queue) {
                this.b6.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.b6;
            synchronized (queue) {
                return this.b6.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.b6;
            synchronized (queue) {
                return this.b6.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.b6;
            synchronized (queue) {
                this.b6.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.b6;
            synchronized (queue) {
                return this.b6.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.b6;
            synchronized (queue) {
                return this.b6.toArray(a);
            }
        }
    }
}

