/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.d1.dd;
import com.aspose.slides.ms.System.a9;
import com.aspose.slides.ms.System.h7;
import com.aspose.slides.ms.System.ht;
import com.aspose.slides.ms.System.k8;
import com.aspose.slides.ms.System.ma;
import com.aspose.slides.ms.System.n0;
import java.util.Comparator;

@a9
public class SortedList
implements IDictionary,
n0 {
    private final Object b6 = new Object();
    private Slot[] t8;
    private Comparator sj;
    private int ma;
    private int zn;
    private int yc;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.yc = capacity == 0 ? 0 : 16;
        this.sj = comparer;
        this.t8(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.sj = comparer;
        this.t8(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.t8(d.size(), true);
        this.sj = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.ma;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.b6;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.b6(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.t8(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.b6(key, value, true);
    }

    public int getCapacity() {
        return this.t8.length;
    }

    public void setCapacity(int value) {
        int n = this.t8.length;
        if (this.ma > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.b6(this.yc);
            SortedList.b6(this.t8, 0, slotArray, 0, this.ma);
            this.t8 = slotArray;
        } else if (value > this.ma) {
            Slot[] slotArray = SortedList.b6(value);
            SortedList.b6(this.t8, 0, slotArray, 0, this.ma);
            this.t8 = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.b6(value);
            SortedList.b6(this.t8, 0, slotArray, 0, n);
            this.t8 = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.b6(key, value, false);
    }

    @Override
    public void clear() {
        this.yc = 16;
        this.t8 = SortedList.b6(this.yc);
        this.ma = 0;
        ++this.zn;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.t8(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(ma array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.ma() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.zn()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.zn() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.sj(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.sj);
        sortedList.zn = this.zn;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.t8;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.b6(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].b6 = null;
                slotArray[index].t8 = null;
            }
            --this.ma;
            ++this.zn;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.t8(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.ma == 0) {
            return -1;
        }
        for (int i = 0; i < this.ma; ++i) {
            Slot slot = this.t8[i].Clone();
            if (!h7.b6(value, slot.t8)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.t8[index].t8;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.t8[index].t8 = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.t8[index].b6;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.b6(this.yc, false);
        } else {
            this.b6(this.size(), true);
        }
    }

    private void b6(int n, boolean bl2) {
        Slot[] slotArray = this.t8;
        Slot[] slotArray2 = SortedList.b6(n);
        if (bl2) {
            SortedList.b6(slotArray, 0, slotArray2, 0, n);
        }
        this.t8 = slotArray2;
    }

    private void b6(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.t8;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.b6(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.b6(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.b6(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.b6(slotArray, 0, slotArray2, 0, this.size());
            }
            this.t8 = slotArray2;
        } else if (bl2) {
            SortedList.b6(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void b6(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.t8;
        int n = -1;
        try {
            n = this.t8(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = k8.b6("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].t8 = object2;
            ++this.zn;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(k8.b6(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.b6(this.size() + 1, n);
        slotArray = this.t8;
        slotArray[n].b6 = object;
        slotArray[n].t8 = object2;
        ++this.ma;
        ++this.zn;
    }

    private Object b6(Object object) {
        int n = this.t8(object);
        if (n >= 0) {
            return this.t8[n].t8;
        }
        return null;
    }

    private void t8(int n, boolean bl2) {
        if (!bl2 && n < this.yc) {
            n = this.yc;
        }
        this.t8 = SortedList.b6(n);
        this.ma = 0;
        this.zn = 0;
    }

    private void b6(ma ma2, int n, int n10) {
        if (ma2 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > ma2.zn()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            ma2.sj(enumerator.next(), n++);
        }
    }

    private int t8(Object object) {
        Slot[] slotArray = this.t8;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.sj == null ? Comparer.Default : this.sj;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].b6, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] b6(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean b6(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void b6(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.b6(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList b6;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.b6 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.b6.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.b6.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                iCollection = this.b6.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                iCollection = this.b6.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.b6(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.b6(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ma array, int arrayIndex) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.b6(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.t8(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.b6);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.b6);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                return this.b6.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.b6.getSyncRoot();
            synchronized (object) {
                this.b6.trimToSize();
            }
        }
    }

    @a9
    private static class ListValues
    implements IList {
        private SortedList b6;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.b6 = host;
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        @Override
        public void copyTo(ma array, int arrayIndex) {
            this.b6.b6(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.b6.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.b6.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.b6, 1);
        }
    }

    @a9
    private static class ListKeys
    implements IList {
        private SortedList b6;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.b6 = host;
        }

        @Override
        public int size() {
            return this.b6.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.b6.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.b6.getSyncRoot();
        }

        @Override
        public void copyTo(ma array, int arrayIndex) {
            this.b6.b6(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.b6.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.b6.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.b6.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.b6, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    n0 {
        private SortedList b6;
        private Object t8;
        private Object sj;
        private int ma;
        private int zn;
        private int yc;
        private int dd;
        private boolean p6 = false;
        private static String nn = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.b6 = host;
            this.ma = host.zn;
            this.yc = host.size();
            this.dd = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.b6.zn != this.ma || this.p6) {
                throw new IllegalStateException(nn);
            }
            this.zn = -1;
            this.t8 = null;
            this.sj = null;
        }

        @Override
        public boolean hasNext() {
            if (this.b6.zn != this.ma || this.p6) {
                throw new InvalidOperationException(nn);
            }
            return ++this.zn < this.yc;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            return new DictionaryEntry(this.t8, this.sj);
        }

        @Override
        public Object getKey() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            return this.t8;
        }

        @Override
        public Object getValue() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            return this.sj;
        }

        @Override
        public Object next() {
            if (this.b6.zn != this.ma || this.p6) {
                throw new InvalidOperationException(nn);
            }
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                if (this.zn >= this.yc) {
                    this.t8 = null;
                    this.sj = null;
                }
                throw new IllegalStateException(nn);
            }
            Slot[] slotArray = this.b6.t8;
            Slot slot = slotArray[this.zn].Clone();
            this.t8 = slot.b6;
            this.sj = slot.t8;
            switch (this.dd) {
                case 0: {
                    return this.t8;
                }
                case 1: {
                    return this.sj;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(k8.b6(new String[]{ht.getName(EnumeratorMode.class, this.dd), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.b6, this.dd);
            enumeratorJava.ma = this.ma;
            enumeratorJava.zn = this.zn;
            enumeratorJava.yc = this.yc;
            enumeratorJava.t8 = this.t8;
            enumeratorJava.sj = this.sj;
            enumeratorJava.p6 = this.p6;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    n0 {
        private SortedList b6;
        private Object t8;
        private Object sj;
        private int ma;
        private int zn;
        private int yc;
        private int dd;
        private boolean p6 = false;
        private static String nn = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.b6 = host;
            this.ma = host.zn;
            this.yc = host.size();
            this.dd = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.b6.zn != this.ma || this.p6) {
                throw new IllegalStateException(nn);
            }
            this.zn = -1;
            this.t8 = null;
            this.sj = null;
        }

        @Override
        public boolean hasNext() {
            if (this.b6.zn != this.ma || this.p6) {
                throw new InvalidOperationException(nn);
            }
            Slot[] slotArray = this.b6.t8;
            if (++this.zn < this.yc) {
                Slot slot = slotArray[this.zn].Clone();
                this.t8 = slot.b6;
                this.sj = slot.t8;
                return true;
            }
            this.t8 = null;
            this.sj = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            return new DictionaryEntry(this.t8, this.sj);
        }

        @Override
        public Object getKey() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            return this.t8;
        }

        @Override
        public Object getValue() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            return this.sj;
        }

        @Override
        public Object next() {
            if (this.p6 || this.zn >= this.yc || this.zn == -1) {
                throw new IllegalStateException(nn);
            }
            switch (this.dd) {
                case 0: {
                    return this.t8;
                }
                case 1: {
                    return this.sj;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(k8.b6(new String[]{ht.getName(EnumeratorMode.class, this.dd), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.b6, this.dd);
            enumerator.ma = this.ma;
            enumerator.zn = this.zn;
            enumerator.yc = this.yc;
            enumerator.t8 = this.t8;
            enumerator.sj = this.sj;
            enumerator.p6 = this.p6;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends ht {
        private EnumeratorMode() {
        }

        static {
            ht.register(new ht.zn(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @a9
    public static class Slot
    extends dd<Slot> {
        Object b6;
        Object t8;

        @Override
        public void CloneTo(Slot that) {
            that.b6 = this.b6;
            that.t8 = this.t8;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean b6(Slot slot) {
            return h7.b6(slot.b6, this.b6) && h7.b6(slot.t8, this.t8);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (h7.t8(null, obj)) {
                return false;
            }
            if (h7.t8(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.b6((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.b6 != null ? this.b6.hashCode() : 0;
            n = 31 * n + (this.t8 != null ? this.t8.hashCode() : 0);
            return n;
        }
    }
}

