/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.d1.dd;
import com.aspose.slides.internal.d1.sj;
import com.aspose.slides.internal.fy.w0;
import com.aspose.slides.ms.System.l2;
import com.aspose.slides.ms.System.ve;

public class BitVector32
extends dd<BitVector32> {
    private int b6;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.b6 = value.b6;
    }

    public BitVector32(int data) {
        this.b6 = data;
    }

    public int getData() {
        return this.b6;
    }

    public int get_Item(Section section) {
        return this.b6 >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.b6 &= ~(section.getMask() << section.getOffset());
        this.b6 |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.b6 & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.b6 = value ? (this.b6 |= bit) : (this.b6 &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.b6(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.b6(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(sj.t8((Object)n10, 9), sj.t8((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return sj.t8(o, BitVector32.class) && this.b6 == sj.ma((Object)o, BitVector32.class).b6;
    }

    public int hashCode() {
        return ve.b6(this.b6);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        w0 w02 = new w0();
        w02.b6("BitVector32{");
        for (long i = sj.yc((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            w02.b6(((long)value.b6 & i) == 0L ? (char)'0' : '1');
        }
        w02.b6('}');
        return w02.toString();
    }

    private static int b6(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.b6 = this.b6;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends dd<Section> {
        private short b6;
        private short t8;

        public Section() {
        }

        Section(short mask, short offset) {
            this.b6 = mask;
            this.t8 = offset;
        }

        public short getMask() {
            return this.b6;
        }

        public short getOffset() {
            return this.t8;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.b6 == b.b6 && a.t8 == b.t8;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.b6 != b.b6 || a.t8 != b.t8;
        }

        public boolean equals(Section obj) {
            return this.b6 == obj.b6 && this.t8 == obj.t8;
        }

        public boolean equals(Object o) {
            if (!sj.t8(o, Section.class)) {
                return false;
            }
            Section section = sj.ma(o, Section.class).Clone();
            return this.b6 == section.b6 && this.t8 == section.t8;
        }

        public int hashCode() {
            return this.b6 << this.t8;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            w0 w02 = new w0();
            w02.b6("Section{0x");
            w02.b6(l2.b6(value.getMask(), 16));
            w02.b6(", 0x");
            w02.b6(l2.b6(value.getOffset(), 16));
            w02.b6("}");
            return w02.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.b6 = this.b6;
            that.t8 = this.t8;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

