/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.m9;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.m9.dd;
import com.aspose.slides.internal.m9.ku;
import com.aspose.slides.internal.m9.ol;
import com.aspose.slides.internal.oi.ma;
import com.aspose.slides.ms.System.hr;
import com.aspose.slides.ms.System.ht;
import com.aspose.slides.ms.System.k8;
import java.io.File;

public class nm
extends ku {
    private boolean b6 = false;
    private boolean t8;
    private boolean sj;
    private boolean ma;
    private ma zn;
    private final String yc;

    public nm(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private nm(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.yc = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (k8.t8(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.sj = false;
            this.t8 = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.sj = true;
            this.t8 = false;
            string2 = "rw";
        } else {
            this.sj = true;
            this.t8 = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(k8.b6("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{ht.getName(ol.class, n10), ht.getName(dd.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(k8.b6("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{ht.getName(ol.class, n10), ht.getName(dd.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.zn = bl2 ? new ma(file, string2, n) : new ma(file, string2);
            if (n10 == 6) {
                this.zn.b6(this.zn.ma());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.zn = new ma(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.zn = new ma(file, string2);
                this.zn.b6(true);
            } else {
                this.zn = new ma(file, string2);
            }
        }
        this.ma = true;
    }

    public nm(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public nm(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public nm(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.t8;
    }

    @Override
    public boolean canSeek() {
        return this.ma;
    }

    @Override
    public boolean canWrite() {
        return this.sj;
    }

    @Override
    public long getLength() {
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.zn.ma();
    }

    @Override
    public long getPosition() {
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.zn.sj();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.zn.b6(position);
    }

    @Override
    public void flush() {
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.zn.zn();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.zn.b6(offset);
                break;
            }
            case 1: {
                this.zn.b6(this.zn.sj() + offset);
                break;
            }
            case 2: {
                this.zn.b6(this.zn.ma() + offset);
            }
        }
        return this.zn.sj();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.zn != null && !this.zn.t8()) {
                this.zn.b6();
            }
        }
        finally {
            this.t8 = false;
            this.sj = false;
            this.ma = false;
            super.dispose(disposing);
            this.b6 = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.sj) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.zn.sj(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.t8) {
            int n = this.zn.t8(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.t8) {
            return this.zn.yc();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.sj) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.zn.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.sj) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.zn.write(value);
    }

    public String b6() {
        return this.yc;
    }

    @Override
    public hr beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.dd callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(hr asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public hr beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.dd userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.b6) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(hr asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

