/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.i7;
import com.aspose.slides.ms.System.qr;
import com.aspose.slides.ms.System.yc;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@hn
public class ArrayList
implements IList,
List {
    private Object[] bo;
    private int gt;
    private int lk;
    private static Object[] ax = new Object[0];

    protected int getVersion() {
        return this.lk;
    }

    public ArrayList() {
        this.bo = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.bo = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.bo("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.bo = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.bo = null;
    }

    private ArrayList(ax array, int index, int count) {
        this.bo = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.ax.bo(array, index, com.aspose.slides.ms.System.ax.bo(this.bo), 0, count);
        this.gt = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.gt) {
            ArrayList.bo("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.bo[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.gt) {
            ArrayList.bo("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.bo[index] = value;
        ++this.lk;
    }

    @Override
    public int size() {
        return this.gt;
    }

    public int getCapacity() {
        return this.bo.length;
    }

    public void setCapacity(int value) {
        if (value < this.gt) {
            ArrayList.bo("Capacity", (Object)value, "Must be more than count.");
        }
        this.bo = value > 0 ? Arrays.copyOf(this.bo, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void bo(int n) {
        int n10;
        if (n <= this.bo.length) {
            return;
        }
        int n11 = n10 = this.bo.length == 0 ? 4 : this.bo.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void bo(int n, int n10) {
        if (n10 > 0) {
            if (this.gt + n10 > this.bo.length) {
                int n11;
                int n12 = n11 = this.bo.length > 0 ? this.bo.length << 1 : 1;
                while (n11 < this.gt + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.ax.bo(this.bo, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.ax.bo(this.bo, n, objectArray, n + n10, this.gt - n);
                this.bo = objectArray;
            } else {
                com.aspose.slides.ms.System.ax.bo(this.bo, n, this.bo, n + n10, this.gt - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.ax.bo(this.bo, n13, this.bo, n, this.gt - n13);
            com.aspose.slides.ms.System.ax.bo(this.bo, this.gt + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.bo.length <= this.gt) {
            this.bo(this.gt + 1);
        }
        this.bo[this.gt] = value;
        ++this.lk;
        return this.gt++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, this.gt);
        this.gt = 0;
        ++this.lk;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.gt) > -1;
    }

    boolean bo(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.gt - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.gt) {
            ArrayList.bo("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.bo("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.gt - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.ax.bo(this.bo, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.gt - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return i7.bo(this.bo, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.gt) {
            ArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.bo(index, 1);
        this.bo[index] = value;
        ++this.gt;
        ++this.lk;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.gt) {
            ArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.bo.length < this.gt + n) {
                this.bo(this.gt + n);
            }
            if (index < this.gt) {
                com.aspose.slides.ms.System.ax.bo(this.bo, index, this.bo, index + n, this.gt - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.ax.bo(this.bo, 0, this.bo, index, index);
                com.aspose.slides.ms.System.ax.bo(this.bo, index + n, this.bo, index << 1, this.gt - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.ax.bo(this.bo), index);
            }
            this.gt += c.size();
            ++this.lk;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.gt) {
            ArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.bo.length < this.gt + n) {
                this.bo(this.gt + n);
            }
            if (index < this.gt) {
                com.aspose.slides.ms.System.ax.bo(this.bo, index, this.bo, index + n, this.gt - index);
            }
            com.aspose.slides.ms.System.ax.bo(c).copyTo(com.aspose.slides.ms.System.ax.bo(this.bo), index);
            this.gt += c.length;
            ++this.lk;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.lk;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.gt) {
            ArrayList.bo("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.bo(index, -1);
        --this.gt;
        ++this.lk;
    }

    public void removeRange(int index, int count) {
        ArrayList.bo(index, count, this.gt);
        this.bo(index, -count);
        this.gt -= count;
        ++this.lk;
    }

    public void reverse() {
        i7.bo(this.bo, 0, this.gt);
        ++this.lk;
    }

    public void reverse(int index, int count) {
        ArrayList.bo(index, count, this.gt);
        i7.bo(this.bo, index, count);
        ++this.lk;
    }

    public void copyTo(ax array) {
        com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), 0, array, 0, this.gt);
    }

    @Override
    public void copyTo(ax array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.gt);
    }

    public void copyTo(int index, ax array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ax() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.bo(index, count, this.gt);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.gt, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.gt, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return i7.bo(this.bo, 0, this.gt, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return i7.bo(this.bo, 0, this.gt, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return i7.bo(this.bo, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.bo(index, count, this.gt);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.gt) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.ax.bo(this.bo), index);
        ++this.lk;
    }

    public void trimToSize() {
        this.setCapacity(this.gt);
    }

    public void sort() {
        Arrays.sort(this.bo, 0, this.gt, Comparer.Default);
        ++this.lk;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.bo, 0, this.gt, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.bo(index, count, this.gt);
        Arrays.sort(this.bo, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.gt];
        this.copyTo(com.aspose.slides.ms.System.ax.bo(objectArray));
        return objectArray;
    }

    public ax toArray(qr type) {
        ax ax3 = com.aspose.slides.ms.System.ax.bo(type, this.gt);
        this.copyTo(ax3);
        return ax3;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.ax.bo(this.bo), 0, this.gt);
    }

    static void bo(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.bo("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.bo("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void bo(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.ax.bo(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.gt, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List bo;
        private int gt;

        @Override
        protected int getVersion() {
            return this.bo instanceof ArrayList ? ((ArrayList)this.bo).getVersion() : this.gt;
        }

        public ArrayListInternalized(List internal) {
            this.bo = internal;
            if (internal instanceof ArrayList) {
                this.gt = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.bo.set(index, value);
            ++this.gt;
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.bo.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.bo.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.bo.size(); ++i) {
                this.bo.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.bo.size();
            this.bo.add(value);
            ++this.gt;
            return n;
        }

        @Override
        public void clear() {
            this.bo.clear();
            ++this.gt;
        }

        @Override
        public boolean contains(Object item) {
            return this.bo.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.bo.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.bo.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.bo.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.bo.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.bo.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return i7.bo(this.bo.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.bo.add(index, value);
            ++this.gt;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.bo.add(index++, e);
            }
            ++this.gt;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.bo.add(index++, object);
            }
            ++this.gt;
        }

        @Override
        public void removeItem(Object obj) {
            this.bo.remove(obj);
            ++this.gt;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.bo.remove(index);
            ++this.gt;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.bo.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.bo.remove(index);
            }
            ++this.gt;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.bo.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.bo.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.bo.size() - 1; n < i; ++n, --i) {
                Object e = this.bo.get(n);
                this.bo.set(n, this.bo.get(i));
                this.bo.set(i, e);
            }
            ++this.gt;
        }

        @Override
        public void copyTo(ax array) {
            com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo.toArray()), 0, array, 0, this.bo.size());
        }

        @Override
        public void copyTo(ax array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.bo.size());
        }

        @Override
        public void copyTo(int index, ax array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ax() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.bo(index, count, this.bo.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.bo.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return i7.bo(this.bo.toArray(), 0, this.bo.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return i7.bo(this.bo.toArray(), 0, this.bo.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return i7.bo(this.bo.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.bo(index, count, this.bo.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.bo.set(index++, e);
            }
            ++this.gt;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.bo, null);
            ++this.gt;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.bo, comparer);
            ++this.gt;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.bo.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.bo.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.bo.set(i, list.get(i - index));
            }
            ++this.gt;
        }

        @Override
        public Object[] toArray() {
            return this.bo.toArray();
        }

        @Override
        public ax toArray(qr type) {
            ax ax3 = com.aspose.slides.ms.System.ax.bo(type, this.bo.size());
            this.copyTo(ax3);
            return ax3;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.bo.size()];
            com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), 0, objectArray, 0, this.bo.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e : arrayList) {
                arrayList.add(e);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.bo.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.bo.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.gt;
            return this.bo.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.gt;
            return this.bo.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.bo.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.gt;
            return this.bo.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.gt;
            return this.bo.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.gt;
            return this.bo.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.gt;
            return this.bo.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.bo.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.gt;
            return this.bo.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.bo.add(index, element);
            ++this.gt;
        }

        @Override
        public Object remove(int index) {
            ++this.gt;
            return this.bo.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.bo.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.bo.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.bo.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.bo = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.bo != 0;
        }

        @Override
        public int nextIndex() {
            return this.bo;
        }

        @Override
        public int previousIndex() {
            return this.bo - 1;
        }

        public Object previous() {
            int n = this.bo - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.bo;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.bo = n;
            this.gt = n;
            return objectArray[this.gt];
        }

        public void set(Object e) {
            if (this.gt < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).bo[this.gt] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.bo;
                ArrayList.this.add(n, e);
                this.bo = n + 1;
                this.gt = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int bo;
        int gt = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.bo != ArrayList.this.size();
        }

        public Object next() {
            int n = this.bo;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.bo;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.bo = n + 1;
            this.gt = n;
            return objectArray[this.gt];
        }

        @Override
        public void remove() {
            if (this.gt < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.gt);
                this.bo = this.gt;
                this.gt = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @hn
    private static class ListWrapper
    implements IList {
        protected IList bo;

        public ListWrapper(IList innerList) {
            this.bo = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.bo.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.bo.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.bo.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.bo.addItem(value);
        }

        @Override
        public void clear() {
            this.bo.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.bo.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.bo.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.bo.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.bo.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.bo.removeAt(index);
        }

        @Override
        public void copyTo(ax array, int index) {
            this.bo.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.bo.iterator();
        }
    }

    @hn
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String bo() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.bo());
        }
    }

    @hn
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String bo() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.bo());
        }
    }

    @hn
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object gt;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.gt = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.gt;
            synchronized (object) {
                this.bo.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array, int index) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.iterator();
            }
        }
    }

    @hn
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int gt;
        private int lk;
        private int ax;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.gt = index;
            this.lk = count;
            this.ax = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.lk) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.bo.get_Item(this.gt + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.lk) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.bo.set_Item(this.gt + index, value);
        }

        @Override
        public int size() {
            this.bo();
            return this.lk;
        }

        @Override
        public int getCapacity() {
            return this.bo.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.lk) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void bo() {
            if (this.ax != this.bo.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.bo();
            this.bo.insertItem(this.gt + this.lk, value);
            this.ax = this.bo.getVersion();
            return ++this.lk;
        }

        @Override
        public void clear() {
            this.bo();
            this.bo.removeRange(this.gt, this.lk);
            this.lk = 0;
            this.ax = this.bo.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.bo.bo(value, this.gt, this.lk);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.lk - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.lk) {
                RangedArrayList.bo("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.bo("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.lk - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.bo.indexOf(value, this.gt + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.gt;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.lk - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.bo("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.bo("count", (Object)count, "count is negative.");
            }
            if ((n = this.bo.lastIndexOf(value, this.gt + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.gt;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.bo();
            if (index < 0 || index > this.lk) {
                RangedArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.bo.insertItem(this.gt + index, value);
            ++this.lk;
            this.ax = this.bo.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.bo();
            if (index < 0 || index > this.lk) {
                RangedArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.bo.insertRange(this.gt + index, c);
            this.lk += c.size();
            this.ax = this.bo.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.bo();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.ax = this.bo.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.bo();
            if (index < 0 || index > this.lk) {
                RangedArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.bo.removeAt(this.gt + index);
            --this.lk;
            this.ax = this.bo.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.bo();
            RangedArrayList.bo(index, count, this.lk);
            this.bo.removeRange(this.gt + index, count);
            this.lk -= count;
            this.ax = this.bo.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.lk);
        }

        @Override
        public void reverse(int index, int count) {
            this.bo();
            RangedArrayList.bo(index, count, this.lk);
            this.bo.reverse(this.gt + index, count);
            this.ax = this.bo.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.bo();
            if (index < 0 || index > this.lk) {
                RangedArrayList.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.bo.setRange(this.gt + index, c);
            this.ax = this.bo.getVersion();
        }

        @Override
        public void copyTo(ax array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(ax array, int index) {
            this.copyTo(0, array, index, this.lk);
        }

        @Override
        public void copyTo(int index, ax array, int arrayIndex, int count) {
            RangedArrayList.bo(index, count, this.lk);
            this.bo.copyTo(this.gt + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.lk);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.bo(index, count, this.lk);
            return this.bo.iterator(this.gt + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.bo();
            this.bo.insertRange(this.lk, c);
            this.lk += c.size();
            this.ax = this.bo.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.lk, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.lk, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.bo(index, count, this.lk);
            return this.bo.binarySearch(this.gt + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.bo.deepClone(), this.gt, this.lk);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.bo(index, count, this.lk);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.lk, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.bo();
            RangedArrayList.bo(index, count, this.lk);
            this.bo.sort(this.gt + index, count, comparer);
            this.ax = this.bo.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.lk];
            this.bo.copyTo(this.gt, com.aspose.slides.ms.System.ax.bo(objectArray), 0, this.lk);
            return objectArray;
        }

        @Override
        public ax toArray(qr elementType) {
            ax ax3 = com.aspose.slides.ms.System.ax.bo(elementType, this.lk);
            this.bo.copyTo(this.gt, ax3, 0, this.lk);
            return ax3;
        }
    }

    @hn
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String bo() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.bo());
        }
    }

    @hn
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String bo() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.bo());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.bo());
        }
    }

    @hn
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object gt;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.gt = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.gt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.gt;
            synchronized (object) {
                this.bo.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.gt;
            synchronized (object) {
                this.bo.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array, int index) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, ax array, int arrayIndex, int count) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.gt;
            synchronized (object) {
                this.bo.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.gt;
            synchronized (object) {
                this.bo.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.gt;
            synchronized (object) {
                this.bo.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ax toArray(qr elementType) {
            Object object = this.gt;
            synchronized (object) {
                return this.bo.toArray(elementType);
            }
        }
    }

    @hn
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList bo;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.bo = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.bo.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public int getCapacity() {
            return this.bo.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.bo.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.bo.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.bo.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.bo.addItem(value);
        }

        @Override
        public void clear() {
            this.bo.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.bo.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.bo.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.bo.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.bo.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.bo.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.bo.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.bo.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.bo.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.bo.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.bo.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.bo.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.bo.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.bo.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.bo.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.bo.setRange(index, c);
        }

        @Override
        public void copyTo(ax array) {
            this.bo.copyTo(array);
        }

        @Override
        public void copyTo(ax array, int index) {
            this.bo.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ax array, int arrayIndex, int count) {
            this.bo.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.bo.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.bo.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.bo.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.bo.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.bo.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.bo.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.bo.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.bo.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.bo.trimToSize();
        }

        @Override
        public void sort() {
            this.bo.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.bo.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.bo.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.bo.toArray();
        }

        @Override
        public ax toArray(qr elementType) {
            return this.bo.toArray(elementType);
        }
    }

    @hn
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList bo;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.bo = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.bo.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public int getCapacity() {
            return this.bo.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.bo.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.bo.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.bo.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.bo.addItem(value);
        }

        @Override
        public void clear() {
            this.bo.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.bo.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.bo.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.bo.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.bo.size()) {
                ArrayListAdapter.bo("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.bo("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.bo.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.bo.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.bo.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.bo.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.bo("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.bo("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.bo("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.bo.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.bo.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.bo.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.bo.size()) {
                ArrayListAdapter.bo("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.bo.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.bo.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.bo.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.bo(index, count, this.bo.size());
            for (int i = 0; i < count; ++i) {
                this.bo.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.bo.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.bo(index, count, this.bo.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.bo.get_Item(i + index);
                this.bo.set_Item(i + index, this.bo.get_Item(index + count - i + index - 1));
                this.bo.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.bo.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.bo.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(ax array) {
            this.bo.copyTo(array, 0);
        }

        @Override
        public void copyTo(ax array, int index) {
            this.bo.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, ax array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.bo("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.bo("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.bo("index", (Object)index, "Can't be less than zero.");
            }
            if (array.ax() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.oz() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.bo.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.lk(this.bo.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.bo.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.bo(index, count, this.bo.size());
            return new EnumeratorWithRange(this.bo.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.bo.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.bo.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.bo(index, count, this.bo.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.bo.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.bo);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.bo(index, count, this.bo.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.bo.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.bo(index, count, this.bo.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.bo(this.bo, index, index + count - 1, comparer);
        }

        private static void bo(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void bo(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.bo(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.bo(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.bo(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.bo(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.bo(iList, n12, n13);
            }
            ArrayListAdapter.bo(iList, n10 - 1, n12);
            ArrayListAdapter.bo(iList, n, n12 - 1, comparator);
            ArrayListAdapter.bo(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.bo.size()];
            this.bo.copyTo(com.aspose.slides.ms.System.ax.bo(objectArray), 0);
            return objectArray;
        }

        @Override
        public ax toArray(qr elementType) {
            ax ax3 = com.aspose.slides.ms.System.ax.bo(elementType, this.bo.size());
            this.bo.copyTo(ax3, 0);
            return ax3;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        yc,
        Cloneable {
            private int bo;
            private int gt;
            private int lk;
            private IEnumerator ax;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.gt = 0;
                this.bo = index;
                this.lk = count;
                this.ax = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.bo();
            }

            @Override
            public Object next() {
                return this.ax.next();
            }

            @Override
            public boolean hasNext() {
                if (this.gt >= this.lk) {
                    return false;
                }
                ++this.gt;
                return this.ax.hasNext();
            }

            @Override
            public void reset() {
                this.gt = 0;
                this.ax.reset();
                for (int i = 0; i < this.bo; ++i) {
                    this.ax.hasNext();
                }
            }

            protected Object bo() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.bo = this.bo;
                enumeratorWithRange.gt = this.gt;
                enumeratorWithRange.lk = this.lk;
                enumeratorWithRange.ax = this.ax;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    yc,
    Cloneable {
        private ArrayList gt;
        private Object lk;
        private int ax;
        private int oz;
        static Object bo = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.gt = list;
            this.ax = -1;
            this.oz = list.getVersion();
            this.lk = bo;
        }

        @Override
        public Object deepClone() {
            return this.bo();
        }

        @Override
        public boolean hasNext() {
            if (this.oz != this.gt.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.ax < this.gt.size()) {
                this.lk = this.gt.get_Item(this.ax);
                return true;
            }
            this.lk = bo;
            return false;
        }

        @Override
        public Object next() {
            if (this.lk == bo) {
                if (this.ax == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.lk;
        }

        @Override
        public void reset() {
            if (this.oz != this.gt.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.lk = bo;
            this.ax = -1;
        }

        protected Object bo() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.gt = this.gt;
            simpleEnumerator.lk = this.lk;
            simpleEnumerator.ax = this.ax;
            simpleEnumerator.oz = this.oz;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    yc,
    Cloneable {
        private Object bo;
        private ArrayList gt;
        private int lk;
        private int ax;
        private int oz;
        private int gl;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.bo();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.gt = list;
            this.ax = index;
            this.oz = count;
            this.lk = this.ax - 1;
            this.bo = null;
            this.gl = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.lk == this.ax - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.bo;
        }

        @Override
        public boolean hasNext() {
            if (this.gt.getVersion() != this.gl) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.lk;
            if (this.lk - this.ax < this.oz) {
                this.bo = this.gt.get_Item(this.lk);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.bo = null;
            this.lk = this.ax - 1;
        }

        protected Object bo() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.bo = this.bo;
            arrayListEnumerator.gt = this.gt;
            arrayListEnumerator.lk = this.lk;
            arrayListEnumerator.ax = this.ax;
            arrayListEnumerator.oz = this.oz;
            arrayListEnumerator.gl = this.gl;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

