/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.yc;

@hn
public final class BitArray
implements ICollection,
yc {
    private int[] bo;
    private int gt;
    private int lk = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.gt = bits.gt;
        this.bo = new int[(this.gt + 31) / 32];
        if (this.bo.length == 1) {
            this.bo[0] = bits.bo[0];
        } else {
            ax.bo(bits.bo, 0, this.bo, 0, this.bo.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.gt = values.length;
        this.bo = new int[(this.gt + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.gt = bytes.length * 8;
        this.bo = new int[(this.gt + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.bo(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.gt = n * 32;
        this.bo = new int[n];
        ax.bo(values, 0, this.bo, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.gt = length;
        this.bo = new int[(this.gt + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.bo.length; ++i) {
                this.bo[i] = -1;
            }
        }
    }

    private byte bo(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.bo[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void bo(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.bo[n12] = this.bo[n12] & ~(255 << n11);
        int n13 = n10;
        this.bo[n13] = this.bo[n13] | (by2 & 0xFF) << n11;
        ++this.lk;
    }

    private void gt(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.gt != this.gt) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.gt;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.gt;
    }

    public void setLength(int value) {
        if (this.gt == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.gt) {
            int n = (value + 31) / 32;
            int n10 = (this.gt + 31) / 32;
            if (n > this.bo.length) {
                int[] nArray = new int[n];
                ax.bo(this.bo, 0, nArray, 0, this.bo.length);
                this.bo = nArray;
            } else {
                ax.bo(ax.bo((Object)this.bo), n10, n - n10);
            }
            int n11 = this.gt % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.bo[n12] = this.bo[n12] & (1 << n11) - 1;
            }
        }
        this.gt = value;
        ++this.lk;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(ax array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ax() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.oz() && this.gt > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = ax.bo(array);
        if (object instanceof Boolean[]) {
            if (array.oz() - index < this.gt) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.gt; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.oz() - index < this.gt) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.gt; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.gt + 7) / 8;
            if (array.oz() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.bo(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.gt + 7) / 8;
            if (array.oz() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.bo(i);
            }
        } else if (object instanceof Integer[]) {
            ax.bo(ax.bo((Object)this.bo), 0, array, index, (this.gt + 31) / 32);
        } else if (object instanceof int[]) {
            ax.bo(ax.bo((Object)this.bo), 0, array, index, (this.gt + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.gt + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.bo[i] = ~this.bo[i];
        }
        ++this.lk;
        return this;
    }

    public BitArray and(BitArray value) {
        this.gt(value);
        int n = (this.gt + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.bo[n10] = this.bo[n10] & value.bo[i];
        }
        ++this.lk;
        return this;
    }

    public BitArray or(BitArray value) {
        this.gt(value);
        int n = (this.gt + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.bo[n10] = this.bo[n10] | value.bo[i];
        }
        ++this.lk;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.gt(value);
        int n = (this.gt + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.bo[n10] = this.bo[n10] ^ value.bo[i];
        }
        ++this.lk;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.gt) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.bo[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.gt) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.bo[n] = this.bo[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.bo[n] = this.bo[n] & ~(1 << (index & 0x1F));
        }
        ++this.lk;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.bo.length; ++i) {
                this.bo[i] = -1;
            }
        } else {
            ax.bo(ax.bo((Object)this.bo), 0, this.bo.length);
        }
        ++this.lk;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @hn
    private static class BitArrayEnumerator
    implements IEnumerator,
    yc,
    Cloneable {
        private BitArray bo;
        private boolean gt;
        private int lk;
        private int ax;

        @Override
        public Object deepClone() {
            return this.bo();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.lk = -1;
            this.bo = ba2;
            this.ax = ba2.lk;
        }

        @Override
        public Object next() {
            if (this.lk == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.lk >= this.bo.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.gt;
        }

        @Override
        public boolean hasNext() {
            this.gt();
            if (this.lk < this.bo.size() - 1) {
                this.gt = this.bo.get_Item(++this.lk);
                return true;
            }
            this.lk = this.bo.size();
            return false;
        }

        @Override
        public void reset() {
            this.gt();
            this.lk = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void gt() {
            if (this.ax != this.bo.lk) {
                throw new InvalidOperationException();
            }
        }

        protected Object bo() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.bo = this.bo;
            bitArrayEnumerator.gt = this.gt;
            bitArrayEnumerator.lk = this.lk;
            bitArrayEnumerator.ax = this.ax;
            return bitArrayEnumerator;
        }
    }
}

