/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.xd.vh;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.aw;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.bo;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.i7;
import com.aspose.slides.ms.System.pf;
import com.aspose.slides.ms.System.u3;
import com.aspose.slides.ms.System.xo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@hn
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] bo;
    private int gt;
    private int lk;
    private final Object ax = new Object();
    static Object[] gl = new Object[0];

    public List() {
        this.bo = gl;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.bo = gl;
        this.bo(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.bo = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.bo = data;
        this.gt = size;
    }

    protected int getVersion() {
        return this.lk;
    }

    @Override
    public void addItem(T item) {
        if (this.gt == this.bo.length) {
            this.bo(1);
        }
        this.bo[this.gt++] = item;
        ++this.lk;
    }

    private void bo(int n) {
        int n10 = this.gt + n;
        if (n10 > this.bo.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void bo(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.gt & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void bo(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.bo(new List<T>(collection));
        ++this.lk;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.lk;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return i7.bo(this.bo, 0, this.gt, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return i7.bo(this.bo, 0, this.gt, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.bo(index, count);
        return i7.bo(this.bo, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, this.bo.length);
        this.gt = 0;
        ++this.lk;
    }

    public <TOutput> List<TOutput> convertAll(aw<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.gt);
        for (int i = 0; i < this.gt; ++i) {
            list.bo[i] = converter.bo(this.bo[i]);
        }
        list.gt = this.gt;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, array, 0, this.gt);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, array, arrayIndex, this.gt);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.bo(index, count);
        com.aspose.slides.ms.System.ax.bo(this.bo, index, array, arrayIndex, count);
    }

    public boolean exists(u3<T> match) {
        List.bo(match);
        return this.bo(0, this.gt, match) != -1;
    }

    public T find(u3<T> match) {
        List.bo(match);
        int n = this.bo(0, this.gt, match);
        return (T)(n != -1 ? this.bo[n] : null);
    }

    static <T> void bo(u3<T> u32) {
        if (u32 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(u3<T> match) {
        List.bo(match);
        return this.gt(match);
    }

    private List<T> gt(u3<T> u32) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.gt; ++i) {
            if (!u32.invoke(this.bo[i])) continue;
            list.addItem(this.bo[i]);
        }
        return list;
    }

    public int findIndex(u3<T> match) {
        List.bo(match);
        return this.bo(0, this.gt, match);
    }

    public int findIndex(int startIndex, u3<T> match) {
        List.bo(match);
        this.gt(startIndex);
        return this.bo(startIndex, this.gt - startIndex, match);
    }

    public int findIndex(int startIndex, int count, u3<T> match) {
        List.bo(match);
        this.bo(startIndex, count);
        return this.bo(startIndex, count, match);
    }

    private int bo(int n, int n10, u3<T> u32) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!u32.invoke(this.bo[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(u3<T> match) {
        List.bo(match);
        int n = this.gt(0, this.gt, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(u3<T> match) {
        List.bo(match);
        return this.gt(0, this.gt, match);
    }

    public int findLastIndex(int startIndex, u3<T> match) {
        List.bo(match);
        this.gt(startIndex);
        return this.gt(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, u3<T> match) {
        List.bo(match);
        int n = startIndex - count + 1;
        this.bo(n, count);
        return this.gt(n, count, match);
    }

    private int gt(int n, int n10, u3<T> u32) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!u32.invoke(this.bo[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(bo<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.gt; ++i) {
            action.invoke(this.bo[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.bo(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.ax.bo(this.bo, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.ax.bo(this.bo, item, 0, this.gt);
    }

    public int indexOf(T item, int index) {
        this.gt(index);
        return com.aspose.slides.ms.System.ax.bo(this.bo, item, index, this.gt - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.gt & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.ax.bo(this.bo, item, index, count);
    }

    private void gt(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.gt) {
            com.aspose.slides.ms.System.ax.bo(this.bo, n, this.bo, n + n10, this.gt - n);
        }
        this.gt += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.ax.bo(this.bo, this.gt, -n10);
        }
    }

    private void gt(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.gt & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.gt(index);
        if (this.gt == this.bo.length) {
            this.bo(1);
        }
        this.gt(index, 1);
        this.bo[index] = item;
        ++this.lk;
    }

    void lk(int n) {
        Object[] objectArray = new Object[this.gt];
        this.copyToTArray(objectArray, 0);
        this.bo(this.gt);
        this.gt(n, objectArray.length);
        com.aspose.slides.ms.System.ax.bo(objectArray, 0, this.bo, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.gt(index);
        if (collection == this) {
            this.lk(index);
        } else {
            this.bo(index, collection);
        }
        ++this.lk;
    }

    private void bo(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.gt == 0) {
            return -1;
        }
        return i7.bo(this.bo, item, this.gt - 1, this.gt);
    }

    public int lastIndexOf(T item, int index) {
        this.gt(index);
        return i7.bo(this.bo, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return i7.bo(this.bo, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(u3<T> match) {
        List.bo(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.gt && !match.invoke(this.bo[n]); ++n) {
        }
        if (n == this.gt) {
            return 0;
        }
        ++this.lk;
        for (n10 = n + 1; n10 < this.gt; ++n10) {
            if (match.invoke(this.bo[n10])) continue;
            this.bo[n++] = this.bo[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.ax.bo(this.bo, n, n10 - n);
        }
        this.gt = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.gt & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.gt(index, -1);
        com.aspose.slides.ms.System.ax.bo(this.bo, this.gt, 1);
        ++this.lk;
    }

    public void removeRange(int index, int count) {
        this.bo(index, count);
        if (count > 0) {
            this.gt(index, -count);
            com.aspose.slides.ms.System.ax.bo(this.bo, this.gt, count);
            ++this.lk;
        }
    }

    public void reverse() {
        i7.bo(this.bo, 0, this.gt);
        ++this.lk;
    }

    public void reverse(int index, int count) {
        this.bo(index, count);
        i7.bo(this.bo, index, count);
        ++this.lk;
    }

    public void sort() {
        Arrays.sort(this.bo, 0, this.gt);
        ++this.lk;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.bo, 0, this.gt, comparer);
        ++this.lk;
    }

    @Override
    public void sort(pf<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.bo, 0, this.gt, new i7.bo<T>(comparison));
        ++this.lk;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.bo(index, count);
        Arrays.sort(this.bo, index, index + count, comparer);
        ++this.lk;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.gt) {
            return Arrays.copyOf(this.bo, this.gt, a.getClass());
        }
        System.arraycopy(this.bo, 0, a, 0, this.gt);
        if (a.length > this.gt) {
            a[this.gt] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.gt);
    }

    public boolean trueForAll(u3<T> match) {
        List.bo(match);
        for (int i = 0; i < this.gt; ++i) {
            if (match.invoke(this.bo[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.bo.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.gt & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.bo = Arrays.copyOf(this.bo, value);
    }

    @Override
    public int size() {
        return this.gt;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.gt & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.bo[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.gt(index);
        if ((long)index == (long)this.gt) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.bo[index] = value;
        ++this.lk;
    }

    public void copyTo(ax array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.ax() > 1 || array.gt(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), 0, array, arrayIndex, this.gt);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.ax;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.gt == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.gt; ++i) {
                if (this.bo[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.gt; ++i) {
            if (!this.bo[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.gt; ++i) {
                if (this.bo[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.gt; ++i) {
            if (!this.bo[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.gt];
        System.arraycopy(this.bo, 0, objectArray, 0, this.gt);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.gt;
        this.addItem(t);
        return n != this.gt;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.gt;
        this.removeItem(o);
        return n != this.gt;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.gt; ++i) {
                if (this.bo[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.gt; ++i) {
            if (!o.equals(this.bo[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> bo;
        private int gt;

        public ListInternalized() {
            this.bo = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.bo = list;
        }

        @Override
        protected int getVersion() {
            return this.gt;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.bo(collection);
            ++this.gt;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.gt;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return i7.bo(this.bo.toArray(), 0, this.bo.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return i7.bo(this.bo.toArray(), 0, this.bo.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.bo(index, count);
            return i7.bo(this.bo.toArray(), index, count, item, comparer);
        }

        @Override
        private void bo(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.bo.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(aw<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.bo.size());
            for (int i = 0; i < this.bo.size(); ++i) {
                list.bo[i] = converter.bo(this.get_Item(i));
            }
            list.gt = this.bo.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), 0, array, 0, this.bo.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), 0, array, arrayIndex, this.bo.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.bo(index, count);
            com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(u3<T> match) {
            ListInternalized.gt(match);
            return this.bo(0, this.bo.size(), match) != -1;
        }

        @Override
        private int bo(int n, int n10, u3<T> u32) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!u32.invoke(this.bo.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void gt(u3<T> u32) {
            if (u32 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(u3<T> match) {
            ListInternalized.gt(match);
            int n = this.bo(0, this.bo.size(), match);
            return n != -1 ? (T)this.bo.get(n) : null;
        }

        @Override
        public List<T> findAll(u3<T> match) {
            ListInternalized.gt(match);
            return this.lk(match);
        }

        private List<T> lk(u3<T> u32) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!u32.invoke(this.bo.get(i))) continue;
                list.addItem(this.bo.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(u3<T> match) {
            ListInternalized.gt(match);
            return this.bo(0, this.bo.size(), match);
        }

        @Override
        public int findIndex(int startIndex, u3<T> match) {
            ListInternalized.gt(match);
            this.bo(startIndex);
            return this.bo(startIndex, this.bo.size() - startIndex, match);
        }

        @Override
        private void bo(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.bo.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, u3<T> match) {
            ListInternalized.gt(match);
            this.bo(startIndex, count);
            return this.bo(startIndex, count, match);
        }

        @Override
        public T findLast(u3<T> match) {
            ListInternalized.gt(match);
            int n = this.gt(0, this.bo.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int gt(int n, int n10, u3<T> u32) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!u32.invoke(this.bo.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(u3<T> match) {
            ListInternalized.gt(match);
            return this.gt(0, this.bo.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, u3<T> match) {
            ListInternalized.gt(match);
            this.bo(startIndex);
            return this.gt(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, u3<T> match) {
            ListInternalized.gt(match);
            int n = startIndex - count + 1;
            this.bo(n, count);
            return this.gt(n, count, match);
        }

        @Override
        public void forEach(bo<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.bo.size(); ++i) {
                action.invoke(this.bo.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.bo(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.bo.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.bo(index);
            return com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), item, index, this.bo.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.bo.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.ax.bo(this.bo.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.bo.size() == 0) {
                return -1;
            }
            return i7.bo(this.bo.toArray(), item, this.bo.size() - 1, this.bo.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.bo(index);
            return i7.bo(this.bo.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return i7.bo(this.bo.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.bo.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.bo.size());
        }

        @Override
        public boolean trueForAll(u3<T> match) {
            ListInternalized.gt(match);
            for (int i = 0; i < this.bo.size(); ++i) {
                if (match.invoke(this.bo.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.bo.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.bo.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.bo.size(); ++i) {
                this.bo.add(null);
            }
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public T get_Item(int index) {
            return this.bo.get(index);
        }

        @Override
        public void copyTo(ax array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.ax() > 1 || array.gt(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo.toArray()), 0, array, arrayIndex, this.bo.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.bo.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.bo.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.bo.size(); ++i) {
                    if (this.bo.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.bo.size(); ++i) {
                if (!this.bo.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.bo.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.gt;
            return this.bo.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.gt;
            return this.bo.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.bo.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.gt;
            return this.bo.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.gt;
            return this.bo.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.gt;
            return this.bo.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.gt;
            return this.bo.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.bo.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.gt;
            return this.bo.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.gt;
            this.bo.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.gt;
            return this.bo.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.bo.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.bo.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.bo.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.bo.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.bo.add(item);
            ++this.gt;
        }

        @Override
        public void clear() {
            this.bo.clear();
            ++this.gt;
        }

        @Override
        public void insertItem(int index, T item) {
            this.bo.add(index, item);
            ++this.gt;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.bo.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.bo.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.bo.add(n++, e);
                }
            }
            ++this.gt;
        }

        @Override
        public int removeAll(u3<T> match) {
            ListInternalized.gt(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.bo.size() && !match.invoke(this.bo.get(n)); ++n) {
            }
            if (n == this.bo.size()) {
                return 0;
            }
            ++this.gt;
            for (n10 = n + 1; n10 < this.bo.size(); ++n10) {
                if (match.invoke(this.bo.get(n10))) continue;
                this.bo.set(n++, this.bo.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.bo.remove(this.bo.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.bo.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.bo.remove(index);
            ++this.gt;
        }

        @Override
        public void removeRange(int index, int count) {
            this.bo(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.bo.remove(index);
                }
                ++this.gt;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.bo(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.bo.get(n);
                this.bo.set(n, this.bo.get(i));
                this.bo.set(i, t);
            }
            ++this.gt;
        }

        @Override
        public void sort() {
            Collections.sort(this.bo, null);
            ++this.gt;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.bo, comparer);
            ++this.gt;
        }

        @Override
        public void sort(final pf<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.bo, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.bo(o12, o22);
                }
            });
            ++this.gt;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.bo(index, count);
            java.util.List<T> list = this.bo.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.bo.set(index + i, list.get(i));
            }
            ++this.gt;
        }

        @Override
        public void set_Item(int index, T value) {
            this.bo(index);
            if ((long)index == (long)this.bo.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.bo.set(index, value);
            ++this.gt;
        }

        @Override
        private void bo(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @hn
    public static class EnumeratorJava<T>
    extends vh<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> gt = new List();
        private int lk;
        private int ax;
        private T oz;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.gt = l;
            this.ax = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void bo() {
            if (this.ax != this.gt.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.lk < 0 || this.lk >= this.gt.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.ax != this.gt.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.oz = this.gt.get_Item(this.lk++);
            return this.oz;
        }

        @Override
        public boolean hasNext() {
            if (this.ax == this.gt.getVersion()) {
                if (this.lk < 0) {
                    return false;
                }
                return this.lk < this.gt.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.bo();
            this.lk = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.gt = this.gt;
            that.lk = this.lk;
            that.ax = this.ax;
            that.oz = this.oz;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean bo(EnumeratorJava enumeratorJava) {
            return xo.bo(enumeratorJava.gt, this.gt) && enumeratorJava.lk == this.lk && enumeratorJava.ax == this.ax && xo.bo(enumeratorJava.oz, this.oz);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (xo.gt(null, obj)) {
                return false;
            }
            if (xo.gt(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.bo((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.gt != null ? this.gt.hashCode() : 0;
            n = 31 * n + this.lk;
            n = 31 * n + this.ax;
            n = 31 * n + (this.oz != null ? this.oz.hashCode() : 0);
            return n;
        }
    }

    @hn
    public static class Enumerator<T>
    extends vh<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> gt = new List();
        private int lk;
        private int ax;
        private T oz;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.gt = l;
            this.ax = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void bo() {
            if (this.ax != this.gt.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.ax == this.gt.getVersion()) {
                if (this.lk < 0) {
                    return false;
                }
                if (this.lk < this.gt.size()) {
                    this.oz = this.gt.get_Item(this.lk++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.lk = this.gt.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.bo();
            this.lk = 0;
        }

        @Override
        public T next() {
            if (this.lk < 0 || this.lk >= this.gt.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.oz;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.gt = this.gt;
            that.lk = this.lk;
            that.ax = this.ax;
            that.oz = this.oz;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean bo(Enumerator enumerator) {
            return xo.bo(enumerator.gt, this.gt) && enumerator.lk == this.lk && enumerator.ax == this.ax && xo.bo(enumerator.oz, this.oz);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (xo.gt(null, obj)) {
                return false;
            }
            if (xo.gt(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.bo((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.gt != null ? this.gt.hashCode() : 0;
            n = 31 * n + this.lk;
            n = 31 * n + this.ax;
            n = 31 * n + (this.oz != null ? this.oz.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.bo = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.bo != 0;
        }

        @Override
        public int nextIndex() {
            return this.bo;
        }

        @Override
        public int previousIndex() {
            return this.bo - 1;
        }

        public T previous() {
            int n = this.bo - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.bo;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.bo = n;
            this.gt = n;
            return objectArray[this.gt];
        }

        public void set(T e) {
            if (this.gt < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.gt, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.bo;
                List.this.add(n, e);
                this.bo = n + 1;
                this.gt = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int bo;
        int gt = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.bo != List.this.gt;
        }

        @Override
        public T next() {
            int n = this.bo;
            if (n >= List.this.gt) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.bo;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.bo = n + 1;
            this.gt = n;
            return (T)objectArray[this.gt];
        }

        @Override
        public void remove() {
            if (this.gt < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.gt);
                this.bo = this.gt;
                this.gt = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

