/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.xd.vh;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.n5;
import com.aspose.slides.ms.System.xo;
import java.util.Arrays;

@hn
public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] bo;
    private int gt;
    private int lk;
    private int ax;
    private int oz;
    private final Object gl;

    public Queue() {
        this.bo = new Object[0];
        this.gl = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.bo = new Object[capacity];
        this.gl = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.bo = new Object[n];
        for (Object t : collection) {
            this.enqueue(t);
        }
        this.gl = this;
    }

    public void clear() {
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, this.bo.length);
        this.ax = 0;
        this.lk = 0;
        this.gt = 0;
        ++this.oz;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t : this) {
                if (t != null) continue;
                return true;
            }
        } else {
            for (Object t : this) {
                if (!item.equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(ax array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.oz() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.oz() - arrayIndex < this.ax) {
            throw new ArgumentException();
        }
        if (this.ax == 0) {
            return;
        }
        try {
            int n = this.bo.length;
            int n10 = n - this.gt;
            com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), this.gt, array, arrayIndex, n5.gt(this.ax, n10));
            if (this.ax > n10) {
                com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), 0, array, arrayIndex + n10, this.ax - n10);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t = this.peek();
        this.bo[this.gt] = null;
        if (++this.gt == this.bo.length) {
            this.gt = 0;
        }
        --this.ax;
        ++this.oz;
        return t;
    }

    public T peek() {
        if (this.ax == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.bo[this.gt];
    }

    public void enqueue(T item) {
        if (this.ax == this.bo.length || this.lk == this.bo.length) {
            this.bo(n5.bo(n5.bo(this.ax, this.lk) * 2, 4));
        }
        this.bo[this.lk] = item;
        if (++this.lk == this.bo.length) {
            this.lk = 0;
        }
        ++this.ax;
        ++this.oz;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.ax) {
            return Arrays.copyOf(this.bo, this.ax, a.getClass());
        }
        System.arraycopy(this.bo, 0, a, 0, this.ax);
        if (a.length > this.ax) {
            a[this.ax] = null;
        }
        return a;
    }

    public void trimExcess() {
        if ((double)this.ax < (double)this.bo.length * 0.9) {
            this.bo(this.ax);
        }
    }

    private void bo(int n) {
        if (n == this.bo.length) {
            return;
        }
        if (n < this.ax) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n];
        if (this.ax > 0) {
            this.copyTo(com.aspose.slides.ms.System.ax.bo(objectArray), 0);
        }
        this.bo = objectArray;
        this.lk = this.ax;
        this.gt = 0;
        ++this.oz;
    }

    @Override
    public int size() {
        return this.ax;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.gl;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    @hn
    public static class Enumerator<T>
    extends vh<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Queue<T> gt;
        private int lk;
        private int ax;

        public Enumerator() {
        }

        Enumerator(Queue<T> q) {
            this.gt = q;
            this.lk = -2;
            this.ax = ((Queue)q).oz;
        }

        @Override
        public void dispose() {
            this.lk = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.ax != ((Queue)this.gt).oz) {
                throw new InvalidOperationException();
            }
            if (this.lk == -2) {
                this.lk = ((Queue)this.gt).ax;
            }
            return this.lk != -1 && --this.lk != -1;
        }

        @Override
        public T next() {
            if (this.lk < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.gt).bo[(((Queue)this.gt).ax - 1 - this.lk + ((Queue)this.gt).gt) % ((Queue)this.gt).bo.length];
        }

        @Override
        public void reset() {
            if (this.ax != ((Queue)this.gt).oz) {
                throw new InvalidOperationException();
            }
            this.lk = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.gt = this.gt;
            that.lk = this.lk;
            that.ax = this.ax;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean bo(Enumerator enumerator) {
            return xo.bo(enumerator.gt, this.gt) && enumerator.lk == this.lk && enumerator.ax == this.ax;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (xo.gt(null, obj)) {
                return false;
            }
            if (xo.gt(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.bo((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.gt != null ? this.gt.hashCode() : 0;
            n = 31 * n + this.lk;
            n = 31 * n + this.ax;
            return n;
        }
    }
}

