/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.xd.lk;
import com.aspose.slides.internal.xd.vh;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.i7;
import com.aspose.slides.ms.System.xo;
import java.util.Arrays;

@hn
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] bo;
    private int gt;
    private int lk;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.bo = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.gt = collection.size();
            this.bo = new Object[this.gt];
            collection.copyToTArray(this.bo, 0);
        }
    }

    public void clear() {
        if (this.bo != null) {
            ax.bo(this.bo, 0, this.bo.length);
        }
        this.gt = 0;
        ++this.lk;
    }

    public boolean contains(T item) {
        return this.bo != null && ax.bo(this.bo, item, 0, this.gt) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.gt - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.bo != null) {
            ax.bo(this.bo, 0, array, arrayIndex, this.gt);
            i7.bo(array, arrayIndex, this.gt);
        }
    }

    public T peek() {
        if (this.gt == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.bo[this.gt - 1];
    }

    public T pop() {
        if (this.gt == 0) {
            throw new InvalidOperationException();
        }
        ++this.lk;
        Object object = this.bo[--this.gt];
        this.bo[this.gt] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.bo == null || this.gt == this.bo.length) {
            if (this.bo == null) {
                this.bo = new Object[16];
            }
            this.bo = Arrays.copyOf(this.bo, this.gt == 0 ? 16 : 2 * this.gt);
        }
        ++this.lk;
        this.bo[this.gt++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.gt) {
            this.copyTo(ax.bo(array), 0);
            return array;
        }
        ax ax3 = ax.bo(com.aspose.slides.internal.xd.lk.bo(array.getClass().getComponentType()), this.gt);
        this.copyTo(ax3, 0);
        return (Object[])ax.bo(ax3);
    }

    public void trimExcess() {
        if (this.bo != null && (double)this.gt < (double)this.bo.length * 0.9) {
            this.bo = Arrays.copyOf(this.bo, this.gt);
        }
        ++this.lk;
    }

    @Override
    public int size() {
        return this.gt;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ax dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.bo != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.gt) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.gt - idx > dest.oz()) {
                    throw new ArgumentException("idx");
                }
                ax.bo(ax.bo(this.bo), 0, dest, idx, this.gt);
                ax.gt(dest, idx, this.gt);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @hn
    public static class Enumerator<T>
    extends vh<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> gt;
        private int lk;
        private int ax;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.gt = t;
            this.lk = -2;
            this.ax = ((Stack)t).lk;
        }

        @Override
        public void dispose() {
            this.lk = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.ax != ((Stack)this.gt).lk) {
                throw new IllegalStateException();
            }
            if (this.lk == -2) {
                this.lk = ((Stack)this.gt).gt;
            }
            return this.lk != -1 && --this.lk != -1;
        }

        @Override
        public T next() {
            if (this.lk < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.gt).bo[this.lk];
        }

        @Override
        public void reset() {
            if (this.ax != ((Stack)this.gt).lk) {
                throw new IllegalStateException();
            }
            this.lk = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.gt = this.gt;
            that.lk = this.lk;
            that.ax = this.ax;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean bo(Enumerator enumerator) {
            return xo.bo(enumerator.gt, this.gt) && enumerator.lk == this.lk && enumerator.ax == this.ax;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (xo.gt(null, obj)) {
                return false;
            }
            if (xo.gt(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.bo((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.gt != null ? this.gt.hashCode() : 0;
            n = 31 * n + this.lk;
            n = 31 * n + this.ax;
            return n;
        }
    }
}

