/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.bb.z0;
import com.aspose.slides.internal.hc.bo;
import com.aspose.slides.internal.hc.gt;
import com.aspose.slides.internal.j3.mo;
import com.aspose.slides.internal.j3.mt;
import com.aspose.slides.internal.j3.o7;
import com.aspose.slides.internal.j3.zf;
import com.aspose.slides.internal.xd.gl;
import com.aspose.slides.internal.xd.lk;
import com.aspose.slides.internal.xd.vh;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.hz;
import com.aspose.slides.ms.System.xo;
import com.aspose.slides.ms.System.yc;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@hn
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
com.aspose.slides.internal.j3.vh,
zf,
yc,
Map {
    private IGenericEqualityComparer bo;
    private final Object gt = new Object();
    private Bucket[] lk;
    private int ax;
    private volatile boolean oz;
    private ICollection gl;
    private float vh;
    private int oc;
    private o7 z0;
    private int zf;
    private ICollection uj;
    private volatile int sj;
    private static final gl gj = new gl("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", hz.bo("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.vh = 0.72f * loadFactor;
        double d = (float)capacity / this.vh;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.hc.bo.bo((int)d) : 11;
        this.lk = this.gt(n);
        this.oc = (int)(this.vh * (float)n);
        this.oz = false;
    }

    protected Hashtable(o7 info, mt context) {
        this.z0 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.bo = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.bo = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.bo(key, value, true);
    }

    @Override
    public void clear() {
        if (this.ax != 0) {
            this.oz = true;
            for (int i = 0; i < this.lk.length; ++i) {
                this.lk[i].lk = 0;
                this.lk[i].bo = null;
                this.lk[i].gt = null;
            }
            this.ax = 0;
            this.zf = 0;
            this.ax();
            this.oz = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.lk;
        Hashtable hashtable = new Hashtable(this.ax, this.bo);
        hashtable.sj = this.sj;
        hashtable.vh = this.vh;
        hashtable.ax = 0;
        int n = this.lk.length;
        while (n > 0) {
            Object object = bucketArray[--n].bo;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].gt);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.lk;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.bo(key, this.lk.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.lk.length);
        do {
            bucketArray[n10].bo(bucket);
            if (bucket.bo == null) {
                return false;
            }
            if ((long)(bucket.lk & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.bo, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.lk.length);
        } while (bucket.lk < 0 && ++n < this.lk.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.lk.length;
            while (--n >= 0) {
                if (this.lk[n].bo == null || this.lk[n].bo == this.lk || this.lk[n].gt != null) continue;
                return true;
            }
        } else {
            int n = this.lk.length;
            while (--n >= 0) {
                Object object = this.lk[n].gt;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void lk(ax ax3, int n) {
        Bucket[] bucketArray = this.lk;
        int n10 = this.lk.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].bo;
            if (object == null || object == this.lk) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].gt);
            ax3.lk(dictionaryEntry.Clone(), n++);
        }
    }

    void bo(ax ax3, int n) {
        Bucket[] bucketArray = this.lk;
        int n10 = this.lk.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].bo;
            if (object == null || object == this.lk) continue;
            ax3.lk(object, n++);
        }
    }

    @Override
    public void copyTo(ax array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.ax() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.oz() - arrayIndex < this.ax) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.lk(array, arrayIndex);
    }

    void gt(ax ax3, int n) {
        Bucket[] bucketArray = this.lk;
        int n10 = this.lk.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].bo;
            if (object == null || object == this.lk) continue;
            ax3.lk(bucketArray[n10].gt, n++);
        }
    }

    private void gt() {
        int n = com.aspose.slides.internal.hc.bo.bo(this.lk.length * 2);
        this.bo(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.bo != null) {
            return this.bo.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(o7 info, mt context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.bo("LoadFactor", this.vh);
        info.bo("Version", this.sj);
        if (this.bo == null) {
            info.bo("Comparer", null, com.aspose.slides.internal.xd.lk.bo(Comparator.class));
            info.bo("HashCodeProvider", null, com.aspose.slides.internal.xd.lk.bo(IHashCodeProvider.class));
        } else if (this.bo instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.xd.lk.bo(this.bo, CompatibleComparer.class);
            info.bo("Comparer", objectArray.bo(), com.aspose.slides.internal.xd.lk.bo(Comparator.class));
            info.bo("HashCodeProvider", objectArray.gt(), com.aspose.slides.internal.xd.lk.bo(IHashCodeProvider.class));
        } else {
            info.bo("KeyComparer", this.bo, com.aspose.slides.internal.xd.lk.bo(IGenericEqualityComparer.class));
        }
        info.bo("HashSize", this.lk.length);
        objectArray = new Object[this.ax];
        Object[] objectArray2 = new Object[this.ax];
        this.bo(com.aspose.slides.ms.System.ax.bo(objectArray), 0);
        this.gt(com.aspose.slides.ms.System.ax.bo(objectArray2), 0);
        info.bo("Keys", objectArray, com.aspose.slides.internal.xd.lk.bo(Object[].class));
        info.bo("Values", objectArray2, com.aspose.slides.internal.xd.lk.bo(Object[].class));
    }

    private long bo(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void bo(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.ax >= this.oc) {
                this.gt();
            } else if (this.zf > this.oc && this.ax > 100) {
                this.lk();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.bo(object, this.lk.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.lk.length);
            do {
                if (n10 == -1 && this.lk[n11].bo == this.lk && this.lk[n11].lk < 0) {
                    n10 = n11;
                }
                if (this.lk[n11].bo == null || this.lk[n11].bo == this.lk && ((long)this.lk[n11].lk & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.oz = true;
                    this.lk[n11].gt = object2;
                    this.lk[n11].bo = object;
                    this.lk[n11].lk |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.ax;
                    this.ax();
                    this.oz = false;
                    break block12;
                }
                if ((long)(this.lk[n11].lk & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.lk[n11].bo, object)) {
                    if (bl2) {
                        throw new ArgumentException(hz.bo("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.lk[n11].bo, object));
                    }
                    this.oz = true;
                    this.lk[n11].gt = object2;
                    this.ax();
                    this.oz = false;
                    break block12;
                }
                if (n10 == -1 && this.lk[n11].lk >= 0) {
                    this.lk[n11].lk = (int)((long)this.lk[n11].lk | Integer.MIN_VALUE);
                    ++this.zf;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.lk.length);
            } while (++n < this.lk.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.oz = true;
            this.lk[n10].gt = object2;
            this.lk[n10].bo = object;
            this.lk[n10].lk |= (int)(l11 & 0xFFFFFFFFL);
            ++this.ax;
            this.ax();
            this.oz = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (xo.gt(this.lk, item)) {
            return false;
        }
        if (this.bo != null) {
            return this.bo.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.lk == null) {
            if (this.z0 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            mo mo3 = this.z0.ax();
            while (mo3.hasNext()) {
                switch (gj.bo(mo3.gt())) {
                    case 0: {
                        this.vh = this.z0.gt("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.z0.bo("HashSize");
                        break;
                    }
                    case 2: {
                        this.bo = (IGenericEqualityComparer)this.z0.bo("KeyComparer", com.aspose.slides.internal.xd.lk.bo(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.z0.bo("Comparer", com.aspose.slides.internal.xd.lk.bo(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.z0.bo("HashCodeProvider", com.aspose.slides.internal.xd.lk.bo(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.z0.bo("Keys", com.aspose.slides.internal.xd.lk.bo(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.z0.bo("Values", com.aspose.slides.internal.xd.lk.bo(Object[].class));
                    }
                }
            }
            this.oc = (int)(this.vh * (float)n);
            if (this.bo == null && (comparator != null || iHashCodeProvider != null)) {
                this.bo = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.lk = this.gt(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.bo(objectArray[i], objectArray2[i], true);
            }
            this.sj = this.z0.bo("Version");
            this.z0 = null;
        }
    }

    private void bo(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].bo == null || bucketArray[n10].bo == this.lk) {
                bucketArray[n10].gt = object2;
                bucketArray[n10].bo = object;
                bucketArray[n10].lk |= n;
                break;
            }
            if (bucketArray[n10].lk >= 0) {
                bucketArray[n10].lk = (int)((long)bucketArray[n10].lk | Integer.MIN_VALUE);
                ++this.zf;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void lk() {
        this.bo(this.lk.length);
    }

    private void bo(int n) {
        this.zf = 0;
        Bucket[] bucketArray = this.gt(n);
        for (int i = 0; i < this.lk.length; ++i) {
            Bucket bucket = this.lk[i].bo();
            if (bucket.bo == null || bucket.bo == this.lk) continue;
            this.bo(bucketArray, bucket.bo, bucket.gt, bucket.lk & Integer.MAX_VALUE);
        }
        this.oz = true;
        this.lk = bucketArray;
        this.oc = (int)(this.vh * (float)n);
        this.ax();
        this.oz = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.bo(key, this.lk.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.lk.length);
        do {
            this.lk[n10].bo(bucket);
            if ((long)(bucket.lk & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.bo, key)) {
                this.oz = true;
                this.lk[n10].lk = (int)((long)this.lk[n10].lk & Integer.MIN_VALUE);
                this.lk[n10].bo = this.lk[n10].lk != 0 ? this.lk : null;
                this.lk[n10].gt = null;
                --this.ax;
                this.ax();
                this.oz = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.lk.length);
        } while (bucket.lk < 0 && ++n < this.lk.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] bo() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.ax];
        int n = 0;
        Bucket[] bucketArray = this.lk;
        int n10 = this.lk.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].bo;
            if (object == null || object == this.lk) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].gt);
        }
        return keyValuePairsArray;
    }

    private void ax() {
        ++this.sj;
    }

    private Bucket[] gt(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.ax;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.bo;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.lk;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.bo(key, this.lk.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.lk.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.sj;
                bucketArray[n10].bo(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.bb.z0.gt(1);
            } while (this.oz || n11 != this.sj);
            if (bucket.bo == null) break;
            if ((long)(bucket.lk & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.bo, key)) {
                return bucket.gt;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.lk.length);
        } while (bucket.lk < 0 && ++n < this.lk.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.bo(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.gl == null) {
            this.gl = new KeyCollection(this);
        }
        return this.gl;
    }

    @Override
    public Object getSyncRoot() {
        return this.gt;
    }

    @Override
    public ICollection getValues() {
        if (this.uj == null) {
            this.uj = new ValueCollection(this);
        }
        return this.uj;
    }

    @Override
    public boolean isEmpty() {
        return this.ax == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        ax ax3 = com.aspose.slides.ms.System.ax.bo(objectArray);
        this.getKeys().copyTo(ax3, 0);
        return new ReadOnlyItemCollection(ax3);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        ax ax3 = com.aspose.slides.ms.System.ax.bo(objectArray);
        this.getValues().copyTo(ax3, 0);
        return new ReadOnlyItemCollection(ax3);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.bo();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].bo(), keyValuePairsArray[i].gt());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.ax.bo(entryArray));
    }

    public int getVersion() {
        return this.sj;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new gt(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private ax gt;

        ReadOnlyItemCollection(ax items) {
            this.gt = items;
        }

        @Override
        public int size() {
            return this.gt.size();
        }

        @Override
        public boolean isEmpty() {
            return this.gt.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.gt.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.gt.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            ax ax3 = com.aspose.slides.ms.System.ax.bo(objectArray);
            this.gt.copyTo(ax3, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.gt.copyTo(com.aspose.slides.ms.System.ax.bo(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @hn
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable bo;

        SyncHashtable(Hashtable table) {
            super(false);
            this.bo = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.bo.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.bo.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.bo.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array, int arrayIndex) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.bo.iterator();
        }

        @Override
        public void getObjectData(o7 info, mt context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.bo("ParentTable", this.bo, com.aspose.slides.internal.xd.lk.bo(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] bo() {
            return this.bo.bo();
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.bo.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.bo.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.bo.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.getValues();
            }
        }
    }

    @hn
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable bo;

        ValueCollection(Hashtable hashtable) {
            this.bo = hashtable;
        }

        @Override
        public void copyTo(ax array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ax() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.oz() - arrayIndex < this.bo.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.bo.gt(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.bo, 2);
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }
    }

    @hn
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable bo;

        KeyCollection(Hashtable hashtable) {
            this.bo = hashtable;
        }

        @Override
        public void copyTo(ax array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ax() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.oz() - arrayIndex < this.bo.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.bo.bo(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.bo, 1);
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }
    }

    @hn
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int bo;
        private boolean gt;
        private Object lk;
        private Object ax;
        private int oz;
        private Hashtable gl;
        private int vh;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.gl = hashtable;
            this.bo = hashtable.lk.length;
            this.vh = hashtable.sj;
            this.gt = false;
            this.oz = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.vh != this.gl.sj) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.bo > 0) {
                --this.bo;
                Object object = ((Hashtable)this.gl).lk[this.bo].bo;
                if (object == null || object == this.gl.lk) continue;
                this.lk = object;
                this.ax = ((Hashtable)this.gl).lk[this.bo].gt;
                this.gt = true;
                return true;
            }
            this.gt = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.vh != this.gl.sj) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.gt = false;
            this.bo = this.gl.lk.length;
            this.lk = null;
            this.ax = null;
        }

        @Override
        public Object next() {
            if (!this.gt) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.oz == 1) {
                return this.lk;
            }
            if (this.oz == 2) {
                return this.ax;
            }
            return new DictionaryEntry(this.lk, this.ax);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.gt) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.lk, this.ax);
        }

        @Override
        public Object getKey() {
            if (!this.gt) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.lk;
        }

        @Override
        public Object getValue() {
            if (!this.gt) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.ax;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object bo;
        private Object gt;

        public KeyValuePairs(Object key, Object value) {
            this.gt = value;
            this.bo = key;
        }

        public Object bo() {
            return this.bo;
        }

        public Object gt() {
            return this.gt;
        }
    }

    private static class Bucket
    extends vh<Bucket> {
        public Object bo;
        public Object gt;
        public int lk;

        public void bo(Bucket bucket) {
            bucket.bo = this.bo;
            bucket.gt = this.gt;
            bucket.lk = this.lk;
        }

        public Bucket bo() {
            Bucket bucket = new Bucket();
            this.bo(bucket);
            return bucket;
        }

        public Object clone() {
            return this.bo();
        }

        private boolean gt(Bucket bucket) {
            return xo.bo(bucket.bo, this.bo) && xo.bo(bucket.gt, this.gt) && bucket.lk == this.lk;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (xo.gt(null, obj)) {
                return false;
            }
            if (xo.gt(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.gt((Bucket)obj);
        }

        public int hashCode() {
            int n = this.bo != null ? this.bo.hashCode() : 0;
            n = 31 * n + (this.gt != null ? this.gt.hashCode() : 0);
            n = 31 * n + this.lk;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.bo();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.bo((Bucket)object);
        }
    }

    @hn
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator bo;
        private IHashCodeProvider gt;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.bo = comparer;
            this.gt = hashCodeProvider;
        }

        public int bo(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.bo != null) {
                return this.bo.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.xd.lk.bo(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.bo(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.gt != null) {
                return this.gt.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator bo() {
            return this.bo;
        }

        IHashCodeProvider gt() {
            return this.gt;
        }
    }
}

