/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.hn;

@hn
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> bo;
    private IGenericEqualityComparer<TKey> gt;
    private int lk;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.gt = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.lk = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.bo = new Dictionary(this.gt);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.bo != null) {
            return this.bo.containsKey(key);
        }
        return this.bo(key) >= 0;
    }

    private int bo(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.gt.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.bo != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.bo.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.bo(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.gt;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.bo != null && ((Dictionary.KeyCollection)this.bo.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.bo.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.bo != null) {
            return this.bo.get_Item(key);
        }
        int n = this.bo(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.gt.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.bo != null) {
            if (!this.bo.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.bo.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.bo != null) {
            this.bo.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.bo != null && this.bo.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.bo == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.gt.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.bo != null) {
            this.bo.addItem(TKey, item);
        } else if (this.lk != -1 && this.size() > this.lk) {
            this.bo = new Dictionary(this.gt);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.bo.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.bo != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.bo.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.bo != null) {
            this.bo.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.bo.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.bo;
    }
}

