/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.yc;
import java.util.Arrays;

@hn
public class Queue
implements ICollection,
IEnumerable,
yc {
    private Object[] bo;
    private int gt = 0;
    private int lk = 0;
    private int ax = 0;
    private int oz;
    private int gl = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.bo = new Object[capacity];
        this.oz = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.lk;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ax array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ax() > 1 || index != 0 && index >= array.oz() || this.lk > array.oz() - index) {
            throw new ArgumentException();
        }
        int n = this.bo.length;
        int n10 = n - this.gt;
        com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), this.gt, array, index, Math.min(this.lk, n10));
        if (this.lk > n10) {
            com.aspose.slides.ms.System.ax.bo(com.aspose.slides.ms.System.ax.bo(this.bo), 0, array, index + n10, this.lk - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.bo.length);
        queue.oz = this.oz;
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, queue.bo, 0, this.bo.length);
        queue.gt = this.gt;
        queue.lk = this.lk;
        queue.ax = this.ax;
        return queue;
    }

    public void clear() {
        ++this.gl;
        this.gt = 0;
        this.lk = 0;
        this.ax = 0;
        for (int i = this.bo.length - 1; i >= 0; --i) {
            this.bo[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.gt + this.lk;
        if (obj == null) {
            for (int i = this.gt; i < n; ++i) {
                if (this.bo[i % this.bo.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.gt; i < n; ++i) {
                if (!obj.equals(this.bo[i % this.bo.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.gl;
        if (this.lk < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.bo[this.gt];
        this.bo[this.gt] = null;
        this.gt = (this.gt + 1) % this.bo.length;
        --this.lk;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.gl;
        if (this.lk == this.bo.length) {
            this.bo();
        }
        this.bo[this.ax] = obj;
        this.ax = (this.ax + 1) % this.bo.length;
        ++this.lk;
    }

    public Object peek() {
        if (this.lk < 1) {
            throw new InvalidOperationException();
        }
        return this.bo[this.gt];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.lk) {
            return Arrays.copyOf(this.bo, this.lk, a.getClass());
        }
        System.arraycopy(this.bo, 0, a, 0, this.lk);
        if (a.length > this.lk) {
            a[this.lk] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.gl;
        Object[] objectArray = new Object[this.lk];
        this.copyTo(com.aspose.slides.ms.System.ax.bo(objectArray), 0);
        this.bo = objectArray;
        this.gt = 0;
        this.ax = 0;
    }

    private void bo() {
        int n = this.bo.length * this.oz / 100;
        if (n < this.bo.length + 1) {
            n = this.bo.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.ax.bo(objectArray), 0);
        this.bo = objectArray;
        this.gt = 0;
        this.ax = this.gt + this.lk;
    }

    @hn
    private static class QueueEnumerator
    implements IEnumerator,
    yc {
        private Queue bo;
        private int gt;
        private int lk;

        QueueEnumerator(Queue q) {
            this.bo = q;
            this.gt = q.gl;
            this.lk = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.bo);
            queueEnumerator.gt = this.gt;
            queueEnumerator.lk = this.lk;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.gt != this.bo.gl || this.lk < 0 || this.lk >= this.bo.lk) {
                throw new InvalidOperationException();
            }
            return this.bo.bo[(this.bo.gt + this.lk) % this.bo.bo.length];
        }

        @Override
        public boolean hasNext() {
            if (this.gt != this.bo.gl) {
                throw new InvalidOperationException();
            }
            if (this.lk >= this.bo.lk - 1) {
                this.lk = Integer.MAX_VALUE;
                return false;
            }
            ++this.lk;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.gt != this.bo.gl) {
                throw new InvalidOperationException();
            }
            this.lk = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue bo;

        SyncQueue(Queue queue) {
            this.bo = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.bo;
            synchronized (queue) {
                return this.bo.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array, int index) {
            Queue queue = this.bo;
            synchronized (queue) {
                this.bo.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.bo;
            synchronized (queue) {
                return this.bo.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.bo;
            synchronized (queue) {
                return new SyncQueue((Queue)this.bo.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.bo;
            synchronized (queue) {
                this.bo.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.bo;
            synchronized (queue) {
                this.bo.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.bo;
            synchronized (queue) {
                return this.bo.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.bo;
            synchronized (queue) {
                return this.bo.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.bo;
            synchronized (queue) {
                this.bo.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.bo;
            synchronized (queue) {
                return this.bo.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.bo;
            synchronized (queue) {
                return this.bo.toArray(a);
            }
        }
    }
}

