/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.xd.vh;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.bd;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.hz;
import com.aspose.slides.ms.System.xo;
import com.aspose.slides.ms.System.yc;
import java.util.Comparator;

@hn
public class SortedList
implements IDictionary,
yc {
    private final Object bo = new Object();
    private Slot[] gt;
    private Comparator lk;
    private int ax;
    private int oz;
    private int gl;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.gl = capacity == 0 ? 0 : 16;
        this.lk = comparer;
        this.gt(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.lk = comparer;
        this.gt(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.gt(d.size(), true);
        this.lk = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.ax;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.bo;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.bo(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.gt(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.bo(key, value, true);
    }

    public int getCapacity() {
        return this.gt.length;
    }

    public void setCapacity(int value) {
        int n = this.gt.length;
        if (this.ax > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.bo(this.gl);
            SortedList.bo(this.gt, 0, slotArray, 0, this.ax);
            this.gt = slotArray;
        } else if (value > this.ax) {
            Slot[] slotArray = SortedList.bo(value);
            SortedList.bo(this.gt, 0, slotArray, 0, this.ax);
            this.gt = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.bo(value);
            SortedList.bo(this.gt, 0, slotArray, 0, n);
            this.gt = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.bo(key, value, false);
    }

    @Override
    public void clear() {
        this.gl = 16;
        this.gt = SortedList.bo(this.gl);
        this.ax = 0;
        ++this.oz;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.gt(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(ax array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.ax() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.oz()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.oz() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.lk(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.lk);
        sortedList.oz = this.oz;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.gt;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.bo(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].bo = null;
                slotArray[index].gt = null;
            }
            --this.ax;
            ++this.oz;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.gt(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.ax == 0) {
            return -1;
        }
        for (int i = 0; i < this.ax; ++i) {
            Slot slot = this.gt[i].Clone();
            if (!xo.bo(value, slot.gt)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.gt[index].gt;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.gt[index].gt = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.gt[index].bo;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.bo(this.gl, false);
        } else {
            this.bo(this.size(), true);
        }
    }

    private void bo(int n, boolean bl2) {
        Slot[] slotArray = this.gt;
        Slot[] slotArray2 = SortedList.bo(n);
        if (bl2) {
            SortedList.bo(slotArray, 0, slotArray2, 0, n);
        }
        this.gt = slotArray2;
    }

    private void bo(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.gt;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.bo(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.bo(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.bo(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.bo(slotArray, 0, slotArray2, 0, this.size());
            }
            this.gt = slotArray2;
        } else if (bl2) {
            SortedList.bo(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void bo(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.gt;
        int n = -1;
        try {
            n = this.gt(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = hz.bo("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].gt = object2;
            ++this.oz;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(hz.bo(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.bo(this.size() + 1, n);
        slotArray = this.gt;
        slotArray[n].bo = object;
        slotArray[n].gt = object2;
        ++this.ax;
        ++this.oz;
    }

    private Object bo(Object object) {
        int n = this.gt(object);
        if (n >= 0) {
            return this.gt[n].gt;
        }
        return null;
    }

    private void gt(int n, boolean bl2) {
        if (!bl2 && n < this.gl) {
            n = this.gl;
        }
        this.gt = SortedList.bo(n);
        this.ax = 0;
        this.oz = 0;
    }

    private void bo(ax ax3, int n, int n10) {
        if (ax3 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > ax3.oz()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            ax3.lk(enumerator.next(), n++);
        }
    }

    private int gt(Object object) {
        Slot[] slotArray = this.gt;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.lk == null ? Comparer.Default : this.lk;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].bo, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] bo(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean bo(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void bo(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.bo(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList bo;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.bo = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.bo.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.bo.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                iCollection = this.bo.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                iCollection = this.bo.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.bo(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.bo(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array, int arrayIndex) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.bo(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.gt(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.bo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.bo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val2) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                return this.bo.indexOfValue(val2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.bo.getSyncRoot();
            synchronized (object) {
                this.bo.trimToSize();
            }
        }
    }

    @hn
    private static class ListValues
    implements IList {
        private SortedList bo;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.bo = host;
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        @Override
        public void copyTo(ax array, int arrayIndex) {
            this.bo.bo(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.bo.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.bo.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.bo, 1);
        }
    }

    @hn
    private static class ListKeys
    implements IList {
        private SortedList bo;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.bo = host;
        }

        @Override
        public int size() {
            return this.bo.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.bo.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        @Override
        public void copyTo(ax array, int arrayIndex) {
            this.bo.bo(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.bo.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.bo.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.bo.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.bo, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    yc {
        private SortedList bo;
        private Object gt;
        private Object lk;
        private int ax;
        private int oz;
        private int gl;
        private int vh;
        private boolean oc = false;
        private static String z0 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.bo = host;
            this.ax = host.oz;
            this.gl = host.size();
            this.vh = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.bo.oz != this.ax || this.oc) {
                throw new IllegalStateException(z0);
            }
            this.oz = -1;
            this.gt = null;
            this.lk = null;
        }

        @Override
        public boolean hasNext() {
            if (this.bo.oz != this.ax || this.oc) {
                throw new InvalidOperationException(z0);
            }
            return ++this.oz < this.gl;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            return new DictionaryEntry(this.gt, this.lk);
        }

        @Override
        public Object getKey() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            return this.gt;
        }

        @Override
        public Object getValue() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            return this.lk;
        }

        @Override
        public Object next() {
            if (this.bo.oz != this.ax || this.oc) {
                throw new InvalidOperationException(z0);
            }
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                if (this.oz >= this.gl) {
                    this.gt = null;
                    this.lk = null;
                }
                throw new IllegalStateException(z0);
            }
            Slot[] slotArray = this.bo.gt;
            Slot slot = slotArray[this.oz].Clone();
            this.gt = slot.bo;
            this.lk = slot.gt;
            switch (this.vh) {
                case 0: {
                    return this.gt;
                }
                case 1: {
                    return this.lk;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(hz.bo(new String[]{bd.getName(EnumeratorMode.class, this.vh), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.bo, this.vh);
            enumeratorJava.ax = this.ax;
            enumeratorJava.oz = this.oz;
            enumeratorJava.gl = this.gl;
            enumeratorJava.gt = this.gt;
            enumeratorJava.lk = this.lk;
            enumeratorJava.oc = this.oc;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    yc {
        private SortedList bo;
        private Object gt;
        private Object lk;
        private int ax;
        private int oz;
        private int gl;
        private int vh;
        private boolean oc = false;
        private static String z0 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.bo = host;
            this.ax = host.oz;
            this.gl = host.size();
            this.vh = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.bo.oz != this.ax || this.oc) {
                throw new IllegalStateException(z0);
            }
            this.oz = -1;
            this.gt = null;
            this.lk = null;
        }

        @Override
        public boolean hasNext() {
            if (this.bo.oz != this.ax || this.oc) {
                throw new InvalidOperationException(z0);
            }
            Slot[] slotArray = this.bo.gt;
            if (++this.oz < this.gl) {
                Slot slot = slotArray[this.oz].Clone();
                this.gt = slot.bo;
                this.lk = slot.gt;
                return true;
            }
            this.gt = null;
            this.lk = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            return new DictionaryEntry(this.gt, this.lk);
        }

        @Override
        public Object getKey() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            return this.gt;
        }

        @Override
        public Object getValue() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            return this.lk;
        }

        @Override
        public Object next() {
            if (this.oc || this.oz >= this.gl || this.oz == -1) {
                throw new IllegalStateException(z0);
            }
            switch (this.vh) {
                case 0: {
                    return this.gt;
                }
                case 1: {
                    return this.lk;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(hz.bo(new String[]{bd.getName(EnumeratorMode.class, this.vh), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.bo, this.vh);
            enumerator.ax = this.ax;
            enumerator.oz = this.oz;
            enumerator.gl = this.gl;
            enumerator.gt = this.gt;
            enumerator.lk = this.lk;
            enumerator.oc = this.oc;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends bd {
        private EnumeratorMode() {
        }

        static {
            bd.register(new bd.oz(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @hn
    public static class Slot
    extends vh<Slot> {
        Object bo;
        Object gt;

        @Override
        public void CloneTo(Slot that) {
            that.bo = this.bo;
            that.gt = this.gt;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean bo(Slot slot) {
            return xo.bo(slot.bo, this.bo) && xo.bo(slot.gt, this.gt);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (xo.gt(null, obj)) {
                return false;
            }
            if (xo.gt(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.bo((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.bo != null ? this.bo.hashCode() : 0;
            n = 31 * n + (this.gt != null ? this.gt.hashCode() : 0);
            return n;
        }
    }
}

