/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.pq.up;
import com.aspose.slides.internal.xd.lk;
import com.aspose.slides.internal.xd.vh;
import com.aspose.slides.ms.System.w8;
import com.aspose.slides.ms.System.x1;

public class BitVector32
extends vh<BitVector32> {
    private int bo;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.bo = value.bo;
    }

    public BitVector32(int data) {
        this.bo = data;
    }

    public int getData() {
        return this.bo;
    }

    public int get_Item(Section section) {
        return this.bo >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.bo &= ~(section.getMask() << section.getOffset());
        this.bo |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.bo & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.bo = value ? (this.bo |= bit) : (this.bo &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.bo(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.bo(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(lk.gt((Object)n10, 9), lk.gt((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return lk.gt(o, BitVector32.class) && this.bo == lk.ax((Object)o, BitVector32.class).bo;
    }

    public int hashCode() {
        return x1.bo(this.bo);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        up up2 = new up();
        up2.bo("BitVector32{");
        for (long i = lk.gl((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            up2.bo(((long)value.bo & i) == 0L ? (char)'0' : '1');
        }
        up2.bo('}');
        return up2.toString();
    }

    private static int bo(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.bo = this.bo;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends vh<Section> {
        private short bo;
        private short gt;

        public Section() {
        }

        Section(short mask, short offset) {
            this.bo = mask;
            this.gt = offset;
        }

        public short getMask() {
            return this.bo;
        }

        public short getOffset() {
            return this.gt;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.bo == b.bo && a.gt == b.gt;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.bo != b.bo || a.gt != b.gt;
        }

        public boolean equals(Section obj) {
            return this.bo == obj.bo && this.gt == obj.gt;
        }

        public boolean equals(Object o) {
            if (!lk.gt(o, Section.class)) {
                return false;
            }
            Section section = lk.ax(o, Section.class).Clone();
            return this.bo == section.bo && this.gt == section.gt;
        }

        public int hashCode() {
            return this.bo << this.gt;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            up up2 = new up();
            up2.bo("Section{0x");
            up2.bo(w8.bo(value.getMask(), 16));
            up2.bo(", 0x");
            up2.bo(w8.bo(value.getOffset(), 16));
            up2.bo("}");
            return up2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.bo = this.bo;
            that.gt = this.gt;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

