/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.ax;
import com.aspose.slides.ms.System.hn;
import com.aspose.slides.ms.System.i7;
import com.aspose.slides.ms.System.yc;
import java.util.Arrays;

@hn
public class Stack
implements ICollection,
IEnumerable,
yc {
    private Object[] bo;
    private int gt = -1;
    private int lk;
    private int ax;
    private int oz;

    private void bo(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.ax.bo(this.bo, 0, objectArray, 0, this.lk);
        this.ax = n;
        this.bo = objectArray;
    }

    public Stack() {
        this.bo = new Object[16];
        this.ax = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.ax = initialCapacity;
        this.bo = new Object[this.ax];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.lk;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.oz;
        for (int i = 0; i < this.lk; ++i) {
            this.bo[i] = null;
        }
        this.lk = 0;
        this.gt = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.ax.bo(this.bo));
        stack.gt = this.gt;
        stack.lk = this.lk;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.lk == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.lk; ++i) {
                if (this.bo[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.lk; ++i) {
                if (!obj.equals(this.bo[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(ax array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ax() > 1 || array.oz() > 0 && index >= array.oz() || this.lk > array.oz() - index) {
            throw new ArgumentException();
        }
        for (int i = this.gt; i != -1; --i) {
            array.lk(this.bo[i], this.lk - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.gt == -1) {
            throw new InvalidOperationException();
        }
        return this.bo[this.gt];
    }

    public Object pop() {
        if (this.gt == -1) {
            throw new InvalidOperationException();
        }
        ++this.oz;
        Object object = this.bo[this.gt];
        this.bo[this.gt] = null;
        --this.lk;
        --this.gt;
        if (this.lk <= this.ax / 4 && this.lk > 16) {
            this.bo(this.ax / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.oz;
        if (this.ax == this.lk) {
            this.bo(this.ax * 2);
        }
        ++this.lk;
        ++this.gt;
        this.bo[this.gt] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.lk) {
            a = Arrays.copyOf(this.bo, this.lk, a.getClass());
            i7.bo(a);
            return a;
        }
        System.arraycopy(this.bo, 0, a, 0, this.lk);
        if (a.length > this.lk) {
            a[this.lk] = null;
        }
        i7.bo(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    yc,
    Cloneable {
        private Stack bo;
        private int gt;
        private int lk;

        Enumerator(Stack s) {
            this.bo = s;
            this.gt = s.oz;
            this.lk = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.bo();
        }

        @Override
        public Object next() {
            if (this.gt != this.bo.oz || this.lk == -2 || this.lk == -1 || this.lk > this.bo.lk) {
                throw new InvalidOperationException();
            }
            return this.bo.bo[this.lk];
        }

        @Override
        public boolean hasNext() {
            if (this.gt != this.bo.oz) {
                throw new InvalidOperationException();
            }
            switch (this.lk) {
                case -2: {
                    this.lk = this.bo.gt;
                    return this.lk != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.lk;
            return this.lk != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.gt != this.bo.oz) {
                throw new InvalidOperationException();
            }
            this.lk = -2;
        }

        protected Object bo() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.bo = this.bo;
            enumerator.gt = this.gt;
            enumerator.lk = this.lk;
            return enumerator;
        }
    }

    @hn
    private static class SyncStack
    extends Stack {
        private final Stack bo;

        SyncStack(Stack s) {
            this.bo = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.bo;
            synchronized (stack) {
                return this.bo.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.bo.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.bo;
            synchronized (stack) {
                this.bo.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.bo;
            synchronized (stack) {
                return Stack.sync((Stack)this.bo.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.bo;
            synchronized (stack) {
                return this.bo.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ax array, int index) {
            Stack stack = this.bo;
            synchronized (stack) {
                this.bo.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.bo;
            synchronized (stack) {
                return new Enumerator(this.bo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.bo;
            synchronized (stack) {
                return this.bo.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.bo;
            synchronized (stack) {
                return this.bo.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.bo;
            synchronized (stack) {
                this.bo.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.bo;
            synchronized (stack) {
                return this.bo.toArray(a);
            }
        }
    }
}

