/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IMathElement;
import com.aspose.slides.IMathMatrix;
import com.aspose.slides.MathElementBase;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.xd.lk;
import com.aspose.slides.ju;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ogs;
import com.aspose.slides.u8g;

public final class MathMatrix
extends MathElementBase
implements IMathMatrix,
ju {
    private boolean ax;
    private int oz;
    private long gl;
    private int vh;
    private long oc;
    private int z0;
    private long zf;
    private final List<List<IMathElement>> uj;
    private int[] sj;
    final u8g bo;

    @Override
    public final int getRowCount() {
        return this.uj.size();
    }

    @Override
    public final int getColumnCount() {
        return this.uj.get_Item(0).size();
    }

    @Override
    public final boolean getHidePlaceholders() {
        return this.ax;
    }

    @Override
    public final void setHidePlaceholders(boolean value) {
        this.ax = value;
    }

    @Override
    public final int getBaseJustification() {
        return this.oz;
    }

    @Override
    public final void setBaseJustification(int value) {
        this.oz = value;
    }

    @Override
    public final long getMinColumnWidth() {
        return this.gl;
    }

    @Override
    public final void setMinColumnWidth(long value) {
        this.gl = value;
    }

    @Override
    public final int getColumnGapRule() {
        return this.vh;
    }

    @Override
    public final void setColumnGapRule(int value) {
        this.vh = value;
    }

    @Override
    public final long getColumnGap() {
        return this.oc;
    }

    @Override
    public final void setColumnGap(long value) {
        this.oc = value;
    }

    @Override
    public final int getRowGapRule() {
        return this.z0;
    }

    @Override
    public final void setRowGapRule(int value) {
        this.z0 = value;
    }

    @Override
    public final long getRowGap() {
        return this.zf;
    }

    @Override
    public final void setRowGap(long value) {
        this.zf = value;
    }

    @Override
    public final IMathElement get_Item(int row, int column) {
        return this.uj.get_Item(row).get_Item(column);
    }

    @Override
    public final void set_Item(int row, int column, IMathElement value) {
        this.uj.get_Item(row).set_Item(column, value);
    }

    @Override
    public final u8g getControlCharacterProperties() {
        return this.bo;
    }

    public MathMatrix(int rowCount, int columnCount) {
        if (rowCount < 1) {
            throw new ArgumentOutOfRangeException("rowCount");
        }
        if (columnCount < 1) {
            throw new ArgumentOutOfRangeException("columnCount");
        }
        this.uj = new List(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.uj.addItem(this.bo(columnCount));
        }
        this.setHidePlaceholders(false);
        this.setBaseJustification(2);
        this.setMinColumnWidth(0L);
        this.setColumnGapRule(0);
        this.sj = new int[columnCount];
        this.setColumnsAlignment(0, (long)this.sj.length & 0xFFFFFFFFL, 2);
        this.bo = new u8g();
    }

    @Override
    public final int getColumnAlignment(int columnIndex) {
        if (columnIndex < 0) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        return this.sj[columnIndex];
    }

    @Override
    public final void setColumnAlignment(int columnIndex, int val2) {
        this.setColumnsAlignment(columnIndex, 1L, val2);
    }

    @Override
    public final void setColumnsAlignment(int columnIndex, long columnsCount, int val2) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if ((columnsCount & 0xFFFFFFFFL) < 0L || ((long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL) > (long)this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnsCount");
        }
        long l = (long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n = columnIndex;
        while ((long)n < l) {
            this.sj[n] = val2;
            ++n;
        }
    }

    @Override
    public final void insertRowBefore(int rowIndex) {
        this.uj.insertItem(rowIndex, this.bo(this.getColumnCount()));
    }

    @Override
    public final void insertRowAfter(int rowIndex) {
        this.insertRowBefore(rowIndex + 1);
    }

    @Override
    public final void deleteRow(int rowIndex) {
        if (this.getRowCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing row in the matrix");
        }
        this.uj.removeAt(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertColumnBefore(int columnIndex) {
        IGenericEnumerator iGenericEnumerator = this.uj.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.insertItem(columnIndex, null);
            }
        }
        finally {
            if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public final void insertColumnAfter(int columnIndex) {
        this.insertColumnBefore(columnIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteColumn(int columnIndex) {
        if (this.getColumnCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing column in the matrix");
        }
        IGenericEnumerator iGenericEnumerator = this.uj.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.removeAt(columnIndex);
            }
        }
        finally {
            if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IMathElement[] getChildren() {
        Object object;
        IGenericEnumerator iGenericEnumerator;
        IMathElement[] iMathElementArray;
        int n = 0;
        IGenericEnumerator iGenericEnumerator2 = this.uj.iterator();
        try {
            while (iGenericEnumerator2.hasNext()) {
                iMathElementArray = (IMathElement[])iGenericEnumerator2.next();
                iGenericEnumerator = iMathElementArray.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        object = (IMathElement)iGenericEnumerator.next();
                        if (object == null) continue;
                        ++n;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        finally {
            if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator2, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator2).dispose();
            }
        }
        if (n == 0) {
            return lk;
        }
        iMathElementArray = new IMathElement[n];
        n = 0;
        iGenericEnumerator = this.uj.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object = (List)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator3 = ((List)object).iterator();
                try {
                    while (iGenericEnumerator3.hasNext()) {
                        IMathElement iMathElement = (IMathElement)iGenericEnumerator3.next();
                        if (iMathElement == null) continue;
                        iMathElementArray[n++] = iMathElement;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator3, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator3).dispose();
                }
            }
            return iMathElementArray;
        }
        finally {
            if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    void bo(ogs ogs2) {
        ogs2.bo(this);
    }

    private List<IMathElement> bo(int n) {
        List<IMathElement> list = new List<IMathElement>(n);
        for (int i = 0; i < n; ++i) {
            list.addItem(null);
        }
        return list;
    }
}

