/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.IOutputFile;
import com.aspose.slides.Input;
import com.aspose.slides.Output;
import com.aspose.slides.Storage;
import com.aspose.slides.WebDocumentOptions;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.xd.lk;
import com.aspose.slides.ms.System.IDisposable;

public class WebDocument {
    private final WebDocumentOptions bo;
    private final Input gt;
    private final Output lk;
    private final Storage ax = new Storage();

    public WebDocument(WebDocumentOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        if (options.getTemplateEngine() == null) {
            throw new ArgumentException("TemplateEngine should not be null", "options");
        }
        if (options.getOutputSaver() == null) {
            throw new ArgumentException("OutputSaver should not be null", "options");
        }
        this.bo = options;
        this.gt = new Input(this.bo.getTemplateEngine());
        this.lk = new Output(this.bo.getTemplateEngine(), this.ax);
    }

    public final void save() {
        IGenericEnumerator iGenericEnumerator = this.lk.bo().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                this.bo.getOutputSaver().save((String)keyValuePair.getKey(), (IOutputFile)keyValuePair.getValue());
            }
        }
        finally {
            if (com.aspose.slides.internal.xd.lk.bo(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    public final Input getInput() {
        return this.gt;
    }

    public final Output getOutput() {
        return this.lk;
    }

    public final Storage getGlobal() {
        return this.ax;
    }
}

