/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzU8;
import com.aspose.words.Border;
import com.aspose.words.zzZSI;
import java.awt.Color;
import java.util.Iterator;

public class BorderCollection
implements Iterable<Border> {
    private zzZSI zzZZa;

    BorderCollection(zzZSI parent) {
        this.zzZZa = parent;
    }

    public Border getByBorderType(int borderType) throws Exception {
        Object v = this.zzZZa.getPossibleBorderKeys().get(borderType);
        if (v == null) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        int n = (Integer)v;
        Border border = (Border)this.zzZZa.getDirectBorderAttr(n);
        if (border == null) {
            border = new Border(this.zzZZa, n);
            this.zzZZa.setBorderAttr(n, border);
        }
        return border;
    }

    public Border get(int index) throws Exception {
        int n = (Integer)this.zzZZa.getPossibleBorderKeys().getKey(index);
        return this.getByBorderType(n);
    }

    public Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public int getCount() {
        return this.zzZZa.getPossibleBorderKeys().getCount();
    }

    public double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzZZa.getPossibleBorderKeys().zzDY().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTz(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzZZa.getPossibleBorderKeys().zzDY().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTz(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public Color getColor() throws Exception {
        BorderCollection borderCollection = this;
        return borderCollection.get(0).zzyl().zzUr();
    }

    public void setColor(Color value) throws Exception {
        zzU8 zzU82 = zzU8.zzZ(value);
        BorderCollection borderCollection = this;
        Iterator iterator = borderCollection.zzZZa.getPossibleBorderKeys().zzDY().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTz(n)) continue;
            borderCollection.getByBorderType(n).zzx(zzU82);
        }
    }

    public double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzZZa.getPossibleBorderKeys().zzDY().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTz(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzZZa.getPossibleBorderKeys().zzDY().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTz(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public Iterator iterator() {
        return new zzZ(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzTz(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZ
    implements Iterator {
        private BorderCollection zzZYV;
        private int zzZYU;

        zzZ(BorderCollection borderCollection) {
            this.zzZYV = borderCollection;
            this.zzZYU = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZYU >= this.zzZYV.getCount() - 1) {
                return false;
            }
            ++this.zzZYU;
            return true;
        }

        public final Object next() {
            try {
                return this.zzZYV.get(this.zzZYU);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

