/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzZ;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.zzX;
import com.aspose.words.zzZGC;
import com.aspose.words.zzZGV;
import com.aspose.words.zzZQ0;
import com.aspose.words.zzZQ1;
import com.aspose.words.zzZQE;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZQ0,
Iterable<T> {
    private Node zzZT6;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzsq() {
        CompositeNode compositeNode = this;
        return zzX.zzJ(compositeNode.getFirstChild()) != null;
    }

    final boolean zzsp() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzso() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof zzZQE)) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        if (this.getLastChild() != null) {
            return this.getLastChild().zzZDk();
        }
        return null;
    }

    public Node getLastChild() {
        return this.zzZT6;
    }

    final Node zzsn() {
        return zzX.zzJ(this.getFirstChild());
    }

    final Node zzsm() {
        return zzX.zzI(this.getLastChild());
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ(boolean bl, zzZQ1 zzZQ12) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ(bl, zzZQ12);
        ((CompositeNode)super.zzZ(bl, zzZQ12)).zzZT6 = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzi(node.zzZ(true, zzZQ12));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzU(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzU(StringBuilder stringBuilder) {
        this.zzT(stringBuilder);
        zzZ.zzY(stringBuilder, this.zzsl());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    @Deprecated
    public NodeCollection getChildNodes(int nodeType, boolean isDeep, boolean isLive) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            Node node2;
            int n = index + 1;
            boolean bl = zzX.zzU4(nodeType);
            if (bl) {
                CompositeNode compositeNode = this;
                node2 = zzX.zzJ(compositeNode.getFirstChild());
            } else {
                node2 = node = this.getFirstChild();
            }
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZDn() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzX.zzZ((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzX.zzY((Node)this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZGV(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ(oldChild, this, null, 1);
        if (documentBase.zz6G() && zzX.zzz(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (oldChild == this.getFirstChild()) {
            if (this.getLastChild().zzZDk() == this.getLastChild()) {
                this.zzZT6 = null;
            } else {
                Node node = oldChild.zzZDk();
                this.getLastChild().zzZk(node);
                node.zzZj(this.getLastChild());
            }
        } else {
            Node node = oldChild.zzZDj();
            Node node2 = oldChild.zzZDk();
            node.zzZk(node2);
            node2.zzZj(node);
            if (oldChild == this.getLastChild()) {
                this.zzZT6 = node;
            }
        }
        oldChild.zzZk(null);
        oldChild.zzZj(null);
        oldChild.zzZi(null);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        return oldChild;
    }

    public void removeAllChildren() {
        zzZGC.zzx(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzi(Node node) {
        node.getParentNode();
        if (this.getLastChild() == null) {
            node.zzZj(node);
            node.zzZk(node);
        } else {
            Node node2 = this.getLastChild().zzZDk();
            node.zzZj(this.getLastChild());
            node.zzZk(node2);
            node2.zzZj(node);
            this.getLastChild().zzZk(node);
        }
        this.zzZT6 = node;
        node.zzZi(this);
        return node;
    }

    final void zzZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzh(Node node) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzX.zzY(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzsl().length();
    }

    String zzsl() {
        return "";
    }

    final String zzsk() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzT(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzT(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzU(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY(visitor));
    }

    abstract int zzZ(DocumentVisitor var1) throws Exception;

    abstract int zzY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzm(Node var1);

    final Node zzZ(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZh(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzm(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        if ((nodeChangingArgs = documentBase.zzZ(node, null, this, 0)) != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (this.getLastChild() == null) {
            node.zzZj(node);
            node.zzZk(node);
            this.zzZT6 = node;
        } else if (bl) {
            if (node2 != null) {
                CompositeNode.zzV(node, node2);
                if (node2 == this.getLastChild()) {
                    this.zzZT6 = node;
                }
            } else {
                CompositeNode.zzV(node, this.getLastChild());
            }
        } else if (node2 != null) {
            Node node3 = node2.getPreviousSibling();
            if (node3 == null) {
                node3 = this.getLastChild();
            }
            CompositeNode.zzV(node, node3);
        } else {
            CompositeNode.zzV(node, this.getLastChild());
            this.zzZT6 = node;
        }
        node.zzZi(this);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        if (documentBase.zz6G()) {
            zzX.zzA(node);
        }
        return node;
    }

    private static void zzV(Node node, Node node2) {
        Node node3 = node2.zzZDk();
        node.zzZj(node2);
        node.zzZk(node3);
        node2.zzZk(node);
        node3.zzZj(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node[] curNode) {
        Node node = curNode[0];
        curNode[0] = curNode[0] == this ? this.getFirstChild() : curNode[0].getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

