/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz32;
import asposewobfuscated.zz7V;
import asposewobfuscated.zz7W;
import asposewobfuscated.zz7X;
import asposewobfuscated.zz84;
import asposewobfuscated.zz95;
import asposewobfuscated.zzAW;
import asposewobfuscated.zzAX;
import asposewobfuscated.zzC9;
import asposewobfuscated.zzDL;
import asposewobfuscated.zzYC;
import asposewobfuscated.zzYO;
import asposewobfuscated.zzYP;
import asposewobfuscated.zzZ;
import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.zz0A;
import com.aspose.words.zz3Q;
import com.aspose.words.zz3V;
import com.aspose.words.zz6;
import com.aspose.words.zz9K;
import com.aspose.words.zzDM;
import com.aspose.words.zzEA;
import com.aspose.words.zzEG;
import com.aspose.words.zzG6;
import com.aspose.words.zzIK;
import com.aspose.words.zzMW;
import com.aspose.words.zzX;
import com.aspose.words.zzYG;
import com.aspose.words.zzYQK;
import com.aspose.words.zzYT3;
import com.aspose.words.zzYVL;
import com.aspose.words.zzYVW;
import com.aspose.words.zzYWJ;
import com.aspose.words.zzZ0D;
import com.aspose.words.zzZ1K;
import com.aspose.words.zzZ8J;
import com.aspose.words.zzZ9E;
import com.aspose.words.zzZ9I;
import com.aspose.words.zzZI;
import com.aspose.words.zzZIE;
import com.aspose.words.zzZPG;
import com.aspose.words.zzZPJ;
import com.aspose.words.zzZQQ;
import com.aspose.words.zzZSF;
import com.aspose.words.zzZSH;
import com.aspose.words.zzZV1;
import com.aspose.words.zzZVM;
import com.aspose.words.zzZX3;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;

public class DocumentBuilder
implements zzZPG,
zzZPJ,
zzZSH {
    private Document zzZrt;
    private Node zzZpY;
    private Node zzZpX;
    private zzZ1K zzZpW;
    private Font zzZpV;
    private zz95 zzZpU;
    private zzYVL zzZpT = zzYVL.zzZfv();
    private zzYG zzZXl = new zzYG();
    private RowFormat zzZpS;
    private CellFormat zzZXk;
    private zz95 zzZpR;
    private int zzZpQ = 0;
    private int zzZpP = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzP(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzP(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzP(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.zzZ(this.getCurrentSection(), zzYQK.zzxS(headerFooterType), 0, 0);
    }

    private void zzP(int n, int n2, int n3, int n4) {
        this.zzZrt.ensureMinimum();
        Section section = (Section)this.zzZrt.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYQK.zzxR(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZrt, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZrt));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzY(paragraph, n2);
    }

    final void zzY(Paragraph paragraph, int n) {
        if (n == 0) {
            this.zzZ(paragraph, paragraph.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz66().isRemoved() ? zzZIE.zzT(this.zzZrt, fieldName) : zzZIE.zzS(this.zz66(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZQQ zzZQQ2 = field.getFormat().zzZYT();
        Inline inline = zzZQQ2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzZYU(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZI.zzX(this.zzZrt, bookmarkName) : zzZI.zzW(this.zzZrt, bookmarkName);
        if (node == null) {
            return false;
        }
        this.zzZ((Paragraph)node.zzZDr(), isAfter ? node.getNextSibling() : node);
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZ6(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzY(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzY(cell.getLastParagraph(), -1);
        }
    }

    private void zzZ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || zzX.zzM(node)) {
            this.zze(node);
        } else if (zzX.zzP(node)) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zze(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zz6h();
            return;
        }
        if (!this.zz6i()) {
            this.zz6h();
        }
    }

    private boolean zz6i() {
        Node node = this.zz66();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz66(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ(inline.zzZYU(), true);
            return true;
        }
        return false;
    }

    private void zz6h() {
        this.zzZ(this.getCurrentParagraph().zzZvt(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ6(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz69() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz66().zzZh(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZDn();
                this.zzY(paragraph, 0);
            }
        }
        row.remove();
        if (!table.zzsq()) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzI(text, false);
    }

    public void writeln(String text) {
        this.zzI(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYWJ zzYWJ2 = new zzYWJ(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZrt, this.zz6e(), this.zz6f());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zz66(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYWJ2.dispose();
        }
        if (this.getDocument().zz6G()) {
            zzX.zzX(paragraph, this.getDocument().zz6L());
        }
        return this.getCurrentParagraph();
    }

    public void insertBreak(int breakType) {
        this.zzo(breakType, true);
    }

    final void zzo(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXx(bl)) {
                    this.zzSJ(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXx(bl)) {
                    this.zzSJ(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzXx(bl)) {
                    this.zzNC(1);
                }
                return;
            }
            case 5: {
                if (this.zzXx(bl)) {
                    this.zzNC(2);
                }
                return;
            }
            case 3: {
                if (this.zzXx(bl)) {
                    this.zzNC(0);
                }
                return;
            }
            case 6: {
                if (this.zzXx(bl)) {
                    this.zzNC(3);
                }
                return;
            }
            case 7: {
                if (this.zzXx(bl)) {
                    this.zzNC(4);
                }
                return;
            }
            case 8: {
                this.zzSJ(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzDL.zzYL(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz32.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX.zzZ(fieldType, updateField, this.zz6f(), this.zz66(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX.zzZ(fieldCode, this.zz6f(), this.zz66(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX.zzZ(fieldCode, fieldValue, this.zz6f(), this.zz66(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZ.zzZ((Object)displayText, "displayText");
        zzZ.zzZ((Object)urlOrBookmark, "hrefOrBookmark");
        zz3V zz3V2 = this.zzZ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zz3V2.zzY(documentBuilder.zzn(88, true));
        return zzX.zzZ(zz3V2.getStart(), zz3V2.getSeparator(), zz3V2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzNB(70);
        if (zzDL.zzYL(name)) {
            this.startBookmark(name);
        }
        this.zzSI(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzNA(70);
        String string = zzDL.zzYL(fieldValue) ? fieldValue : FormField.zzZ7E;
        Run run = new Run(this.zzZrt, string, this.zz6f());
        this.insertNode(run);
        this.zzn(70, true);
        if (zzDL.zzYL(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzf(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        return this.insertCheckBox(name, checkedValue, checkedValue, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzNB(71);
        if (zzDL.zzYL(name)) {
            this.startBookmark(name);
        }
        this.zzSI(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzn(71, false);
        if (zzDL.zzYL(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzf(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzNB(83);
        if (zzDL.zzYL(name)) {
            this.startBookmark(name);
        }
        this.zzSI(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzn(83, false);
        if (zzDL.zzYL(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzf(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZrt, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX.zzUd(footnoteType));
        if (zzDL.zzYL(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZrt);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX.zzUc(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZrt, '\u0002', new zzZ1K()) : new Run(this.zzZrt, footnote.getReferenceMark(), new zzZ1K());
        inline.getFont().setStyleIdentifier(zzX.zzUd(footnoteType));
        paragraph.appendChild(inline);
        if (zzDL.zzYL(footnoteText)) {
            Node node = this.zz66();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zze(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zz9(zz7V zz7V2) throws Exception {
        return this.zzZ(zz7V2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zz9(zz7V.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz7V zz7V2, double d, double d2) throws Exception {
        return this.zzZ(zz7V2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz7V.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zz7X zz7X2 = new zz7X();
        try {
            zzYC.zzZ(image, zz7X2);
            Shape shape = this.zzZ(zz7X2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zz7X2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzC9.zzYw(fileName);
        try {
            Shape shape = this.zzZ((zz7V)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz7V)object).close();
            }
        }
    }

    private Shape zzZ(zz7V zz7V2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz7V2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZ.zzZ(zz7V2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz7V.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZrt.getCompatibilityOptions().getMswVersion() > 12 || this.zzZrt.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzZrt, 0);
            zzDM zzDM2 = new zzDM();
            zzDM2.zzZ(zzG6.zzT4("rect"));
            zzDM2.zzZ(new zzMW());
            zzEA zzEA2 = new zzEA();
            zzEA2.zzY(new zzEG(shape.getId(), ""));
            zzEA2.zzZ(new zzIK());
            zzDM2.zzZ(zzEA2);
            shape.zzM9(75);
            shape.zzX(zzDM2);
        } else {
            shape = new Shape((DocumentBase)this.zzZrt, 75);
        }
        shape.zzR(this.zz6f());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzC(width, height);
        return shape;
    }

    private Shape zzO(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz7X zz7X2 = new zz7X();
        try {
            zzYC.zzZ(bufferedImage, zz7X2);
            byArray = zzZ.zzZ(zz7X2);
        }
        finally {
            zz7X2.close();
        }
        return this.zzZq(byArray);
    }

    private Shape zzZq(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZrt, 1);
        shape.zzM9(75);
        shape.zzR(this.zz6f());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzC(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        BufferedImage bufferedImage = presentation;
        boolean bl = asIcon;
        String string = progId;
        zz7X zz7X2 = zz7V.zzY(stream);
        DocumentBuilder documentBuilder = this;
        zzZ9I zzZ9I2 = zzZ9I.zzLw(string);
        Shape shape = bufferedImage != null ? documentBuilder.zzO(bufferedImage) : documentBuilder.zzZq(zzZ9E.zzZ(zzZ9I2, bl));
        shape.zzM9(-2);
        shape.getOleFormat().setProgId(zzZ9I2.zzYub);
        shape.getOleFormat().zzY(zzZ9E.zzZ(zz7X2, string, bl));
        return shape;
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ9I zzZ9I2 = zzZ9I.zzLv(zz7W.zzXG(fileName));
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ9I2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ9I zzZ9I2 = zzZ9I.zzLw(progId);
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ9I2);
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZ9I zzZ9I2) throws Exception {
        Shape shape = bufferedImage != null ? this.zzO(bufferedImage) : this.zzZq(zzZ9E.zzZ(zzZ9I2, bl2));
        shape.zzM9(-2);
        shape.getOleFormat().setProgId(zzZ9I2.zzYub);
        shape.getOleFormat().zzY(zzZ9E.zzV(string, bl, bl2));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzZ(zzZV1 zzZV12, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzO(bufferedImage);
        shape.zzM9(201);
        shape.getOleFormat().zzY(zzZV12.zzZRg());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZVM zzZVM2 = new zzZVM();
        zzZVM2.zzWF(useBuilderFormatting);
        zzZVM2.zzWE(useBuilderFormatting);
        this.zzZ(html, zzZVM2);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZSF zzZSF2 = new zzZSF();
        return zzZSF2.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYT3(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYT3(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZrt, 75);
        shape.zzR(this.zz6f());
        boolean bl = true;
        Shape shape2 = shape;
        if (!shape2.isSignatureLine()) {
            shape2.setShapeAttr(1983, true);
            shape2.setShapeAttr(1921, zz84.zzCz().toString("B").toUpperCase());
            shape2.setShapeAttr(1922, zz84.zzdS.toString("B").toUpperCase());
        }
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzC(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    private void zzZ(String string, zzZVM zzZVM2) throws Exception {
        Object object;
        Object object2 = this;
        boolean bl = false;
        if (((DocumentBuilder)object2).zz66().getParentNode().getNodeType() == 28) {
            object = (StructuredDocumentTag)((DocumentBuilder)object2).zz66().getParentNode();
            switch (((StructuredDocumentTag)object).getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        if (bl) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzSK(documentBuilder.getDocument().toString(70)));
            return;
        }
        object = this;
        zzZVM zzZVM3 = zzZVM2;
        object2 = string;
        zzZX3 zzZX32 = new zzZX3((String)object2, zzZVM3, (DocumentBuilder)object);
        zzZX32.read();
    }

    private static String zzSK(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zz69() == null) {
            this.startTable();
        }
        if (this.zz69().zzZgz() == 1) {
            this.zz69().zzZgC();
        }
        if (this.zz69().zzZgz() == 3) {
            this.zz69().zzZgA();
        }
        return this.zz69().zzZgB();
    }

    public Table startTable() {
        this.zzZpR.push(new zzYVW(this));
        return this.zz69().startTable();
    }

    public Table endTable() {
        if (this.zz69() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz69().endTable();
        this.zzZpR.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz69() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz69().endRow();
        if (this.zzZpV != null && this.zzZpV.getHidden()) {
            row.zz65().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZrt, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZrt, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZrt);
        this.zzZpP = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZpP == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZrt, this.zzZpP);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZrt, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return new zz9K(this).zzZ(srcDoc, importFormatMode, 93);
    }

    public Document getDocument() {
        return this.zzZrt;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZrt) {
            return;
        }
        this.zzZrt = value;
        this.zze(null);
        this.zzZpW = new zzZ1K();
        this.zzZpU = null;
        this.zzZpV = null;
        this.zzZpR = new zz95();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZpV == null) {
            this.zzZpV = new Font(this, this.getDocument());
        }
        return this.zzZpV;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZpS == null) {
            this.zzZpS = new RowFormat(this);
        }
        return this.zzZpS;
    }

    public CellFormat getCellFormat() {
        if (this.zzZXk == null) {
            this.zzZXk = new CellFormat(this);
        }
        return this.zzZXk;
    }

    public void pushFont() {
        this.zz67().push(this.zz6f());
    }

    public void popFont() {
        zz95 zz952 = this.zz67();
        if (zz952.size() > 0) {
            this.zzZ((zzZ1K)this.zz67().pop(), false);
        }
    }

    private zz3V zzZ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzNB(88);
        zz3Q zz3Q2 = new zz3Q();
        zz3Q2.setTarget(string2);
        zz3Q2.setScreenTip(string3);
        if (bl) {
            zz3Q2.setSubAddress(string);
        } else {
            zz3Q2.setAddress(zzAW.zzYq(string));
            zz3Q2.setSubAddress(zzAW.zzYp(string));
        }
        this.zzSI(zz3Q2.toString());
        FieldSeparator fieldSeparator = this.zzNA(88);
        return new zz3V(fieldStart, fieldSeparator, null);
    }

    final zz3V zzS(String string, String string2, String string3) {
        boolean bl = zzAW.zzYh(string);
        String string4 = bl ? zzAW.zzYp(string) : string;
        return this.zzZ(string4, bl, string2, string3);
    }

    final FieldEnd zz6g() {
        return this.zzn(88, true);
    }

    final zzZ1K zz6f() {
        return (zzZ1K)this.zzZpW.zzza();
    }

    final zzZ8J zz6e() {
        return (zzZ8J)this.getCurrentParagraph().zzZTv().zzza();
    }

    final zzYVL zz6d() {
        return (zzYVL)this.zz65().zzza();
    }

    final zzYG zz6c() {
        return (zzYG)this.zzx4().zzza();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz66(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz66().getNodeType() == 8;
    }

    private void zzI(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYQK.zzIe(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzSH(string2.substring(n, n + n2));
                }
                switch (this.zzZpQ) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzSJ(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzSH(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzSJ(String string) {
        Run run = new Run(this.zzZrt, string, this.zz6f());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zz69() != null && this.zz69().zzZgz() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz66().getParentNode().insertBefore(node, this.zz66());
    }

    final void zzND(int n) {
        this.zzXx(true);
        this.zzNC(n);
    }

    private void zzNC(int n) {
        this.insertParagraph();
        zzYWJ zzYWJ2 = new zzYWJ(this.getDocument());
        try {
            zzZ0D zzZ0D2 = (zzZ0D)this.getCurrentSection().zzZzR().zzza();
            Section section = new Section(this.zzZrt, zzZ0D2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZrt));
            this.zzZrt.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYWJ2.dispose();
        }
    }

    final FieldStart zzNB(int n) {
        return zzX.zzZ(n, this.zz6f(), this.zz66(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzSI(String string) {
        return zzX.zzY(string, this.zz6f(), this.zz66(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzn(int n, boolean bl) {
        return zzX.zzY(n, bl, this.zz6f(), this.zz66(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzNA(int n) {
        return zzX.zzY(n, this.zz6f(), this.zz66(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzf(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZrt, new zz0A(), this.zz6f());
        this.getCurrentParagraph().insertBefore(formField, node);
        return formField;
    }

    private boolean zzXx(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz69() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ6(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzSH(String string) {
        boolean bl;
        block4: {
            String string2 = string;
            DocumentBuilder documentBuilder = this;
            boolean bl2 = documentBuilder.getFont().getBidi();
            for (int i = 0; i < string2.length(); ++i) {
                boolean bl3;
                char c = string2.charAt(i);
                int n = zzAX.zzA(c);
                boolean bl4 = n == 0;
                boolean bl5 = bl3 = n == 3 || n == 4;
                if ((!bl2 || !bl4) && (bl2 || !bl3)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            zzYP zzYP2 = new zzYP(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYO zzYO2 : zzYP2.zzI(this.getParagraphFormat().getBidi())) {
                zz6 zz610 = zz6.zzZo(zzYO2.zzYb());
                zzZ1K zzZ1K2 = this.zz6f();
                zzZ1K2.zzU(265, zz610);
                if (zzYO2.zzY8()) {
                    zzZ1K2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZrt, zzYO2.getText(), zzZ1K2);
                this.insertNode(run);
            }
            return;
        }
        this.zzSJ(string);
    }

    final void zzZ(zzZ1K zzZ1K2, boolean bl) {
        this.zzZpW = bl ? (zzZ1K)zzZ1K2.zzza() : zzZ1K2;
    }

    final void zz6b() {
        this.zzZpW.clear();
    }

    final void zz6a() {
        if (this.zz68() != null) {
            zzYG zzYG2 = this.zz68().zzx4();
            zzYG zzYG3 = this.zzZXl = (zzYG)zzYG2.zzza();
            zzYG zzYG4 = zzYG2;
            Iterator iterator = zzYG.zzZX3.zzDW().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (zzYG4.contains(n)) {
                    Border border = new Border();
                    border.zzV((Border)zzYG4.get(n));
                    zzYG3.set(n, border);
                    continue;
                }
                zzYG3.remove(n);
            }
        }
    }

    final void zzNz(int n) {
        this.zzZpQ = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz66();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz66();
        }
        return (Paragraph)this.zz66().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYVW zz69() {
        zz95 zz952 = this.zzZpR;
        if (zz952.size() > 0) {
            return zzZ.zzZ(this.zzZpR.peek(), zzYVW.class);
        }
        return null;
    }

    private Cell zz68() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZZb();
    }

    private zz95 zz67() {
        if (this.zzZpU == null) {
            this.zzZpU = new zz95();
        }
        return this.zzZpU;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZpW.zzTS(fontAttr);
    }

    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZpW.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZC(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZC(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZpW.zzU(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZvk()) {
            this.getCurrentParagraph().zzZvt().zzU(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZpW.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZpW.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZvk()) {
            this.getCurrentParagraph().zzZvt().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz65().zzTS(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz65().zzTR(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz65().zzTQ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz65().zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz65().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz65().clear();
        zzYVL.zzZfv().zzY(this.zz65());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzx4().zzTS(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzx4().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzx4().zzTQ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zz68() != null ? this.zz68().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zzx4().zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzx4().clear();
    }

    private Node zz66() {
        Node node = this.zzZpY != null && this.zzZpY.getParentNode() == null ? this.zzZpX : this.zzZpY;
        if (node != null && node.zzZDi() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zze(Node node) {
        this.zzZpY = node;
        if (this.zzZpY != null) {
            this.zzZpX = this.zzZpY.getParentNode();
        }
    }

    private zzYVL zz65() {
        if (this.zz69() != null && this.zz69().zzZgz() == 1) {
            return this.zzZpT;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz65();
        }
        return this.zzZpT;
    }

    private zzYG zzx4() {
        if (this.zz69() != null && this.zz69().zzZgz() != 3) {
            return this.zzZXl;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZZb().zzx4();
        }
        return this.zzZXl;
    }
}

