/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz7V;
import asposewobfuscated.zz7Y;
import asposewobfuscated.zzDL;
import asposewobfuscated.zzE1;
import asposewobfuscated.zzS3;
import asposewobfuscated.zzW;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zz1M;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzE1 zzZa8 = new zzE1();
    private static zzE1 zzZa7 = new zzE1();
    private static zzE1 zzZa6 = new zzE1();
    private static zzE1 zzZa5 = new zzE1();
    private static zzE1 zzZa4 = new zzE1();
    private static zzE1 zzZa3 = new zzE1();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ.zzZ(fileName, "fileName");
        zz7Y zz7Y2 = zzZ.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz4(zz7Y2);
            return fileFormatInfo;
        }
        finally {
            ((zz7V)zz7Y2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz4(zzW.zzZ(stream));
    }

    static FileFormatInfo zz4(zz7V zz7V2) throws Exception {
        if (zz7V2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz1M zz1M2 = new zz1M();
            zz7V zz7V3 = zz7V2;
            zz1M zz1M3 = zz1M2;
            return zz1M2.zzY(zz7V3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzKR(zzS3.zzj(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzKW(zzS3.zzj(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzS3.zzXU(FileFormatUtil.zzKT(loadFormat));
        if (zzDL.zzYL(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzKR(FileFormatUtil.zzKS(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzKW(FileFormatUtil.zzKT(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzS3.zzXU(FileFormatUtil.zzKS(saveFormat));
        if (zzDL.zzYL(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzKW(zzS3.zzi(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        Object object = zzZa6.get(n);
        return "." + zzS3.zzXU(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzKX(int n) {
        return zzS3.toString(FileFormatUtil.zzKS(n));
    }

    static int zzKW(int n) {
        Object object = zzZa4.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzKV(int n) {
        Object object = zzZa3.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    static boolean zzKU(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzKT(int n) {
        Object object = zzZa8.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzKS(int n) {
        Object object = zzZa7.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzKR(int n) {
        Object object = zzZa5.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 28, null, 52, null, 22, 60, 60, null, 23, 61, 61, null, 31, 40, null, null, 39, 47, null, null, 40, 48, null, null, 32, 41, null, null, 33, 46, null, null, 36, 42, null, null, 34, 43, null, null, 35, 44, null, null, 29, 52, null, null, 30, 70, 62, null, 37, 71, null, null, 8, 100, null, null, 9, 105, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 38, 72, null, null, 2, 103, null, 2};
        for (int i = 0; i < 160; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZa4.add((Integer)object, object2);
                zzZa7.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZa5.contains((Integer)object)) {
                    zzZa5.add((Integer)object, object3);
                }
                zzZa8.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZa3.add((Integer)object, object4);
            zzZa6.add((Integer)object4, object);
        }
    }
}

