/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz2D;
import asposewobfuscated.zz32;
import asposewobfuscated.zz93;
import asposewobfuscated.zzDL;
import asposewobfuscated.zzR9;
import asposewobfuscated.zzZ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zz0A;
import com.aspose.words.zzYQK;
import com.aspose.words.zzZ1K;
import com.aspose.words.zzZGC;
import com.aspose.words.zzZQ1;

public class FormField
extends SpecialChar {
    private zz0A zzZ7G;
    private Field zzZ7F;
    static String zzZ7E = zz32.zzV('\u2002', 5);
    private static final zz2D zzVH = new zz2D("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zz0A formFieldPr, zzZ1K runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ7G = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZQ1 zzZQ12) {
        FormField formField = (FormField)super.zzZ(bl, zzZQ12);
        ((FormField)super.zzZ(bl, zzZQ12)).zzZ7G = (zz0A)this.zzZ7G.zzza();
        formField.zzZ7F = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZDr().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVH.zzWT(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzDL.zzI((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZDq().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzR9.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYQK.zzY((zz93)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ7G.getName();
    }

    public void setName(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZ7G.setName(value);
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZUK() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZ7F == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZ7F = fieldChar.getField();
            }
        }
        return this.zzZ7F;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz32.equals(string, zzZ7E)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZUJ();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzR9.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQK(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ7G.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ7G.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ7G.zzZUF();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ7G.zzWO(value);
    }

    public String getHelpText() {
        return this.zzZ7G.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ7G.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ7G.zzZUG();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ7G.zzWP(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ7G.zzZUH();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ7G.zzWQ(value);
    }

    public String getEntryMacro() {
        return this.zzZ7G.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ7G.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ7G.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ7G.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ7G.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ7G.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ7G.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ7G.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ7G.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ7G.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ7G.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ7G.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzFX(21);
            zzZGC.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZDq());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ7G.zzZUE();
    }

    public void setMaxLength(int value) {
        this.zzZ7G.zzKd(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ7G.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zz0A zz0A2 = this.zzZ7G;
        if (zz0A2.contains(21070)) {
            return this.zzZ7G.zzZUy();
        }
        return this.zzZ7G.zzZUz();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ7G.zzKa(value);
    }

    final String zzZUJ() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQK(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzDL.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zz0A zz0A2 = this.zzZ7G;
        if (zz0A2.contains(21010)) {
            return this.zzZ7G.zzZUA();
        }
        return this.zzZ7G.zzZUB();
    }

    public void setChecked(boolean value) {
        this.zzZ7G.zzWL(value);
    }

    public boolean getDefault() {
        return this.zzZ7G.zzZUB();
    }

    public void setDefault(boolean value) {
        this.zzZ7G.zzWM(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ7G.zzZUD();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ7G.zzWN(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ7G.zzZUC();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ7G.zzKc(zzZ.zzV(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zz0A zzZUI() {
        return this.zzZ7G;
    }
}

