/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz95;
import asposewobfuscated.zzZ;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.zzX;
import com.aspose.words.zzYU3;
import com.aspose.words.zzZQ1;
import com.aspose.words.zzZRH;
import com.aspose.words.zzZX4;

public abstract class Node
implements Cloneable {
    private Node zzYGc;
    private Node zzYGb;
    private Node zzYGa;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzZ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYGc == null) {
            return null;
        }
        if (this.zzYGc.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYGc;
    }

    final CompositeNode zzZDr() {
        if (zzX.zzK(this.getParentNode())) {
            return this.getParentNode().zzZDr();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYGc == null) {
            return null;
        }
        return this.zzYGc.getDocument();
    }

    final Document zzZDq() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZDp() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz7M();
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            Node node = this;
            return node.zzYGa;
        }
        return null;
    }

    final Node zzZDo() {
        Node node = zzX.zzI(this.getPreviousSibling());
        if (node == null && zzX.zzK(this.getParentNode())) {
            node = this.getParentNode().zzZDo();
        }
        return node;
    }

    final Node zzZDn() {
        Node node = zzX.zzJ(this.getNextSibling());
        if (node == null && zzX.zzK(this.getParentNode())) {
            node = this.getParentNode().zzZDn();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            Node node = this;
            return node.zzYGb;
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZDm() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZDl() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzT(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZDk() {
        return this.zzYGb;
    }

    final void zzZk(Node node) {
        this.zzYGb = node;
    }

    final Node zzZDj() {
        return this.zzYGa;
    }

    final void zzZj(Node node) {
        this.zzYGa = node;
    }

    final int zzZDi() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzX.zzP(this)) {
            return 3;
        }
        if (zzX.zzO(this)) {
            return 4;
        }
        if (zzX.zzN(this)) {
            return 5;
        }
        if (zzX.zzM(this)) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZQ1 zzZQ12) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYGc != null) {
            node.zzYGc = this.getDocument().zz6v();
        }
        node.zzYGb = null;
        node.zzYGa = null;
        if (zzZQ12 != null) {
            zzZQ12.zzU(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzU(StringBuilder stringBuilder) {
        zzZ.zzY(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZi(Node node) {
        this.zzYGc = node != null ? node : this.getDocument().zz6v();
    }

    final void zzZ(DocumentBase documentBase) {
        this.zzYGc = documentBase != null ? documentBase.zz6v() : null;
    }

    final boolean zzZh(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzFX(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzFW(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzUa(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zzZRH zzZRH2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZRH2 = new zzZX4();
                break;
            }
            case 70: {
                zzZRH2 = new zzYU3();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZRH zzZRH3 = zzZRH2;
        return zzZRH2.zzZw(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZRH zzZRH2;
        SaveOptions saveOptions2 = saveOptions;
        switch (saveOptions2.getSaveFormat()) {
            case 50: {
                zzZRH2 = new zzZX4((HtmlSaveOptions)saveOptions2);
                break;
            }
            case 70: {
                zzZRH2 = new zzYU3((TxtSaveOptions)saveOptions2);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZRH zzZRH3 = zzZRH2;
        return zzZRH2.zzZw(this);
    }

    final Node zzFV(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzQ(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZg(Node node) {
        Node node2;
        zz95 zz952;
        zz95 zz953;
        Node node3 = node;
        Node node4 = this;
        if (node4 == null || node3 == null) {
            return false;
        }
        zz95 zz954 = Node.zzZf(node4);
        zz95 zz955 = zz953 = Node.zzZf(node3);
        zz95 zz956 = zz954;
        Object var13_8 = null;
        while (zz956.peek() == zz955.peek()) {
            var13_8 = zz956.pop();
            zz955.pop();
            zz952 = zz956;
            if (zz952.size() != 0 && (zz952 = zz955).size() != 0) continue;
        }
        if ((node2 = (Node)var13_8) != null) {
            zz952 = zz954;
            if (zz952.size() == 0 || (zz952 = zz953).size() == 0) {
                zz952 = zz953;
                boolean bl = zz952.size() > 0;
                return bl;
            }
            Object e = zz954.peek();
            Object e2 = zz953.peek();
            for (Node node5 : ((CompositeNode)node2).getChildNodes()) {
                if (node5 == e) {
                    return true;
                }
                if (node5 != e2) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    private static zz95 zzZf(Node node) {
        zz95 zz952 = new zz95();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz952.push(node2);
        }
        return zz952;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

