/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz93;
import asposewobfuscated.zzNP;
import asposewobfuscated.zzNQ;
import asposewobfuscated.zzNV;
import asposewobfuscated.zzZ;
import asposewobfuscated.zzZG;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.zz09;
import com.aspose.words.zz0X;
import com.aspose.words.zzX;
import com.aspose.words.zzYG;
import com.aspose.words.zzYQP;
import com.aspose.words.zzYVL;
import com.aspose.words.zzYVP;
import com.aspose.words.zzYVR;
import com.aspose.words.zzZMN;
import com.aspose.words.zzZQ1;
import com.aspose.words.zzZYY;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzY42;
    private zzYVL zzZpT;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        Table table = this;
        return (Row)zzX.zzJ(table.getFirstChild());
    }

    public Row getLastRow() {
        Table table = this;
        return (Row)zzX.zzI(table.getLastChild());
    }

    public RowCollection getRows() {
        if (this.zzY42 == null) {
            this.zzY42 = new RowCollection(this);
        }
        return this.zzY42;
    }

    final boolean zzZgK() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            iterator.next();
            return true;
        }
        return false;
    }

    @Override
    final Node zzZ(boolean bl, zzZQ1 zzZQ12) {
        Table table = (Table)super.zzZ(bl, zzZQ12);
        if (this.zzZpT != null) {
            table.zzZpT = (zzYVL)this.zzZpT.zzza();
        }
        table.zzY42 = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    final Cell zzXJ(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final int getColumnCount() {
        int n = 0;
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Row row2 = row;
            int n2 = 0;
            Cell cell = row2.getFirstCell();
            while (cell != null) {
                n2 += cell.zzx4().zzyU();
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZDn();
            }
            n = Math.max(n, n2);
            compositeNode = row;
            row = (Row)compositeNode.zzZDn();
        }
        return n;
    }

    final zzZMN zzZgJ() {
        zzYVP zzYVP2 = new zzYVP(this);
        return zzYVP2.zzZfP();
    }

    final void zzZgI() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZsu()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzx6()) {
                switch (cell2.zzx4().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzx4().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            Cell cell3;
                            cell.zzx4().setWidth(cell.zzx4().getWidth() + cell2.zzx4().getWidth());
                            cell.zzx4().zzTH(cell.zzx4().zzyU() + cell2.zzx4().zzyU());
                            if (cell2.zzx4().getWidth() != 0 && cell.zzx4().getPreferredWidth().zzAP() && cell2.zzx4().getPreferredWidth().zzAP()) {
                                int n = cell.zzx4().getPreferredWidth().zzZtZ() + cell2.zzx4().getPreferredWidth().zzZtZ();
                                cell.zzx4().setPreferredWidth(PreferredWidth.zzD4(n));
                            }
                            if ((Cell)(cell3 = cell2).zzZDn() == null || ((Cell)(cell3 = cell2).zzZDn()).zzx4().getHorizontalMerge() != 2) {
                                Object object = cell2.zzx4().zzTS(3140);
                                if (object != null) {
                                    cell.zzx4().zzU(3140, object);
                                } else {
                                    cell.zzx4().remove(3140);
                                }
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzx4().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    final void zzZgH() {
        Object object;
        if (!this.zzsq()) {
            return;
        }
        zzYVR zzYVR2 = new zzYVR(this);
        if (zzYVR2.zzvT().length == 0) {
            return;
        }
        zzNQ zzNQ2 = new zzNQ();
        zzNP zzNP2 = new zzNP();
        CompositeNode compositeNode = this.getFirstRow();
        while (compositeNode != null) {
            zzYVR2.zzE((Row)compositeNode);
            zzNQ zzNQ3 = new zzNQ();
            zzNP zzNP3 = new zzNP();
            int n = zzYVR2.zzZjA();
            Object object2 = ((Row)compositeNode).getFirstCell();
            while (object2 != null) {
                int n2 = zzYVR2.zzZg9();
                if (((Cell)object2).zzx4().getVerticalMerge() != 0) {
                    boolean bl;
                    int n3 = zzNQ2.get(n);
                    if (zzNQ.zzXw(n3) || n3 != n2) {
                        ((Cell)object2).zzx4().setVerticalMerge(1);
                    }
                    if (bl = !((Row)compositeNode).zz65().zzXc(4120) && ((Row)compositeNode).getCells().getCount() == 1) {
                        CompositeNode compositeNode2 = compositeNode;
                        int n4 = ((Row)compositeNode2).getFirstCell().getLastParagraph() != null ? (int)(23.0 * ((Row)compositeNode2).getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : 276;
                        ((Row)compositeNode2).zz65().zzU(4120, new zzZYY(0, n4));
                    }
                    zzNQ3.set(n, n2);
                    zzNP3.set(n, object2);
                }
                n += n2;
                object = object2;
                object2 = (Cell)((Node)object).zzZDn();
            }
            object2 = zzNP2.zzOd();
            while (((zzNP.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzNP.zzZ)object2).zzOb();
                if (cell.zzx4().getVerticalMerge() != 1 || zzNP3.get(((zzNP.zzZ)object2).zzOf()) != null) continue;
                cell.zzx4().setVerticalMerge(0);
            }
            zzNQ2 = zzNQ3;
            zzNP2 = zzNP3;
            object = compositeNode;
            compositeNode = (Row)((Node)object).zzZDn();
        }
        compositeNode = this.getLastRow().getFirstCell();
        while (compositeNode != null) {
            if (((Cell)compositeNode).zzx4().getVerticalMerge() == 1) {
                ((Cell)compositeNode).zzx4().setVerticalMerge(0);
            }
            object = compositeNode;
            compositeNode = (Cell)((Node)object).zzZDn();
        }
    }

    final void zzZgG() throws Exception {
        if (!this.isNested() || this.getFirstRow() == null) {
            return;
        }
        Table table = (Table)this.getAncestor(5);
        boolean bl = table.getAllowAutoFit();
        if (bl != this.getAllowAutoFit()) {
            if (!bl) {
                this.zzZgJ();
            }
            this.setAllowAutoFit(bl);
        }
    }

    final int zz7n() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYG zzYG2 = row.getFirstCell().zzx4();
        boolean bl = this.isNested();
        zzYG zzYG3 = zzYG2;
        zzYVL zzYVL2 = row.zz65();
        return zzYVL2.zzZI0() - zzYVL2.zzY(zzYG3, bl);
    }

    @Override
    final boolean zzm(Node node) {
        return zzX.zzO(node);
    }

    final boolean isNested() {
        if (this.zzZDr() == null) {
            return false;
        }
        return this.zzZDr().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzzx(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzx(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzzx(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        this.zzx(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzzx(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzx(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzzx(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzx(4380, value);
    }

    public double getLeftPadding() {
        int n = (Integer)this.zzzx(4020);
        return (double)n / 20.0;
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzx(4020, zzZ.zzU(value));
    }

    public double getRightPadding() {
        int n = (Integer)this.zzzx(4320);
        return (double)n / 20.0;
    }

    public void setRightPadding(double value) throws Exception {
        this.zzx(4320, zzZ.zzU(value));
    }

    public double getTopPadding() {
        int n = (Integer)this.zzzx(4300);
        return (double)n / 20.0;
    }

    public void setTopPadding(double value) throws Exception {
        this.zzx(4300, zzZ.zzU(value));
    }

    public double getBottomPadding() {
        int n = (Integer)this.zzzx(4310);
        return (double)n / 20.0;
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzx(4310, zzZ.zzU(value));
    }

    public double getCellSpacing() {
        int n = (Integer)this.zzzx(4290);
        return (double)n / 20.0;
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzx(4290, zzZ.zzU(value));
    }

    public double getLeftIndent() {
        int n = (Integer)this.zzzx(4340);
        return (double)n / 20.0;
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzx(4340, zzZ.zzU(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzzx(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzx(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXL(this.zzZUZ(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        int n = value.zzZUZ();
        Table table = this;
        table.zzx(4005, n);
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzK4(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzA4(value));
    }

    public int getTextWrapping() {
        if (this.isFloating()) {
            return 1;
        }
        return 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            Table table = this;
            zzYVL zzYVL2 = table.getFirstRow().zz65();
            table.zzx(4160, 2);
            table.zzx(4190, 0);
            table.zzx(4210, 180);
            table.zzx(4270, 180);
            table.zzx(4350, false);
            int n = (Integer)zzYVL2.zzTR(4010);
            if (n == 2) {
                table.zzx(4180, 3);
            } else if (n == 1) {
                table.zzx(4180, 2);
            }
            table.zzzz(4010);
            if (zzYVL2.contains(4340)) {
                int n2 = (Integer)zzYVL2.zzTS(4340);
                table.zzx(4170, n2 - 1);
            }
            table.zzzz(4340);
            return;
        }
        Table table = this;
        zzYVL zzYVL3 = table.getFirstRow().zz65();
        int n = (Integer)zzYVL3.zzTR(4180);
        if (n == 3) {
            table.zzx(4010, 2);
        } else if (n == 2) {
            table.zzx(4010, 1);
        }
        table.zzzz(4170);
        table.zzzz(4160);
        table.zzzz(4150);
        table.zzzz(4190);
        table.zzzz(4210);
        table.zzzz(4270);
        table.zzzz(4350);
        table.zzzz(4180);
        table.zzzz(4200);
    }

    final int zzZUZ() {
        return (Integer)this.zzzx(4005);
    }

    final boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zz65().isFloating();
    }

    final zzYVL zz65() {
        if (this.zzZpT == null) {
            this.zzZpT = new zzYVL();
        }
        return this.zzZpT;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYVL.zzZX3.zzDY().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            int n = borderType;
            Table table = this;
            switch (n) {
                case 3: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzx4().remove(3110);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZDn();
                    }
                    break;
                }
                case 0: {
                    CompositeNode compositeNode;
                    Row row = table.getLastRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzx4().remove(3130);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZDn();
                    }
                    break;
                }
                case 1: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        if (cell != null) {
                            cell.zzx4().remove(3120);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZDn();
                    }
                    break;
                }
                case 2: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getLastCell();
                        if (cell != null) {
                            cell.zzx4().remove(3140);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZDn();
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        boolean bl2 = !row.isFirstRow();
                        bl = !row.isLastRow();
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            if (bl2) {
                                cell.zzx4().remove(3110);
                            }
                            if (bl) {
                                cell.zzx4().remove(3130);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZDn();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZDn();
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            boolean bl3;
                            bl = !cell.isFirstCell();
                            boolean bl4 = bl3 = !cell.isLastCell();
                            if (bl) {
                                cell.zzx4().remove(3120);
                            }
                            if (bl3) {
                                cell.zzx4().remove(3140);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZDn();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZDn();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected border type.");
                }
            }
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZsu()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            int n;
            zzYQP zzYQP2 = row.zz65();
            Iterator iterator = zzYVL.zzZX3.zzDW().iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                zzYQP2.remove(n);
            }
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYQP2 = cell.zzx4();
                iterator = zzYG.zzZX3.zzDW().iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    zzYQP2.remove(n);
                }
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZDn();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZDn();
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZDn();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZDn();
        }
    }

    public void clearShading() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            zzYQP zzYQP2 = row.zz65();
            zzYQP2.remove(4330);
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYQP2 = cell.zzx4();
                zzYQP2.remove(3170);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZDn();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZDn();
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzzz(4230);
                table.zzzy(3020);
                table.zzZgJ();
                return;
            }
            case 1: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzx(4230, PreferredWidth.fromPercent(100.0));
                table.zzzy(3020);
                table.zzZgJ();
                return;
            }
            case 2: {
                Table table = this;
                table.setAllowAutoFit(false);
                table.setPreferredWidth(PreferredWidth.AUTO);
                Table table2 = table;
                if (table2.zz65().zzZfm() != null) {
                    table2.zz65().remove(5106);
                }
                table2 = table;
                Row row = table2.getFirstRow();
                while (row != null) {
                    CompositeNode compositeNode;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        PreferredWidth preferredWidth;
                        Object object = cell.zzx4().zzTS(3010);
                        int n = object == null ? 0 : (Integer)object;
                        if (n <= 0 && (preferredWidth = cell.getCellFormat().getPreferredWidth()).zzAP()) {
                            n = preferredWidth.zzZtZ();
                            cell.zzx4().setWidth(n);
                        }
                        if (n <= 0) {
                            n = 360 * cell.zzx4().zzyU();
                            cell.zzx4().zzU(3010, n);
                        }
                        cell.zzx4().setPreferredWidth(PreferredWidth.zzD4(n));
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZDn();
                    }
                    compositeNode = row;
                    row = (Row)compositeNode.zzZDn();
                }
                table.zzZgD();
                return;
            }
        }
        throw new IllegalArgumentException("Unknown auto fit behavior.");
    }

    final int zzZgF() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzx4().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    final boolean zzZgE() {
        for (Row row : this.getRows()) {
            if (row.zz65().hasRevisions()) {
                return true;
            }
            for (Cell cell : row.getCells()) {
                if (!cell.zzx4().hasRevisions()) continue;
                return true;
            }
        }
        return false;
    }

    final void zzzz(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            row.zz65().remove(n);
            Row row2 = row;
            row = (Row)row2.zzZDn();
        }
    }

    final void zzx(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZsu()) {
            if (n == 4005) {
                Row row2 = row;
                Table table = this;
                Object object2 = row2.zz65().get(4120);
                Object object3 = row2.zz65().get(4240);
                Object object4 = row2.zz65().get(4230);
                row2.getRowFormat().clearFormatting();
                table.zzzy(3060);
                if (object2 != null) {
                    row2.zz65().zzU(4120, object2);
                }
                if (object3 != null) {
                    row2.zz65().zzU(4240, object3);
                }
                if (object4 != null) {
                    row2.zz65().zzU(4230, object4);
                }
            }
            row.zz65().zzU(n, object);
        }
    }

    private void zzzy(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                cell.zzx4().remove(n);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZDn();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZDn();
        }
    }

    final void zzZgD() {
        zz0X zz0X2 = this.zz65().zzZfm();
        if (zz0X.zzZ(zz0X2) && this.zz65().zzTS(5103) != null) {
            return;
        }
        zzYVR zzYVR2 = new zzYVR(this, false);
        zzYVR zzYVR3 = new zzYVR(this, true);
        this.zz65().zzU(5103, new zzNV(zzYVR2.zzvT()));
        for (Row row : this.getRows()) {
            zzYVR2.zzE(row);
            Table.zzZ(row.zz65(), zzYVR2);
            for (Object object : row.getCells()) {
                ((Cell)object).zzx4().zzU(3900, zzYVR2.zzZg9());
            }
        }
        if (zzZG.zzU(zzYVR2.zzvT(), zzYVR3.zzvT())) {
            zzYVL zzYVL2 = this.zz65();
            zzYVL2.remove(10010);
            return;
        }
        if (this.zz65().zzZt5() == null) {
            this.zz65().zzZ(new zz09(new zzYVL(), "", zz93.zzjE));
        }
        this.zz65().zzZfj().zzU(5103, new zzNV(zzYVR3.zzvT()));
        for (Row row : this.getRows()) {
            zzYVL zzYVL3 = row.zz65().zzZfj();
            zzYVR3.zzE(row);
            Table.zzZ(zzYVL3, zzYVR3);
            for (Cell cell : row.getCells()) {
                cell.zzx4().zzwc().zzU(3900, zzYVR3.zzZg9());
            }
        }
    }

    private static void zzZ(zzYVL zzYVL2, zzYVR zzYVR2) {
        zzYVL2.zzU(5104, zzYVR2.zzZjA());
        zzYVL2.zzU(5105, zzYVR2.zzZjB());
        zzYVL2.zzzs(zzYVR2.zzZHz());
        zzYVL2.zzHe(zzYVR2.zzZHy());
    }

    private Object zzzx(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYVL.zzTn(n);
        }
        if (n == 4005) {
            if (row.zz65() != null) {
                return row.zz65().zzZUZ();
            }
            return zzYVL.zzTn(4005);
        }
        return row.fetchRowAttr(n);
    }
}

