/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzXSH;
    private DataTable zzXSG;
    private DataTable zzXSF;
    private String zz9U;
    private String zz9T;
    private String[] zzXSE;
    private String[] zzXSD;
    private DataColumn[] zzXSC;
    private DataColumn[] zzXSB;
    private UniqueConstraint zzXSA;
    private ForeignKeyConstraint zzXSz;
    private boolean zzXSy = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzXSH = relationName;
        this.zzXSG = parentTable;
        this.zzXSF = childTable;
        this.zz9U = parentTable.getTableName();
        this.zz9T = childTable.getTableName();
        this.zzXSE = parentColumnNames;
        this.zzXSD = childColumnNames;
        this.zzXSC = new DataColumn[this.zzXSE.length];
        for (n = 0; n < this.zzXSE.length; ++n) {
            this.zzXSC[n] = new DataColumn(this.zzXSE[n], this.zzXSG);
        }
        this.zzXSB = new DataColumn[this.zzXSD.length];
        for (n = 0; n < this.zzXSD.length; ++n) {
            this.zzXSB[n] = new DataColumn(this.zzXSD[n], this.zzXSF);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzXSH = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzXSC = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzXSB = childColumns;
        this.zzXSy = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzXSB.length; ++n) {
            DataColumn dataColumn2 = childColumns[n];
            DataColumn dataColumn3 = parentColumns[n];
            if (dataColumn3.getDataType() == dataColumn2.getDataType()) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzXSE = new String[this.zzXSC.length];
        for (n = 0; n < this.zzXSC.length; ++n) {
            this.zzXSE[n] = this.zzXSC[n].getColumnName();
        }
        this.zzXSD = new String[this.zzXSB.length];
        for (n = 0; n < this.zzXSB.length; ++n) {
            this.zzXSD[n] = this.zzXSB[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzXSH;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzXSG != null) {
            return this.zzXSG;
        }
        return this.zzXSC[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzXSF != null) {
            return this.zzXSF;
        }
        return this.zzXSB[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzXSE;
    }

    public String[] getChildColumnNames() {
        return this.zzXSD;
    }

    public DataColumn[] getParentColumns() {
        return this.zzXSC;
    }

    public DataColumn[] getChildColumns() {
        return this.zzXSB;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzXSA;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzXSA = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzXSz;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzXSz = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzXSH.hashCode();
        n = n * 31 + this.zz9U.hashCode();
        n = n * 31 + this.zz9T.hashCode();
        for (int i = 0; i < this.zzXSE.length; ++i) {
            n = n * 31 + this.zzXSE[i].hashCode();
            n = n * 31 + this.zzXSD[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzZbX() throws InvalidConstraintException, DataException {
        UniqueConstraint uniqueConstraint;
        Constraint constraint;
        ForeignKeyConstraint foreignKeyConstraint;
        block6: {
            ForeignKeyConstraint foreignKeyConstraint2;
            Constraint constraint2;
            DataRelation dataRelation;
            ConstraintCollection constraintCollection;
            block5: {
                if (!this.zzXSy) {
                    return;
                }
                constraintCollection = this.getChildTable().getConstraints();
                dataRelation = this;
                for (Constraint constraint3 : constraintCollection) {
                    if (!(constraint3 instanceof ForeignKeyConstraint)) continue;
                    constraint2 = (ForeignKeyConstraint)constraint3;
                    if (!DataRelation.zzZ(dataRelation.getChildColumns(), ((ForeignKeyConstraint)constraint2).getColumns()) || !DataRelation.zzZ(dataRelation.getParentColumns(), ((ForeignKeyConstraint)constraint2).getRelatedColumns())) continue;
                    foreignKeyConstraint2 = constraint2;
                    break block5;
                }
                foreignKeyConstraint2 = null;
            }
            foreignKeyConstraint = foreignKeyConstraint2;
            constraintCollection = this.getParentTable().getConstraints();
            dataRelation = this;
            for (Constraint constraint3 : constraintCollection) {
                if (!(constraint3 instanceof UniqueConstraint)) continue;
                constraint2 = (UniqueConstraint)constraint3;
                if (!DataRelation.zzZ(dataRelation.getParentColumns(), ((UniqueConstraint)constraint2).getColumns())) continue;
                constraint = constraint2;
                break block6;
            }
            constraint = uniqueConstraint = null;
        }
        if (constraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private static boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

