/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zz4M;
import com.aspose.words.internal.zzXc8;
import com.aspose.words.zz4I;
import com.aspose.words.zzVZs;
import com.aspose.words.zzW9L;
import com.aspose.words.zzWFo;
import com.aspose.words.zzWhs;
import com.aspose.words.zzY2d;
import com.aspose.words.zzYC;
import com.aspose.words.zzYiS;
import com.aspose.words.zzZ5Y;
import com.aspose.words.zzZmO;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYiS zzZIR;

    ChartSeriesCollection(zzYiS dmlChart) {
        this.zzZIR = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZIR.zzWhq().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZIR.zzWhq().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZIR.zzWhq().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzZIR.zzWhq().clear();
        this.zzXMk(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzAF(seriesName, values);
        chartSeries.zzXWI().zzXqe(ChartSeriesCollection.zz0k(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzAF(seriesName, yValues);
        chartSeries.zzXWI().zzXqe(ChartSeriesCollection.zzWyv(xValues));
        return chartSeries;
    }

    private ChartSeries zzAF(String string, zzXc8[] zzXc8Array, double[] dArray) {
        if (zzXc8Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzXc8Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzXc8Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzAF(string, dArray);
        chartSeries.zzXWI().zzXqe(ChartSeriesCollection.zzAF(zzXc8Array));
        if (!this.zzZIR.zzPg()) {
            this.zzXMk(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzAF(seriesName, zzXc8.zzAF(dates), values);
    }

    private void zzXMk(boolean bl) {
        zzZ5Y zzZ5Y2 = zz4M.zzAF((Object)this.zzZIR, zzZ5Y.class);
        if (zzZ5Y2 != null && zzZ5Y2.zzZYA().zzXuv()) {
            zzZ5Y2.zzZYA().zzXP2().zzY6y(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzZIR.zzYK4() != 15) {
            this.zzZIR.zzY17(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzAF(seriesName, yValues);
        chartSeries.zzVT6().zztR().zzY6y(3, this.zzZIR.zzZNC());
        chartSeries.zzXWI().zzXqe(ChartSeriesCollection.zzWyv(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzWiC().zzXqe(ChartSeriesCollection.zzWyv(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzAF(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzZIR);
        chartSeries.setName(string);
        this.zzY17(chartSeries);
        chartSeries.zzWuA(this.zzZIR.zzWhq().size());
        ChartSeries chartSeries2 = chartSeries;
        chartSeries2.zzVZr(chartSeries2.getIndex());
        chartSeries.zzWKi().zzXqe(ChartSeriesCollection.zzWyv(dArray));
        chartSeries.zzWxg().zzXqe(chartSeries.zzWKi().zzXop());
        this.zzZIR.zzWEb(chartSeries);
        return chartSeries;
    }

    private void zzY17(ChartSeries chartSeries) {
        chartSeries.zzVT6().zztR().zzY6y(5, new zzWhs());
        switch (this.zzZIR.zzYK4()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzAF(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzAF(chartSeries, 5);
                ChartSeriesCollection.zzWTl(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzAF(chartSeries, 1);
                ChartSeriesCollection.zzWTl(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZok(chartSeries);
            }
        }
    }

    private static void zzZok(ChartSeries chartSeries) {
        zzWhs zzWhs2 = new zzWhs();
        zzWhs2.zzXyV(new zzYC());
        zz4I zz4I2 = new zz4I();
        zz4I2.zzZqq(1);
        zzWhs2.zzVTt().zzXyV(new zzW9L(zz4I2));
        zzWhs2.zzVTt().zzX7F(19050.0);
        chartSeries.zzVT6().zztR().zzY6y(5, zzWhs2);
    }

    private static void zzWTl(ChartSeries chartSeries) {
        zzWhs zzWhs2 = new zzWhs();
        zzWhs2.zzXyV(new zzYC());
        zzWhs2.zzVTt().zzXyV(new zzVZs());
        zzWhs2.zzVTt().setEndCap(0);
        zzWhs2.zzVTt().zzX7F(19050.0);
        chartSeries.zzVT6().zztR().zzY6y(5, zzWhs2);
    }

    private static void zzAF(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzkB().zzY6y(0, n);
        chartSeries.zzVT6().zztR().zzY6y(4, chartMarker);
    }

    private static zzZmO zzWyv(double[] dArray) {
        int n = 0;
        zzZmO zzZmO2 = new zzZmO(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZmO2.zzWEb(new zzWFo(n, d, "General"));
            }
            ++n;
        }
        zzZmO2.zzVTA(dArray.length);
        zzZmO2.zzXtj();
        return zzZmO2;
    }

    private static zzZmO zzAF(zzXc8[] zzXc8Array) {
        int n = 0;
        zzZmO zzZmO2 = new zzZmO(2, false);
        zzXc8[] zzXc8Array2 = zzXc8Array;
        int n2 = zzXc8Array.length;
        for (int i = 0; i < n2; ++i) {
            zzXc8 zzXc82 = zzXc8Array2[i];
            zzZmO2.zzWEb(new zzWFo(n++, zzXc82.zzWSH(), "m/d/yyyy"));
        }
        zzZmO2.zzVTA(zzXc8Array.length);
        zzZmO2.zzXtj();
        return zzZmO2;
    }

    private static zzZmO zz0k(String[] stringArray) {
        int n = 0;
        zzZmO zzZmO2 = new zzZmO(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZmO2.zzWEb(new zzY2d(n++, string));
        }
        zzZmO2.zzVTA(stringArray.length);
        zzZmO2.zzXtj();
        return zzZmO2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZIR.zzWhq().size();
    }
}

