/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zz4M;
import com.aspose.words.zz40;
import com.aspose.words.zzWAV;
import com.aspose.words.zzX63;
import com.aspose.words.zzXF;
import com.aspose.words.zzY4R;
import com.aspose.words.zzZ6I;
import com.aspose.words.zzZvC;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzXF,
Iterable<T> {
    private Node zzZZM;
    private Node zzWjE;
    private Node zz0s;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXCW() {
        return this.zzWp8() != null;
    }

    final boolean zzW0() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzN7() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zz40) {
                return true;
            }
            CompositeNode compositeNode = zz4M.zzAF((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzN7()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZZM;
    }

    public Node getLastChild() {
        return this.zzWjE;
    }

    final Node zzWp8() {
        return zzX63.zzY17(this.getFirstChild(), false);
    }

    final Node zzZ9i() {
        return zzX63.zzZok(this.getLastChild(), false);
    }

    final CompositeNode zzYpi() {
        return (CompositeNode)zzX63.zzY17(this.getFirstChild(), true);
    }

    final CompositeNode zzWtJ() {
        return (CompositeNode)zzX63.zzZok(this.getLastChild(), true);
    }

    final Node zzWi5() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzX63.zzXWl(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWwf() {
        Node node;
        for (node = this.getLastChild(); node != null && zzX63.zzXWl(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzAF(boolean bl, zzWAV zzWAV2) {
        CompositeNode compositeNode = (CompositeNode)super.zzAF(bl, zzWAV2);
        ((CompositeNode)super.zzAF(bl, zzWAV2)).zzWjE = null;
        compositeNode.zzZZM = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWPe(node.zzAF(true, zzWAV2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZvh(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZvh(StringBuilder stringBuilder) {
        this.zzZBX(stringBuilder);
        zz4M.zzXyV(stringBuilder, this.zzl4());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzXyV(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzX63.zzYC(nodeType);
            Node node2 = node = bl ? this.zzWp8() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZhy() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZvC.zzYD3(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZvC.zzWyv(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ6I(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzAF(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzAF(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzAF(oldChild, this, null, 1);
        if (documentBase.zzYpn() && zzX63.zzWZv(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzAF(nodeChangingArgs);
        }
        Node node = this.zzXCe(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzXyV(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzY4R.zzXo2(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWPe(Node node) {
        node.getParentNode();
        if (this.zzWjE == null) {
            node.zzZZk(null);
            node.zzXcl(null);
            this.zzZZM = node;
        } else {
            node.zzZZk(this.zzWjE);
            node.zzXcl(null);
            this.zzWjE.zzXcl(node);
        }
        this.zzWjE = node;
        node.zzWqC(this);
        return node;
    }

    final void zzAF(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzXyV(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXyV(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzX63.zzXWl(node2)) continue;
            if (zzX63.zzXqe(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzl4().length();
    }

    String zzl4() {
        return "";
    }

    final String zzX00() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZBX(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzZBX(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZvh(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzAF(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzXyV(visitor));
    }

    abstract int zzAF(DocumentVisitor var1) throws Exception;

    abstract int zzXyV(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZok(Node var1);

    final Node zzAF(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYoM(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzZok(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
            if (!node.zzXy3()) {
                node.getParentNode().zzXCe(node);
            }
        }
        if ((nodeChangingArgs = documentBase.zzAF(node, null, this, 0)) != null) {
            documentBase.zzAF(nodeChangingArgs);
        }
        if (this.zzWjE == null) {
            node.zzZZk(null);
            node.zzXcl(null);
            this.zzZZM = node;
            this.zzWjE = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzXyV(node, node2);
            } else {
                this.zzYD3(node, this.zzZZM);
            }
        } else if (node2 != null) {
            this.zzYD3(node, node2);
        } else {
            this.zzXyV(node, this.zzWjE);
        }
        node.zzWqC(this);
        if (nodeChangingArgs != null) {
            documentBase.zzXyV(nodeChangingArgs);
        }
        if (documentBase.zzYpn()) {
            zzX63.zzWnX(node);
        }
        return node;
    }

    private void zzXyV(Node node, Node node2) {
        Node node3 = node2.zzXrE();
        node.zzZZk(node2);
        node.zzXcl(node3);
        node2.zzXcl(node);
        if (node3 == null) {
            this.zzWjE = node;
            return;
        }
        node3.zzZZk(node);
    }

    private void zzYD3(Node node, Node node2) {
        Node node3 = node2.zzYb1();
        node.zzZZk(node3);
        node.zzXcl(node2);
        node2.zzZZk(node);
        if (node3 == null) {
            this.zzZZM = node;
            return;
        }
        node3.zzXcl(node);
    }

    private Node zzXCe(Node node) {
        if (node == this.zzZZM) {
            if (this.zzZZM == this.zzWjE) {
                this.zzZZM = null;
                this.zzWjE = null;
            } else {
                this.zzZZM = node.zzXrE();
                this.zzZZM.zzZZk(null);
            }
        } else {
            Node node2 = node.zzYb1();
            Node node3 = node.zzXrE();
            node2.zzXcl(node3);
            if (node3 == null) {
                this.zzWjE = node2;
            } else {
                node3.zzZZk(node2);
            }
        }
        node.zzXcl(null);
        node.zzZZk(null);
        node.zzWqC(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zz0s = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zz0s;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

