/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zz4M;
import com.aspose.words.internal.zzWUE;
import com.aspose.words.internal.zzX4L;
import com.aspose.words.internal.zzX6C;
import com.aspose.words.internal.zzX7y;
import com.aspose.words.internal.zzXD8;
import com.aspose.words.internal.zzY7s;
import com.aspose.words.internal.zzYHy;
import com.aspose.words.internal.zzYVi;
import com.aspose.words.internal.zzYpJ;
import com.aspose.words.internal.zzZER;
import com.aspose.words.internal.zzZVW;
import com.aspose.words.internal.zzZbC;
import com.aspose.words.internal.zzZt7;
import com.aspose.words.zz42;
import com.aspose.words.zzLD;
import com.aspose.words.zzRB;
import com.aspose.words.zzVOB;
import com.aspose.words.zzVOM;
import com.aspose.words.zzVVE;
import com.aspose.words.zzW9D;
import com.aspose.words.zzWGx;
import com.aspose.words.zzWM2;
import com.aspose.words.zzWXi;
import com.aspose.words.zzWeP;
import com.aspose.words.zzWf3;
import com.aspose.words.zzWpF;
import com.aspose.words.zzX0u;
import com.aspose.words.zzX63;
import com.aspose.words.zzXD5;
import com.aspose.words.zzXNM;
import com.aspose.words.zzXYX;
import com.aspose.words.zzXoT;
import com.aspose.words.zzY0w;
import com.aspose.words.zzY2A;
import com.aspose.words.zzY2T;
import com.aspose.words.zzY3u;
import com.aspose.words.zzY8G;
import com.aspose.words.zzYAK;
import com.aspose.words.zzYDE;
import com.aspose.words.zzYaa;
import com.aspose.words.zzYfp;
import com.aspose.words.zzYnU;
import com.aspose.words.zzZJR;
import com.aspose.words.zzZWp;
import com.aspose.words.zzZXq;
import com.aspose.words.zzZc7;
import com.aspose.words.zzZey;
import com.aspose.words.zzgg;
import com.aspose.words.zzje;
import com.aspose.words.zzlo;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWM2,
zzZWp,
zzlo {
    private Document zzYXj;
    private Node zzWR6;
    private Node zzZjp;
    private zzWpF zzZ9r;
    private Font zzYAM;
    private zzY7s<zzWpF> zziQ;
    private zzY7s<zzAF> zzYIF;
    private zzY0w zzYo0 = zzY0w.zzZiD();
    private zzX0u zzYrr = new zzX0u();
    private RowFormat zzpq;
    private CellFormat zzXYk;
    private zzY7s<zzWeP> zzWJj;
    private int zzX4k = 0;
    private int zzWg2 = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzZC1(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzZC1(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzZC1(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzAF(documentBuilder.getCurrentSection(), zzZc7.zzXFn(headerFooterType), 0, 0);
    }

    private void zzZC1(int n, int n2, int n3, int n4) {
        this.zzYXj.ensureMinimum();
        Section section = (Section)this.zzYXj.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzAF(section, 1, n3, n4);
    }

    private void zzAF(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZc7.zzYEy(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzYXj, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzYXj));
            }
        }
        this.zzAF(story, n2, n3);
    }

    private void zzAF(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        this.zzYD3(paragraph, n2);
    }

    final void zzYD3(Paragraph paragraph, int n) {
        if (n == 0) {
            Paragraph paragraph2 = paragraph;
            this.zzXyV(paragraph2, paragraph2.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzXyV(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXIA().zzXy3() ? zzY2A.zzZok(this.zzYXj, fieldName) : zzY2A.zzWTl(this.zzXIA(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzAF(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzAF(field, isAfter, false);
    }

    private boolean zzAF(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWXi zzWXi2 = field.getFormat().zzWeM();
        Inline inline = zzWXi2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzAF(inline.zzYUn(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzgg.zzAF(this.zzYXj, bookmarkName) : zzgg.zzXyV(this.zzYXj, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzVVB() == 6) {
            this.zzXyV((Paragraph)node.zzWSQ(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzX63.zzYoz(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXyV(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzAF(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: characterIndex");
        }
        Row row = this.zzXuE(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzYD3(cell.getFirstParagraph(), 0);
            return;
        }
        this.zzYD3(cell.getLastParagraph(), -1);
    }

    private void zzXyV(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzVVB() == 6) {
            this.zzW99(node);
        } else if (zzX63.zzXWl(node)) {
            Paragraph paragraph = zzX63.zzYoz(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzW99(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzVVB() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzW99(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzYxp();
            return;
        }
        if (!this.zzEF()) {
            this.zzYxp();
        }
    }

    private boolean zzEF() {
        Node node = this.zzXIA();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzXIA(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzAF(inline.zzYUn(), true);
            return true;
        }
        return false;
    }

    private void zzYxp() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzAF(documentBuilder.getCurrentParagraph().zzXQz(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXuE(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZrC() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXIA().zzYoM(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzVSs();
                this.zzYD3(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzXKQ(text, false);
    }

    public void writeln(String text) {
        this.zzXKQ(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzVOB zzVOB2 = new zzVOB(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzYXj, this.zzWwj(), this.zzX7G());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzXyV(this.zzXIA(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzVOB2.dispose();
        }
        if (this.getDocument().zzYpn()) {
            zzX63.zzYD3((zzXD5)paragraph, this.getDocument().zzYaw());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzpk() {
        Run run;
        Run run2;
        Node node = this.zzXIA();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            Paragraph paragraph2 = paragraph;
            run2 = paragraph2.zzYDg(false);
        } else {
            run2 = run = (Run)node.zzZDh(21);
        }
        if (run2 == null && zz4M.zzY17((Object)node, paragraph.zzgu())) {
            run = paragraph.zzgu();
        }
        zzWpF zzWpF2 = run != null ? (zzWpF)run.zzYUn().zzHz() : (zzWpF)paragraph.zzXQz().zzHz();
        Paragraph paragraph3 = new Paragraph(this.zzYXj, this.zzWwj(), zzWpF2);
        paragraph.getParentNode().insertBefore(paragraph3, paragraph);
        zzVOB zzVOB2 = new zzVOB(this.zzYXj);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph3.zzXyV(paragraph.getFirstChild(), node2, paragraph3.getLastChild());
        }
        finally {
            zzVOB2.dispose();
        }
        return paragraph3;
    }

    public void insertStyleSeparator() {
        zzje.zzYdl(this);
    }

    public void insertBreak(int breakType) {
        this.zzWFd(breakType, true);
    }

    final void zzWFd(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzZwQ(bl)) {
                    this.zzZqb(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzZwQ(bl)) {
                    this.zzZqb(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzZwQ(bl)) {
                    this.zzY7s(1);
                }
                return;
            }
            case 5: {
                if (this.zzZwQ(bl)) {
                    this.zzY7s(2);
                }
                return;
            }
            case 3: {
                if (this.zzZwQ(bl)) {
                    this.zzY7s(0);
                }
                return;
            }
            case 6: {
                if (this.zzZwQ(bl)) {
                    this.zzY7s(3);
                }
                return;
            }
            case 7: {
                if (this.zzZwQ(bl)) {
                    this.zzY7s(4);
                }
                return;
            }
            case 8: {
                this.zzZqb(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzZER.zzXRt(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzXD8.zzXyV("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX63.zzAF(fieldType, updateField, this.zzX7G(), this.zzXIA(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX63.zzAF(fieldCode, this.zzX7G(), this.zzXIA(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX63.zzAF(fieldCode, fieldValue, this.zzX7G(), this.zzXIA(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zz4M.zzXyV((Object)displayText, "displayText");
        zz4M.zzXyV((Object)urlOrBookmark, "hrefOrBookmark");
        zzW9D zzW9D2 = this.zzXyV(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzW9D2.zzXyV(documentBuilder.zzgg(88, true));
        return zzX63.zzAF(zzW9D2.getStart(), zzW9D2.getSeparator(), zzW9D2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZJH(70);
        if (zzZER.zzXRt(name)) {
            this.startBookmark(name);
        }
        this.zzZr3(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXc8(70);
        String string = zzZER.zzXRt(fieldValue) ? fieldValue : FormField.zzZYp;
        Run run = new Run(this.zzYXj, string, this.zzX7G());
        this.insertNode(run);
        Node node = this.zzgg(70, true);
        if (zzZER.zzXRt(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXtd(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXyV((Paragraph)node.zzWSQ(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZJH(71);
        if (zzZER.zzXRt(name)) {
            this.startBookmark(name);
        }
        this.zzZr3(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzgg(71, false);
        if (zzZER.zzXRt(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXtd(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZJH(83);
        if (zzZER.zzXRt(name)) {
            this.startBookmark(name);
        }
        this.zzZr3(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzgg(83, false);
        if (zzZER.zzXRt(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXtd(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzYXj, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX63.zzX5D(footnoteType));
        if (zzZER.zzXRt(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzYXj);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX63.zzVVE(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzYXj, '\u0002', new zzWpF()) : new Run(this.zzYXj, footnote.getReferenceMark(), new zzWpF());
        inline.getFont().setStyleIdentifier(zzX63.zzX5D(footnoteType));
        paragraph.appendChild(inline);
        if (zzZER.zzXRt(footnoteText)) {
            Node node = this.zzXIA();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzW99(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYCi(zzYpJ zzYpJ2) throws Exception {
        return this.zzAF(zzYpJ2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYCi(zzYpJ.zzXyV(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzAF(zzYpJ zzYpJ2, double d, double d2) throws Exception {
        return this.zzAF(zzYpJ2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzAF(zzYpJ.zzXyV(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzZbC zzZbC2 = new zzZbC();){
            zzX7y.zzAF(image, zzZbC2);
            Shape shape = this.zzAF(zzZbC2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zz4M.zzAF(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZVW.zzVTx(fileName);
        try {
            Shape shape = this.zzAF((zzYpJ)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzYpJ)object).close();
            }
        }
    }

    private Shape zzAF(zzYpJ zzYpJ2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzYpJ2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zz4M.zzWyv(zzYpJ2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzAF(zzYpJ.zzXyV(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzYXj.getCompatibilityOptions().getMswVersion() > 12 || this.zzYXj.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzYXj, 0);
            zzYaa zzYaa2 = new zzYaa();
            zzYaa2.zzAF(zzWf3.zzZIU("rect"));
            zzYaa2.zzAF(new zzXoT());
            zzZXq zzZXq2 = new zzZXq();
            zzZXq2.zzXyV(new zzVVE(this.zzYXj.zzZSg(), ""));
            zzZXq2.zzAF(new zzVOM());
            zzYaa2.zzAF(zzZXq2);
            shape.zzZWT(75);
            shape.zzYdl(zzYaa2);
        } else {
            shape = new Shape((DocumentBase)this.zzYXj, 75);
        }
        shape.zzAF(this.zzX7G());
        if (shape.getImageData().zzYZ7(imageBytes)) {
            imageBytes = shape.getImageData().zzAF(imageBytes, new zzY8G(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()));
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzXWl(width, height);
        return shape;
    }

    private Shape zzYJ5(zzYpJ zzYpJ2) throws Exception {
        byte[] byArray = zz4M.zzWyv(zzYpJ2);
        return this.zzYD(byArray);
    }

    private Shape zzYD(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzYXj, 1);
        shape.zzZWT(75);
        shape.zzAF(this.zzX7G());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXWl(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private Shape zzAF(zzYpJ zzYpJ2, String string, boolean bl, zzYpJ zzYpJ3) throws Exception {
        zzXNM zzXNM2 = zzXNM.zzWvR(string);
        Shape shape = this.zzAF(zzYpJ3, bl, zzXNM2);
        zzXYX zzXYX2 = zzWGx.zzAF(zzYpJ2, string, bl);
        return DocumentBuilder.zzAF(null, false, shape, zzXNM2.zzWds, zzXYX2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzAF(zzYpJ.zzXyV(stream), progId, asIcon, zzYpJ.zzXyV(presentation));
    }

    private Shape zzAF(String string, boolean bl, boolean bl2, zzYpJ zzYpJ2) throws Exception {
        zzXNM zzXNM2 = zzXNM.zzYl1(zzYVi.zzY9L(string));
        return this.zzAF(string, bl, bl2, zzYpJ2, zzXNM2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzAF(fileName, isLinked, asIcon, zzYpJ.zzXyV(presentation));
    }

    private Shape zzAF(String string, String string2, boolean bl, boolean bl2, zzYpJ zzYpJ2) throws Exception {
        zzXNM zzXNM2 = zzXNM.zzWvR(string2);
        return this.zzAF(string, bl, bl2, zzYpJ2, zzXNM2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzAF(fileName, progId, isLinked, asIcon, zzYpJ.zzXyV(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXNM zzXNM2 = zzXNM.zzYl1(zzYVi.zzY9L(fileName));
        return this.zzAF(fileName, isLinked, iconFile, iconCaption, zzXNM2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXNM zzXNM2 = zzXNM.zzWvR(progId);
        return this.zzAF(fileName, isLinked, iconFile, iconCaption, zzXNM2);
    }

    private Shape zzAF(zzYpJ zzYpJ2, String string, String string2, String string3) throws Exception {
        zzXNM zzXNM2 = zzXNM.zzWvR(string);
        Shape shape = this.zzX4(string2, string3);
        zzXYX zzXYX2 = zzWGx.zzAF(zzYpJ2, string, true);
        return DocumentBuilder.zzAF(null, false, shape, zzXNM2.zzWds, zzXYX2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzAF(zzYpJ.zzXyV(stream), progId, iconFile, iconCaption);
    }

    final Shape zzAF(zzLD zzLD2, zzYpJ zzYpJ2) throws Exception {
        Shape shape = this.zzYJ5(zzYpJ2);
        shape.zzZWT(201);
        shape.getOleFormat().zzXyV(zzLD2.zzXiV());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzAF(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzYDE zzYDE2 = new zzYDE();
        zzYDE2.zzYKf(useBuilderFormatting);
        zzYDE2.zzXHd(useBuilderFormatting);
        this.zzAF(html, zzYDE2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzX63.zzAF(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzX63.zzAF(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzY2T zzY2T2 = new zzY2T();
        return zzY2T2.zzAF(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYnU(this).zzAF(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYnU(this).zzAF(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzYXj, 75);
        shape.zzAF(this.zzX7G());
        shape.zzYeO(true);
        shape.getSignatureLine().zzAF(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzXWl(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzYh6(this.zzYXj);
        this.insertNode(shape);
        return shape;
    }

    private void zzAF(String string, zzYDE zzYDE2) throws Exception {
        if (this.zzR1()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzXxe(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzY3u zzY3u2 = zzX63.zzAF(string, zzYDE2, this);
        zzY3u2.zzZ5();
    }

    private boolean zzR1() {
        boolean bl = false;
        if (this.zzXIA().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXIA().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXxe(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zzZrC() == null) {
            this.startTable();
        }
        if (this.zzZrC().zzY37() == 1) {
            this.zzZrC().zzWfz();
        }
        if (this.zzZrC().zzY37() == 3) {
            this.zzZrC().zzXxg();
        }
        return this.zzZrC().zzj8();
    }

    public Table startTable() {
        this.zzWJj.push(new zzWeP(this));
        return this.zzZrC().startTable();
    }

    public Table endTable() {
        if (this.zzZrC() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZrC().endTable();
        this.zzWJj.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZrC() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZrC().endRow();
        if (this.zzYAM != null && this.zzYAM.getHidden()) {
            row.zzsu().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYXj, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYXj, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzYXj);
        this.zzWg2 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWg2 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYXj, this.zzWg2);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYXj, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zz4M.zzXyV((Object)importFormatOptions, "ImportFormatOptions");
        return zzZJR.zzAF(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzYXj;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzYXj) {
            return;
        }
        this.zzYXj = value;
        this.zzW99(null);
        this.zzZ9r = new zzWpF();
        this.zziQ = null;
        this.zzYAM = null;
        this.zzWJj = new zzY7s();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYAM == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYAM = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYAM;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzpq == null) {
            this.zzpq = new RowFormat(this);
        }
        return this.zzpq;
    }

    public CellFormat getCellFormat() {
        if (this.zzXYk == null) {
            this.zzXYk = new CellFormat(this);
        }
        return this.zzXYk;
    }

    final void zzXpm(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        this.zzZaB().push(new zzAF(this.zzX7G(), (zzWpF)this.getCurrentParagraph().zzXQz().zzHz()));
    }

    public void popFont() {
        zzY7s<zzAF> zzY7s2 = this.zzZaB();
        if (zzY7s2.size() > 0) {
            zzAF zzAF2 = (zzAF)this.zzZaB().pop();
            this.zzAF(zzAF2.zzYUn(), false);
            this.getCurrentParagraph().zzY6y(zzAF2.zzXFs());
        }
    }

    final void zzYCT() {
        this.zzYfs().push(this.zzX7G());
    }

    final void zzZOv() {
        zzY7s<zzWpF> zzY7s2 = this.zzYfs();
        if (zzY7s2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzAF((zzWpF)documentBuilder.zzYfs().pop(), false);
        }
    }

    final zzW9D zzXyV(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZJH(88);
        zzYAK zzYAK2 = new zzYAK();
        zzYAK2.setTarget(string2);
        zzYAK2.setScreenTip(string3);
        if (bl) {
            zzYAK2.setSubAddress(string);
        } else {
            zzYAK2.setAddress(zzWUE.zzYKc(string));
            zzYAK2.setSubAddress(zzWUE.zzba(string));
        }
        this.zzZr3(zzYAK2.toString());
        FieldSeparator fieldSeparator = this.zzXc8(88);
        return new zzW9D(fieldStart, fieldSeparator, null);
    }

    final zzW9D zzZC1(String string, String string2, String string3) {
        boolean bl = zzWUE.zzXVL(string);
        String string4 = bl ? zzWUE.zzba(string) : string;
        return this.zzXyV(string4, bl, string2, string3);
    }

    final FieldEnd zzZxV() {
        return this.zzgg(88, true);
    }

    final zzWpF zzX7G() {
        return (zzWpF)this.zzZ9r.zzHz();
    }

    final zz42 zzWwj() {
        return (zz42)this.getCurrentParagraph().zzW4j().zzHz();
    }

    final zzY0w zzW2i() {
        return (zzY0w)this.zzsu().zzHz();
    }

    final zzX0u zzYwn() {
        return (zzX0u)this.zzXMd().zzHz();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXIA(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXIA().getNodeType() == 8;
    }

    private void zzXKQ(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzZc7.zzYEo(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXkD(string2.substring(n4, n4 + n2));
                }
                switch (this.zzX4k) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZqb(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXkD(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzZqb(String string) {
        Run run = new Run(this.zzYXj, string, this.zzX7G());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zzZrC() != null && this.zzZrC().zzY37() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzXIA().getParentNode().insertBefore(node, this.zzXIA());
    }

    final void zzVUn(int n) {
        this.zzZwQ(true);
        this.zzY7s(n);
    }

    private void zzY7s(int n) {
        this.insertParagraph();
        zzVOB zzVOB2 = new zzVOB(this.getDocument());
        try {
            zzYfp zzYfp2 = (zzYfp)this.getCurrentSection().zzWPc().zzHz();
            Section section = new Section(this.zzYXj, zzYfp2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzYXj));
            this.zzYXj.insertAfter(section, this.getCurrentSection());
            section.getBody().zzXyV(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzVOB2.dispose();
        }
    }

    final FieldStart zzZJH(int n) {
        return zzX63.zzAF(n, this.zzX7G(), this.zzXIA(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzZr3(String string) {
        return zzX63.zzXyV(string, this.zzX7G(), this.zzXIA(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzgg(int n, boolean bl) {
        return zzX63.zzXyV(n, bl, this.zzX7G(), this.zzXIA(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzXc8(int n) {
        return zzX63.zzXyV(n, this.zzX7G(), this.zzXIA(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzXtd(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzYXj, new zzZey(), this.zzX7G());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZwQ(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZrC() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXuE(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXkD(String string) {
        if (this.zzX5G(string)) {
            zzX4L zzX4L2 = new zzX4L(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZt7 zzZt72 : zzX4L2.zzY2T(this.getParagraphFormat().getBidi())) {
                zzRB zzRB2 = zzRB.zzZFw(zzZt72.zzWEr());
                zzWpF zzWpF2 = this.zzX7G();
                zzWpF2.zzZC1(265, zzRB2);
                if (zzZt72.zzWiN()) {
                    zzWpF2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzYXj, zzZt72.getText(), zzWpF2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZqb(string);
    }

    private Shape zzAF(zzYpJ zzYpJ2, boolean bl, zzXNM zzXNM2) throws Exception {
        if (zzYpJ2 != null) {
            return this.zzYJ5(zzYpJ2);
        }
        return this.zzYD(zzWGx.zzAF(zzXNM2, bl));
    }

    private Shape zzAF(String string, boolean bl, boolean bl2, zzYpJ zzYpJ2, zzXNM zzXNM2) throws Exception {
        Shape shape = this.zzAF(zzYpJ2, bl2, zzXNM2);
        zzXYX zzXYX2 = zzWGx.zzAF(string, bl, bl2, zzXNM2);
        return DocumentBuilder.zzAF(string, bl, shape, zzXNM2.zzWds, zzXYX2);
    }

    private static Shape zzAF(String string, boolean bl, Shape shape, String string2, zzXYX zzXYX2) {
        shape.zzZWT(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzXyV(zzXYX2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private boolean zzX5G(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzX6C.zzWYA(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzAF(zzWpF zzWpF2, boolean bl) {
        this.zzZ9r = bl ? (zzWpF)zzWpF2.zzHz() : zzWpF2;
    }

    final void zzWNt() {
        this.zzZ9r.clear();
    }

    final void zzou() {
        if (this.zzX1R() != null) {
            zzX0u zzX0u2 = this.zzX1R().zzXMd();
            this.zzYrr = (zzX0u)zzX0u2.zzHz();
            zzX0u2.zzXyV(this.zzYrr);
        }
    }

    private Shape zzAF(String string, boolean bl, String string2, String string3, zzXNM zzXNM2) throws Exception {
        Shape shape = this.zzX4(string2, string3);
        zzXYX zzXYX2 = zzWGx.zzAF(string, bl, true, zzXNM2);
        return DocumentBuilder.zzAF(string, bl, shape, zzXNM2.zzWds, zzXYX2);
    }

    private Shape zzX4(String string, String string2) throws Exception {
        zzYHy zzYHy2 = new zzYHy(string, string2, this.getDocument().zzZlw());
        return this.zzYD(zzYHy2.zzWQ7());
    }

    final boolean zzZ0J() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzVVm() {
        return this.zzX4k;
    }

    final void zzWHO(int n) {
        this.zzX4k = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzXIA();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXIA();
        }
        return (Paragraph)this.zzXIA().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzWeP zzZrC() {
        zzY7s<zzWeP> zzY7s2 = this.zzWJj;
        if (zzY7s2.size() > 0) {
            return (zzWeP)this.zzWJj.peek();
        }
        return null;
    }

    private Cell zzX1R() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXVB();
    }

    private zzY7s<zzWpF> zzYfs() {
        if (this.zziQ == null) {
            this.zziQ = new zzY7s();
        }
        return this.zziQ;
    }

    private zzY7s<zzAF> zzZaB() {
        if (this.zzYIF == null) {
            this.zzYIF = new zzY7s();
        }
        return this.zzYIF;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZ9r.zzWv3(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzUb(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzUb(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZ9r.zzZC1(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZXx()) {
            this.getCurrentParagraph().zzXQz().zzZC1(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZ9r.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZ9r.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZXx()) {
            this.getCurrentParagraph().zzXQz().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzsu().zzWv3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzsu().zzXCI(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzsu().zzXWL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzsu().zzZC1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzsu().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzsu().clear();
        zzY0w.zzZiD().zzXyV(this.zzsu());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXMd().zzWv3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzXMd().zzXCI(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzXMd().zzXWL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zz4M.zzAF(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzX1R() != null ? this.zzX1R().getCellFormat() : this.getCellFormat();
            border.zzAF(cellFormat);
        }
        this.zzXMd().zzZC1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXMd().clear();
    }

    private Node zzXIA() {
        Node node = this.zzWR6 != null && this.zzWR6.getParentNode() == null ? this.zzZjp : this.zzWR6;
        if (node != null && node.zzVVB() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzW99(Node node) {
        this.zzWR6 = node;
        if (this.zzWR6 != null) {
            this.zzZjp = this.zzWR6.getParentNode();
        }
    }

    private zzY0w zzsu() {
        if (this.zzZrC() != null && this.zzZrC().zzY37() == 1) {
            return this.zzYo0;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzsu();
        }
        return this.zzYo0;
    }

    private zzX0u zzXMd() {
        if (this.zzZrC() != null && this.zzZrC().zzY37() != 3) {
            return this.zzYrr;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXVB().zzXMd();
        }
        return this.zzYrr;
    }

    static final class zzAF {
        private zzWpF zzZ9r;
        private zzWpF zzZEp;

        public zzAF(zzWpF zzWpF2, zzWpF zzWpF3) {
            this.zzZ9r = zzWpF2;
            this.zzZEp = zzWpF3;
        }

        public final zzWpF zzYUn() {
            return this.zzZ9r;
        }

        public final zzWpF zzXFs() {
            return this.zzZEp;
        }
    }
}

