/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz4M;
import com.aspose.words.internal.zzY8i;
import com.aspose.words.internal.zzYl1;
import com.aspose.words.internal.zzYpJ;
import com.aspose.words.internal.zzZER;
import com.aspose.words.internal.zzZKY;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzhC;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWxA = new HashMap();
    private static HashMap<Integer, Integer> zzY0X = new HashMap();
    private static HashMap<Integer, Integer> zzZcM = new HashMap();
    private static HashMap<Integer, Integer> zzZpQ = new HashMap();
    private static HashMap<Integer, Integer> zzZTF = new HashMap();
    private static HashMap<Integer, Integer> zzZOl = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zz4M.zzAF(fileName, "fileName");
        try (zzYl1 zzYl12 = zz4M.zz0k(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzW8o(zzYl12);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzW8o(zzY8i.zzAF(stream));
    }

    static FileFormatInfo zzW8o(zzYpJ zzYpJ2) throws Exception {
        if (zzYpJ2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzhC zzhC2 = new zzhC();
            zzYpJ zzYpJ3 = zzYpJ2;
            zzhC zzhC3 = zzhC2;
            return zzhC2.zzXyV(zzYpJ3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzXyV(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZSn(zzZKY.zzY2O(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzXPz(zzZKY.zzY2O(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzZER.zzXRt(string = zzZKY.zzXbM(FileFormatUtil.zzHT(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZSn(FileFormatUtil.zzZkD(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzXPz(FileFormatUtil.zzHT(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzZKY.zzXbM(FileFormatUtil.zzZkD(saveFormat));
        if (zzZER.zzXRt(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzXPz(zzZKY.zzWZX(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzZKY.zzXbM(FileFormatUtil.zzXz8(imageType));
    }

    static Exception zzXyV(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzZf6(int n) {
        return zzZKY.toString(FileFormatUtil.zzZkD(n));
    }

    static int zzXPz(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zz4M.zzAF(zzZTF, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzY8R(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zz4M.zzAF(zzZOl, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzXGK(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzHT(int n) {
        return zz4M.zzAF(zzWxA, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZkD(int n) {
        return zz4M.zzAF(zzY0X, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXz8(int n) {
        return zz4M.zzAF(zzZcM, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZSn(int n) {
        return zz4M.zzAF(zzZpQ, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zz0k(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zz4M.zzXyV(zzZTF, Integer.valueOf(n), Integer.valueOf(n2));
            zz4M.zzXyV(zzY0X, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZpQ.containsKey(n)) {
                zz4M.zzXyV(zzZpQ, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zz4M.zzXyV(zzWxA, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zz4M.zzXyV(zzZOl, Integer.valueOf(n), Integer.valueOf(n4));
            zz4M.zzXyV(zzZcM, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zz0k(11, 10, 10, 1);
        FileFormatUtil.zz0k(11, 0, 0, 1);
        FileFormatUtil.zz0k(12, 11, 11, 1);
        FileFormatUtil.zz0k(13, 20, 20, 1);
        FileFormatUtil.zz0k(13, 0, 254, 1);
        FileFormatUtil.zz0k(14, 21, 21, 1);
        FileFormatUtil.zz0k(15, 22, 22, 1);
        FileFormatUtil.zz0k(16, 23, 23, 1);
        FileFormatUtil.zz0k(18, 24, 24, 1);
        FileFormatUtil.zz0k(19, 25, 25, 1);
        FileFormatUtil.zz0k(20, 26, 26, 1);
        FileFormatUtil.zz0k(21, 27, 27, 1);
        FileFormatUtil.zz0k(24, 30, 30, 1);
        FileFormatUtil.zz0k(17, 31, 31, 1);
        FileFormatUtil.zz0k(25, 50, 50, 1);
        FileFormatUtil.zz0k(26, 45, 255, 1);
        FileFormatUtil.zz0k(27, 51, 51, 1);
        FileFormatUtil.zz0k(28, 0, 52, 1);
        FileFormatUtil.zz0k(29, 0, 53, 1);
        FileFormatUtil.zz0k(22, 60, 60, 1);
        FileFormatUtil.zz0k(23, 61, 61, 1);
        FileFormatUtil.zz0k(33, 40, 255, 1);
        FileFormatUtil.zz0k(40, 47, 255, 1);
        FileFormatUtil.zz0k(41, 48, 255, 1);
        FileFormatUtil.zz0k(34, 41, 255, 1);
        FileFormatUtil.zz0k(35, 46, 255, 1);
        FileFormatUtil.zz0k(37, 42, 255, 1);
        FileFormatUtil.zz0k(36, 44, 255, 1);
        FileFormatUtil.zz0k(30, 52, 255, 1);
        FileFormatUtil.zz0k(31, 70, 62, 1);
        FileFormatUtil.zz0k(32, 73, 63, 1);
        FileFormatUtil.zz0k(38, 71, 255, 1);
        FileFormatUtil.zz0k(8, 100, 255, 1);
        FileFormatUtil.zz0k(9, 105, 255, 1);
        FileFormatUtil.zz0k(6, 101, 255, 6);
        FileFormatUtil.zz0k(7, 102, 255, 7);
        FileFormatUtil.zz0k(5, 104, 255, 5);
        FileFormatUtil.zz0k(4, 0, 255, 4);
        FileFormatUtil.zz0k(3, 0, 255, 3);
        FileFormatUtil.zz0k(39, 72, 255, 1);
        FileFormatUtil.zz0k(2, 103, 255, 2);
    }
}

