/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zz4M;
import com.aspose.words.zzWAV;
import com.aspose.words.zzYfp;
import com.aspose.words.zzZ4m;

public final class Section
extends CompositeNode<Node>
implements zzZ4m {
    private zzYfp zzKg;
    private PageSetup zzWRB;
    private HeaderFooterCollection zzYAO;

    public Section(DocumentBase doc) {
        this(doc, new zzYfp());
    }

    Section(DocumentBase doc, zzYfp sectPr) {
        super(doc);
        this.zzKg = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYAO == null) {
            this.zzYAO = new HeaderFooterCollection(this);
        }
        return this.zzYAO;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWRB == null) {
            Section section = this;
            this.zzWRB = new PageSetup(section, section.getDocument().zzZ6C(), this.getDocument().getStyles(), new zzAF(this));
        }
        return this.zzWRB;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZHI();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYmz(!value);
    }

    final zzYfp zzWPc() {
        return this.zzKg;
    }

    final void zzXyV(zzYfp zzYfp2) {
        this.zzKg = zzYfp2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzAF(boolean bl, zzWAV zzWAV2) {
        zzYfp zzYfp2;
        Section section = (Section)super.zzAF(bl, zzWAV2);
        section.zzKg = zzYfp2 = (zzYfp)this.zzKg.zzHz();
        section.zzWRB = null;
        section.zzYAO = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzAF(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzXyV(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzWyv(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzWyv(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzYyW(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZok(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzYyW(n) == null;
            }
        }
        return false;
    }

    final void zzYD3(Shape shape, boolean bl) {
        this.zzAF(shape, 4, bl);
        this.zzAF(shape, 0, bl);
        this.zzAF(shape, 1, bl);
    }

    private void zzAF(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzYJ9() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzXhu()) {
                if (!shape.zzY5M()) continue;
                shape.remove();
            }
        }
    }

    private void zzWyv(Section section, boolean bl) {
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        Paragraph paragraph = bl ? body2.getLastParagraph() : null;
        body2.zzXyV(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzKg.zzWv3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZ6C().zzv6.zzXCI(key);
        }
        return zzYfp.zzXkD(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzKg.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZ6C().zzv6.zzZC1(key, value);
            return;
        }
        this.zzKg.zzZC1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzKg.clear();
    }

    final boolean zzXbC() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXcK() {
        return this.getParentNode().getLastChild() == this;
    }

    static final class zzAF
    implements zzZ4m {
        private Section zzWlf;

        zzAF(Section section) {
            this.zzWlf = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzXJK().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzXJK().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzXJK().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZ4m zzXJK() {
            Document document = zz4M.zzAF((Object)this.zzWlf.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWlf;
        }
    }
}

