/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz4M;
import com.aspose.words.internal.zzXBy;
import com.aspose.words.internal.zzXD8;
import com.aspose.words.internal.zzXQg;
import com.aspose.words.internal.zzYCo;
import com.aspose.words.internal.zzZER;
import com.aspose.words.internal.zzZv2;
import com.aspose.words.zzWAn;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzYXj;
    private zzWAn zzY8A;

    Watermark(Document doc, zzWAn watermarkProvider) {
        this.zzYXj = doc;
        this.zzY8A = watermarkProvider;
    }

    public final void setText(String text) {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) {
        Watermark.zzW7C(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzAF(text, textWatermarkOptions, this.zzYXj);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        Watermark.zzYbh(image);
        ImageWatermarkOptions imageWatermarkOptions = options == null ? new ImageWatermarkOptions() : options;
        Shape shape = this.zzAF(image, imageWatermarkOptions, this.zzYXj);
        this.add(shape);
    }

    public final int getType() {
        Shape shape = this.zzY8A.get();
        if (shape == null) {
            return 2;
        }
        shape.zzY5M();
        if (shape.zzX2h()) {
            return 0;
        }
        if (shape.zzWGD()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) {
        this.remove();
        this.zzY8A.add(shape);
    }

    public final void remove() {
        this.zzY8A.remove();
    }

    private static void zzW7C(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzZER.zzVRe(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zz4M.zzAF(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private static void zzYbh(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("image");
        }
    }

    private Shape zzAF(BufferedImage bufferedImage, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        Shape shape = new Shape((DocumentBase)document, 75);
        shape.getImageData().setImage(bufferedImage);
        Watermark.zzAF(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXqe(shape, "WordPictureWatermark");
        return shape;
    }

    private static void zzAF(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzY9m() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYSK()) / d2) > (double)(f = pageSetup.zzZgf())) {
            d = (double)f / d3;
        }
        shape.zzYUa(zzXQg.zzAF(d2 * d, 2, zzXBy.zzXyc));
        shape.zzYV3(zzXQg.zzAF(d3 * d, 2, zzXBy.zzXyc));
    }

    private Shape zzAF(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzAF(shape, textWatermarkOptions, document);
        shape.getFill().setColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXqe(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzAF(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYXG() ? 1.0f : textWatermarkOptions.getFontSize();
        zzZv2 zzZv22 = document.zzZlw().zzYD3(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzZv22.zzVWY(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYXG()) {
            l = Watermark.zzAF(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzYUa(zzXQg.zzAF(Float.intBitsToFloat(n), 2, zzXBy.zzXyc));
        shape.zzYV3(zzXQg.zzAF(zzYCo.zzZsp(l), 2, zzXBy.zzXyc));
    }

    private static long zzAF(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYSK();
        float f2 = pageSetup.zzZgf();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYCo.zzZsp(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYCo.zzYKI(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYCo.zzZsp(l) >= Float.intBitsToFloat(n)) {
            return zzYCo.zzYKI(f2 / f3, f2);
        }
        float f6 = f;
        return zzYCo.zzYKI(f6, f6 * f3);
    }

    private static void zzXqe(Shape shape, String string) {
        shape.setName(zzXD8.zzXyV("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

