/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzQ4;
import com.aspose.words.internal.zzWI1;
import com.aspose.words.internal.zzWZp;
import com.aspose.words.internal.zzXqv;
import com.aspose.words.internal.zzYVf;
import com.aspose.words.internal.zzYzR;
import com.aspose.words.internal.zzZ7N;
import com.aspose.words.internal.zzZfj;
import com.aspose.words.internal.zzZpS;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zz78
extends CertPathBuilderSpi {
    private final zzWI1 zzWsL;
    private zzXqv zzYK3;

    zz78(zzWI1 zzWI12) {
        this.zzWsL = zzWI12;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZpS pkixParams;
        if (params instanceof zzZpS) {
            pkixParams = (zzZpS)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZpS.zzAF((PKIXBuilderParameters)params).zzXQL();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZpS.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZfj zzZfj2 = pkixParams.zzGQ().zzXO3();
        try {
            collection = zzYzR.zzAF(zzZfj2, pkixParams.zzGQ().zzZts());
            collection.addAll(zzYzR.zzAF(zzZfj2, pkixParams.zzGQ().zzZ84()));
        }
        catch (zzXqv zzXqv2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXqv2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzAF(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzYK3 != null) {
            throw new CertPathBuilderException(this.zzYK3.getMessage(), this.zzYK3.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzAF(X509Certificate x509Certificate, zzZpS zzZpS2, List list) throws CertPathBuilderException {
        zzZ7N zzZ7N2;
        zzWZp zzWZp2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZpS2.zzZCt().contains(x509Certificate)) {
            return null;
        }
        if (zzZpS2.zzXDB() != -1 && list.size() - 1 > zzZpS2.zzXDB()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzWZp2 = new zzWZp(this.zzWsL);
            zzZ7N2 = new zzZ7N(this.zzWsL);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzYzR.zzAF(x509Certificate, zzZpS2.zzGQ().zz6A(), zzZpS2.zzGQ().zzXpA()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzWZp2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXqv("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZ7N2.engineValidate(certPath, zzZpS2);
                }
                catch (Exception exception) {
                    throw new zzXqv("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzYVf> arrayList = new ArrayList<zzYVf>();
            arrayList.addAll(zzZpS2.zzGQ().zzZts());
            try {
                arrayList.addAll(zzYzR.zzAF(x509Certificate.getExtensionValue(zzQ4.zzYey.getId()), zzZpS2.zzGQ().zzWQS()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXqv("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzYzR.zzAF(x509Certificate, zzZpS2.zzGQ().zzZ84(), arrayList));
            }
            catch (zzXqv zzXqv2) {
                throw new zzXqv("Cannot find issuer certificate for certificate in certification path.", zzXqv2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXqv("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzAF(x509Certificate2, zzZpS2, list);
            }
        }
        catch (zzXqv zzXqv3) {
            this.zzYK3 = zzXqv3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

