/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXD8;
import com.aspose.words.internal.zzXc8;
import com.aspose.words.internal.zzY7O;
import com.aspose.words.internal.zzY8i;
import com.aspose.words.internal.zzxe;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzWyv;
import com.aspose.words.net.System.Data.zzXyV;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzW73;
    private Object[] zzWdI;
    private int zzVXl = 1;
    private int zzWEX;
    private String zzWhN;
    private Map<String, Object> zzYME = new HashMap<String, Object>();
    private Map<String, String> zzVWM = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzW73 = table;
        this.zzWdI = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzWdI, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzXyV.zzYD3(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzW73.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzW73.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzW73;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzW73.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzW73.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzW73.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzW73.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzW73.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzW73.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzW73) {
            throw new IllegalStateException(zzXD8.zzXyV("Table {0} is not the child table in the relation {1}", this.zzW73.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzAF(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzW99(columnIndex, value);
        this.zzW73.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzW73.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzVXl;
    }

    public void setRowState(int state) {
        this.zzVXl = state;
    }

    public void delete() {
        zzWyv.zzXyV(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzYME.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzYME.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzWdI.length];
        System.arraycopy(this.zzWdI, 0, objectArray, 0, this.zzWdI.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzWdI.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzWdI.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzW99(i, array[i]);
        }
        this.zzW73.onDataRowChanged(this);
    }

    final int zzYaQ() {
        return this.zzWEX;
    }

    final void zzcD(String string, String string2) {
        this.zzVWM.put(string, string2);
    }

    final void zzYJN(String string, String string2) {
        this.zzWhN = zzXD8.zzXyV(string, string2);
    }

    final String zzVQH() {
        return this.zzWhN;
    }

    final void zzY53(int n) {
        this.zzWEX = n;
    }

    final Object[] zzZjZ() {
        return this.zzWdI;
    }

    static boolean zzAF(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzZ35(index)) {
            return null;
        }
        return this.zzWdI[index];
    }

    private void zzW99(int n, Object object) {
        if (!this.zzZ35(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzAF((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzAF((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzAF(clazz, object)))));
        this.zzWdI[n] = object2;
    }

    private static Object zzAF(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzXc8.class) {
                return zzXc8.zzAF(string, zzY7O.zzXG2(), 128).zzr5();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzxe.zzYD3(exception);
        }
        return object;
    }

    private boolean zzZ35(int n) {
        this.zzWWi();
        return this.zzWdI != null && n >= 0 && n < this.zzWdI.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzW73.getColumns().getCount();
        if (this.zzWdI.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWdI.length - index];
        System.arraycopy(this.zzWdI, index, objectArray, 0, this.zzWdI.length - index);
        System.arraycopy(objectArray, 1, this.zzWdI, index, objectArray.length - 1);
    }

    private void zzWWi() {
        if (this.zzW73 == null || this.zzW73.getColumns() == null || this.zzWdI == null) {
            return;
        }
        int n = this.zzW73.getColumns().getCount();
        if (this.zzWdI.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWdI.length];
        System.arraycopy(this.zzWdI, 0, objectArray, 0, this.zzWdI.length);
        this.zzWdI = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzWdI.length);
        System.arraycopy(objectArray, 0, this.zzWdI, 0, n2);
        for (int i = n2; i < this.zzWdI.length; ++i) {
            this.zzWdI[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzAF(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block11;
            return null;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzY8i.zzAF(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzxe.zzYD3(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzxe.zzYD3(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzxe.zzYD3(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzxe.zzYD3(iOException);
            }
            return byArray;
        }
    }

    private static String zzAF(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzxe.zzYD3(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzxe.zzYD3(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzWdI;
        int n = dataRow.zzWdI.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

