/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWTU;
import com.aspose.words.internal.zzXD8;
import com.aspose.words.internal.zzXf4;
import com.aspose.words.internal.zzY8R;
import com.aspose.words.internal.zzYAx;
import com.aspose.words.internal.zzYEw;
import com.aspose.words.internal.zzYpJ;
import com.aspose.words.internal.zzYrW;
import com.aspose.words.internal.zzZAr;
import com.aspose.words.internal.zzZFU;
import com.aspose.words.internal.zzZbC;
import com.aspose.words.internal.zzxe;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.DataTableCollection;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.XmlReadMode;
import com.aspose.words.net.System.Data.zzWyv;
import com.aspose.words.net.System.Data.zzXyV;
import com.aspose.words.net.System.Data.zzZok;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSet {
    private boolean zzEH = true;
    private String zzY7a = "NewDataSet";
    private Locale zzZ6G;
    private DataTableCollection zzmr = new DataTableCollection(this);
    private DataRelationCollection zzWfd = new DataRelationCollection();
    private String zzWCX;

    public DataSet() {
    }

    public DataSet(Connection connection) throws Exception {
        this(connection, "");
    }

    public DataSet(Connection connection, String schemaName) throws Exception {
        Object object;
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = connection.getCatalog();
        List<String> list = zzXyV.zzAF(databaseMetaData, schemaName, string);
        for (String object22 : list) {
            object = zzXyV.zzXgH(schemaName, object22);
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + (String)object);
            DataTable dataTable = new DataTable(resultSet, object22);
            dataTable.zzY17(zzXyV.zzAF(databaseMetaData, string, schemaName, object22));
            this.getTables().add(dataTable);
            zzXyV.zzAF(databaseMetaData, string, schemaName, dataTable);
        }
        List<DataRelation> list2 = zzXyV.zzAF(databaseMetaData, string, schemaName, this.getTables());
        Iterator<DataRelation> iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.getRelations().add((DataRelation)object);
        }
    }

    public DataSet(String name) {
        this.zzY7a = name;
    }

    public String getDataSetName() {
        return this.zzY7a;
    }

    public void setDataSetName(String newDataSetName) {
        this.zzY7a = newDataSetName;
    }

    public String getNamespace() {
        return null;
    }

    public DataTableCollection getTables() {
        return this.zzmr;
    }

    public DataRelationCollection getRelations() {
        return this.zzWfd;
    }

    public void close() throws Exception {
        for (DataTable dataTable : this.zzmr) {
            dataTable.close();
        }
    }

    public void clear() {
        for (DataTable dataTable : this.getTables()) {
            dataTable.getRows().clear();
        }
    }

    public void reset() {
        this.clear();
        Iterator<DataTable> iterator = this.zzmr.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        Iterator<DataRelation> iterator2 = this.zzWfd.iterator();
        while (iterator2.hasNext()) {
            iterator2.remove();
        }
    }

    public XmlReadMode readXml(InputStream xmlStream, XmlReadMode mode) throws DataException {
        if (xmlStream == null) {
            return mode;
        }
        boolean bl = false;
        try {
            zzYAx zzYAx2 = DataSet.zzLP();
            XMLStreamReader xMLStreamReader = zzYAx2.createXMLStreamReader(xmlStream);
            zzWyv zzWyv2 = null;
            zzYEw zzYEw2 = null;
            if (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            switch (mode) {
                                case AUTO: 
                                case DIFF_GRAM: {
                                    zzWyv2 = new zzWyv(this);
                                    zzWyv2.zzVWY(xMLStreamReader);
                                    return XmlReadMode.DIFF_GRAM;
                                }
                                case FRAGMENT: {
                                    DataSet.zzYh6(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    DataSet.zzYh6(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            bl = true;
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zzYh6(xMLStreamReader);
                                    return mode;
                                }
                                case FRAGMENT: {
                                    this.zzYvp(xMLStreamReader);
                                    break;
                                }
                                case AUTO: {
                                    if (this.getTables().getCount() == 0) {
                                        this.zzYvp(xMLStreamReader);
                                        return XmlReadMode.READ_SCHEMA;
                                    }
                                    DataSet.zzYh6(xMLStreamReader);
                                    return XmlReadMode.IGNORE_SCHEMA;
                                }
                                default: {
                                    this.zzYvp(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        zzYEw2 = new zzYEw();
                        zzYEw2.setName(zzXf4.zzcp(xMLStreamReader.getLocalName()));
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            if (!"".equals(xMLStreamReader.getAttributePrefix(i))) continue;
                            zzYEw2.zzTP().put(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                        }
                        break;
                    }
                }
            }
            XmlReadMode xmlReadMode = mode;
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        zzZok zzZok2;
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            xMLStreamReader.getLocalName().equals("Schema");
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zzYh6(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    this.zzYvp(xMLStreamReader);
                                    xmlReadMode = XmlReadMode.READ_SCHEMA;
                                    bl = true;
                                    break;
                                }
                            }
                            break;
                        }
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            if (mode == XmlReadMode.DIFF_GRAM || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.AUTO) {
                                if (zzWyv2 == null) {
                                    zzWyv2 = new zzWyv(this);
                                }
                                zzWyv2.zzVWY(xMLStreamReader);
                                xmlReadMode = XmlReadMode.DIFF_GRAM;
                                if (mode != XmlReadMode.DIFF_GRAM) break;
                                return xmlReadMode;
                            }
                            DataSet.zzYh6(xMLStreamReader);
                            break;
                        }
                        if (!(bl || xmlReadMode == XmlReadMode.READ_SCHEMA || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.FRAGMENT || this.getTables().getCount() != 0 && mode != XmlReadMode.INFER_SCHEMA)) {
                            if (mode == XmlReadMode.AUTO) {
                                xmlReadMode = XmlReadMode.INFER_SCHEMA;
                            }
                            zzZok2 = new zzZok(this, xMLStreamReader, zzYEw2, true);
                            zzZok2.zzX4l();
                            return xmlReadMode;
                        }
                        mode = bl ? XmlReadMode.READ_SCHEMA : XmlReadMode.IGNORE_SCHEMA;
                        zzZok2 = new zzZok(this, xMLStreamReader, zzYEw2, false);
                        zzZok2.zzX4l();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
        catch (SQLException sQLException) {
            throw new DataException(sQLException);
        }
        catch (zzYrW zzYrW2) {
            throw new DataException(zzYrW2);
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new DataException(invalidConstraintException);
        }
        return XmlReadMode.AUTO;
    }

    public XmlReadMode readXml(zzYpJ xmlStream) throws DataException {
        return this.readXml(zzYpJ.zzWZX(xmlStream));
    }

    public XmlReadMode readXml(InputStream xmlStream) throws DataException {
        return this.readXml(xmlStream, XmlReadMode.AUTO);
    }

    public XmlReadMode readXml(String xmlPath) throws DataException {
        return this.readXml(xmlPath, XmlReadMode.AUTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlReadMode readXml(String xmlPath, XmlReadMode readMode) throws DataException {
        XmlReadMode xmlReadMode;
        if (xmlPath == null) throw new IllegalArgumentException("xmlPath cannot be empty");
        if (xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzWCX = xmlPath;
            inputStream = new FileInputStream(xmlPath);
            xmlReadMode = this.readXml(inputStream, readMode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DataException(fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    Exception exception3 = exception;
                    zzxe.zzYD3(exception);
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return xmlReadMode;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzxe.zzYD3(exception);
        }
        return xmlReadMode;
    }

    @Deprecated
    public XmlReadMode readXml(zzZbC stream) {
        return this.readXml(new zzWTU(stream));
    }

    public void readXmlSchema(zzYpJ xmlStream) throws DataException {
        this.readXmlSchema(zzYpJ.zzWZX(xmlStream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXmlSchema(InputStream xmlStream) throws DataException {
        if (xmlStream == null) {
            throw new IllegalArgumentException("xmlStream cannot be null");
        }
        XMLStreamReader xMLStreamReader = null;
        try {
            zzYAx zzYAx2 = DataSet.zzLP();
            xMLStreamReader = zzYAx2.createXMLStreamReader(xmlStream);
            this.zzYvp(xMLStreamReader);
            if (xMLStreamReader == null) return;
        }
        catch (XMLStreamException xMLStreamException) {
            try {
                throw new DataException(xMLStreamException);
                catch (zzYrW zzYrW2) {
                    throw new DataException(zzYrW2);
                }
                catch (InvalidConstraintException invalidConstraintException) {
                    throw new DataException(invalidConstraintException);
                }
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                try {
                    xMLStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException2) {
                    throw new DataException(xMLStreamException2);
                }
            }
        }
        try {
            xMLStreamReader.close();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
    }

    public void readXmlSchema(String xmlPath) throws DataException {
        if (xmlPath == null || xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzWCX = xmlPath;
            try {
                inputStream = new FileInputStream(xmlPath);
                this.readXmlSchema(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DataException(fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    zzxe.zzYD3(exception);
                }
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            Exception exception3 = exception;
            zzxe.zzYD3(exception);
            return;
        }
    }

    public void setLocale(Locale locale) {
        this.zzZ6G = locale;
    }

    public boolean isLocaleSpecified() {
        return this.zzZ6G != null;
    }

    public boolean getEnforceConstraints() {
        return this.zzEH;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzEH = enforceConstraints;
        for (DataTable dataTable : this.getTables()) {
            dataTable.setEnforceConstraints(enforceConstraints);
        }
    }

    private static void zzYh6(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = xMLStreamReader.getLocalName();
        while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 2: {
                    if (!string.equals(xMLStreamReader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void zzYvp(XMLStreamReader xMLStreamReader) throws zzYrW, XMLStreamException, DataException, InvalidConstraintException {
        int n = 0;
        boolean bl = false;
        do {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    if (bl) {
                        ++n;
                    }
                    if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data")) {
                        DataSet.zzXZz();
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        this.zzuB(xMLStreamReader);
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().startsWith("http://www.w3.org/")) {
                        throw new IllegalStateException("DataSetUnsupportedSchema http://www.w3.org/2001/XMLSchema");
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    bl = zzXD8.zzY3q(xMLStreamReader.getText().trim());
                    break;
                }
                case 2: {
                    if (--n > 0) break;
                    return;
                }
            }
            if (!xMLStreamReader.hasNext()) continue;
            xMLStreamReader.next();
        } while (xMLStreamReader.hasNext());
    }

    private void zzuB(XMLStreamReader xMLStreamReader) throws zzYrW, XMLStreamException, InvalidConstraintException, DataException {
        zzZAr zzZAr2 = new zzZAr();
        zzZFU zzZFU2 = zzZFU.zzAF(xMLStreamReader);
        zzZFU2.zzX29(this.zzWCX);
        zzZAr2.zzZC1(zzZFU2);
        zzZAr2.zz5c();
        zzY8R zzY8R2 = new zzY8R();
        zzY8R2.zzAF(zzZAr2, this);
    }

    private static void zzXZz() {
        throw new UnsupportedOperationException("readXDSSchema is not implemented yet.");
    }

    private static zzYAx zzLP() {
        zzYAx zzYAx2 = new zzYAx();
        zzYAx2.zzZKJ().zzY7(false);
        zzYAx2.zzZKJ().zzYV8(false);
        zzYAx2.zzZKJ().zzYmx(false);
        zzYAx2.zzZKJ().zzY2d(true);
        zzYAx2.zzZKJ().zzVSq(true);
        zzYAx2.zzZKJ().zzZbv(false);
        zzYAx2.zzZKJ().zzZdR(false);
        zzYAx2.zzZKJ().zzXTl(0x800000);
        return zzYAx2;
    }
}

