/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzxe;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzXyV;
import com.aspose.words.net.System.Data.zzY17;
import com.aspose.words.net.System.Data.zzYD3;
import com.aspose.words.net.System.Data.zzYdl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzWD3;
    private final DataColumnCollection zzZny;
    private final ConstraintCollection zzfr;
    private final zzY17 zzWYi;
    private ResultSet zzZFu;
    private String zzZeh;
    private DataSet zzYOT;
    private String zzXb0;
    private UniqueConstraint zzYJ0;
    private boolean zzEH;
    private final List<DataTableEventListener> zzZT9;
    private final Set<DataRow> zzyA;

    public DataTable() {
        this.zzWD3 = new DataRowCollection(this);
        this.zzZny = new DataColumnCollection(this);
        this.zzfr = new ConstraintCollection(this);
        this.zzWYi = new zzY17(this);
        this.zzXb0 = "";
        this.zzEH = true;
        this.zzZT9 = new ArrayList<DataTableEventListener>();
        this.zzyA = new HashSet<DataRow>();
    }

    public DataTable(String tableName) {
        this.zzWD3 = new DataRowCollection(this);
        this.zzZny = new DataColumnCollection(this);
        this.zzfr = new ConstraintCollection(this);
        this.zzWYi = new zzY17(this);
        this.zzXb0 = "";
        this.zzEH = true;
        this.zzZT9 = new ArrayList<DataTableEventListener>();
        this.zzyA = new HashSet<DataRow>();
        this.zzZeh = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzXyV.zzAF(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzWD3 = new DataRowCollection(this);
        this.zzZny = new DataColumnCollection(this);
        this.zzfr = new ConstraintCollection(this);
        this.zzWYi = new zzY17(this);
        this.zzXb0 = "";
        this.zzEH = true;
        this.zzZT9 = new ArrayList<DataTableEventListener>();
        this.zzyA = new HashSet<DataRow>();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzZFu = resultSet;
        this.zzZeh = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzZFu != null) {
            if (this.zzZFu.getStatement() != null) {
                this.zzZFu.getStatement().getConnection().close();
            }
            this.zzZFu = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZeh;
    }

    public void setTableName(String tableName) {
        this.zzZeh = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzZny.getCount();
    }

    public String getColumnName(int index) {
        return this.zzZny.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzZFu;
    }

    public DataSet getDataSet() {
        return this.zzYOT;
    }

    final void zzWyv(DataSet dataSet) {
        this.zzYOT = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYOT.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYOT.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzWD3;
    }

    public DataColumnCollection getColumns() {
        return this.zzZny;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzfr;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYJ0 == null) {
            return new DataColumn[0];
        }
        return this.zzYJ0.getColumns();
    }

    final void zzY17(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYJ0 != null) {
                this.zzYJ0.zzYVD(false);
                this.getConstraints().remove(this.zzYJ0);
                this.zzYJ0 = null;
            }
            return;
        }
        if (this.zzYJ0 != null && DataColumn.areColumnSetsTheSame(value, this.zzYJ0.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzAF(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYJ0 != null) {
            this.zzYJ0.zzYVD(false);
            this.getConstraints().remove(this.zzYJ0);
            this.zzYJ0 = null;
        }
        UniqueConstraint.zzAF(this.getConstraints(), uniqueConstraint);
        this.zzYJ0 = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzXb0;
    }

    public void setNamespace(String namespace) {
        this.zzXb0 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzEH;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzEH = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzyA.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzXyV.zzAF(this.getResultSet(), this);
            zzXyV.zzXyV(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzxe.zzWyv(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzXyV.zzYD3(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzZT9.contains(listener)) {
            this.zzZT9.add(listener);
        }
    }

    public void removeEventListener(zzYD3 listener) {
        if (this.zzZT9.contains(listener)) {
            this.zzZT9.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzZT9.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzyA.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZT9) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzyA.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZT9) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzyA.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzZT9) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZT9) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzZT9) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzYdl zzAF(zzXyV[] zzXyVArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzXyVArray.length];
        for (int i = 0; i < zzXyVArray.length; ++i) {
            dataColumnArray[i] = zzXyVArray[i].zzWod();
        }
        DataTable dataTable = this;
        zzYdl zzYdl2 = dataTable.zzWYi.zzWyv(dataColumnArray);
        if (zzYdl2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzYdl2;
    }

    final zzY17 zzVP8() {
        return this.zzWYi;
    }

    final Set<DataRow> zzZVr() {
        return this.zzyA;
    }
}

