/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXD8;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.Rule;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzAF;
import com.aspose.words.net.System.Data.zzWyv;

public class ForeignKeyConstraint
extends Constraint {
    private DataColumn[] zzXlW;
    private DataColumn[] zzXhX;
    private Rule zzVL = Rule.CASCADE;
    private Rule zzXlM = Rule.CASCADE;
    private UniqueConstraint zzXjN;
    private zzAF zzfS = zzAF.NONE;

    public ForeignKeyConstraint(String constraintName, DataColumn[] parentColumns, DataColumn[] childColumns) {
        this.setConstraintName(constraintName);
        this.zzXlW = new DataColumn[parentColumns.length];
        System.arraycopy(parentColumns, 0, this.zzXlW, 0, parentColumns.length);
        this.zzXhX = new DataColumn[childColumns.length];
        System.arraycopy(childColumns, 0, this.zzXhX, 0, childColumns.length);
    }

    public ForeignKeyConstraint(DataColumn parentColumn, DataColumn childColumn) {
        this.zzXlW = new DataColumn[]{parentColumn};
        this.zzXhX = new DataColumn[]{childColumn};
    }

    public ForeignKeyConstraint(String constraintName, DataColumn parentColumn, DataColumn childColumn) {
        this(constraintName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn});
    }

    public Rule getDeleteRule() {
        return this.zzVL;
    }

    public Rule getUpdateRule() {
        return this.zzXlM;
    }

    public int hashCode() {
        int n;
        int n2 = 32;
        int n3 = 88;
        if (this.getColumns().length > 0) {
            n2 = 0x20 ^ this.getColumns()[0].hashCode();
        }
        for (n = 1; n < this.getColumns().length; ++n) {
            n2 ^= this.getColumns()[1].hashCode();
        }
        if (this.getRelatedColumns().length > 0) {
            n3 = 0x58 ^ this.getColumns()[0].hashCode();
        }
        for (n = 1; n < this.getRelatedColumns().length; ++n) {
            n3 ^= this.getRelatedColumns()[1].hashCode();
        }
        return n2 ^ n3;
    }

    public boolean equals(Object key) {
        ForeignKeyConstraint foreignKeyConstraint;
        ForeignKeyConstraint foreignKeyConstraint2 = foreignKeyConstraint = key instanceof ForeignKeyConstraint ? (ForeignKeyConstraint)key : null;
        if (foreignKeyConstraint == null) {
            return false;
        }
        if (!DataColumn.areColumnSetsTheSame(this.getRelatedColumns(), foreignKeyConstraint.getRelatedColumns())) {
            return false;
        }
        return DataColumn.areColumnSetsTheSame(this.getColumns(), foreignKeyConstraint.getColumns());
    }

    public DataColumn[] getColumns() {
        return this.zzXhX;
    }

    public DataColumn[] getRelatedColumns() {
        return this.zzXlW;
    }

    public DataTable getTable() {
        if (this.zzXhX != null && this.zzXhX.length > 0) {
            return this.zzXhX[0].getTable();
        }
        throw new UnsupportedOperationException("Property not accessible because 'Object reference not set to an instance of an object'");
    }

    public DataTable getRelatedTable() {
        if (this.zzXlW != null && this.zzXlW.length > 0) {
            return this.zzXlW[0].getTable();
        }
        throw new UnsupportedOperationException("Property not accessible because 'Object reference not set to an instance of an object'");
    }

    public zzAF getAcceptRejectRule() {
        return this.zzfS;
    }

    @Override
    protected void addToConstraintCollectionSetup(ConstraintCollection collection) throws DataException, InvalidConstraintException {
        if (collection.getTable() != this.getTable()) {
            throw new DataException("This constraint cannot be added since ForeignKey doesn't belong to table " + this.getRelatedTable().getTableName() + ".");
        }
        ForeignKeyConstraint.zzXyV(this.zzXlW, this.zzXhX);
        ForeignKeyConstraint foreignKeyConstraint = this;
        foreignKeyConstraint.zzXyV(foreignKeyConstraint.zzXlW);
        if ((this.getTable().getDataSet() != null && this.getTable().getDataSet().getEnforceConstraints() || this.getTable().getDataSet() == null && this.getTable().getEnforceConstraints()) && this.zzXdA()) {
            throw new IllegalArgumentException("This constraint cannot be enabled as not all values have corresponding parent values.");
        }
    }

    private static void zzXyV(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) throws DataException {
        if (dataColumnArray == null || dataColumnArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (dataColumnArray.length <= 0 || dataColumnArray2.length <= 0) {
            throw new IllegalArgumentException("Neither ParentColumns or ChildColumns can't be zero length.");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Parent columns and child columns must be the same length.");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (null == dataColumn.getTable()) {
                throw new IllegalArgumentException("All columns must belong to a table. ColumnName: " + dataColumn.getColumnName() + " does not belong to a table.");
            }
            if (dataTable != dataColumn.getTable()) {
                throw new DataException("Parent columns must all belong to the same table.");
            }
            if (null == dataColumn2.getTable()) {
                throw new IllegalArgumentException("All columns must belong to a table. ColumnName: " + dataColumn.getColumnName() + " does not belong to a table.");
            }
            if (dataTable2 == dataColumn2.getTable()) continue;
            throw new DataException("Child columns must all belong to the same table.");
        }
    }

    private void zzXyV(DataColumn[] dataColumnArray) throws DataException, InvalidConstraintException {
        if (dataColumnArray == null) {
            throw new IllegalArgumentException("ParentColumns can't be null");
        }
        UniqueConstraint uniqueConstraint = null;
        if (dataColumnArray[0] != null) {
            uniqueConstraint = UniqueConstraint.zzAF(dataColumnArray[0].getTable().getConstraints(), dataColumnArray);
        }
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(dataColumnArray, false);
            dataColumnArray[0].getTable().getConstraints().add(uniqueConstraint);
        }
        this.zzXjN = uniqueConstraint;
    }

    private boolean zzXdA() {
        if (this.getTable().getDataSet() == null || this.getRelatedTable().getDataSet() == null) {
            return false;
        }
        boolean bl = false;
        for (DataRow dataRow : this.getTable().getRows()) {
            if (dataRow.getRowState() == 8 || DataRow.zzAF(this.zzXhX)) continue;
            DataRow dataRow2 = dataRow;
            DataColumn[] dataColumnArray = this.zzXhX;
            DataColumn[] dataColumnArray2 = this.zzXlW;
            DataTable dataTable = this.getRelatedTable();
            if (zzWyv.zzAF(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) continue;
            bl = true;
            String[] stringArray = new String[this.zzXhX.length];
            for (int i = 0; i < this.zzXhX.length; ++i) {
                DataColumn dataColumn = this.zzXhX[i];
                stringArray[i] = dataRow.get(dataColumn).toString();
            }
            dataRow.zzYJN(zzXD8.zzXyV("ForeignKeyConstraint {0} requires the child key values ({1}) to exist in the parent table.", this.getConstraintName()), zzXD8.zzXyV(",", stringArray));
        }
        return bl;
    }
}

