/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzUi;
import com.aspose.words.internal.zzZ23;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWsD;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzWsD zzXGt;

    BorderCollection(zzWsD parent) {
        this.zzXGt = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzZ23.zzMu(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzWMn().equals(brColl.zzWMn()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXGt.getPossibleBorderKeys().zzWGp(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXGt.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXGt, borderKey);
            this.zzXGt.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXGt.getPossibleBorderKeys().zzW3C().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXGt.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXGt.getPossibleBorderKeys().zzW3C().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX3E(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXGt.getPossibleBorderKeys().zzW3C().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX3E(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzWMn().zzWUr();
    }

    public final void setColor(Color value) throws Exception {
        this.zzv9(zzUi.zz2z(value));
    }

    private zzUi zzWMn() throws Exception {
        return this.get(0).zzWMn();
    }

    private void zzv9(zzUi zzUi2) throws Exception {
        Iterator iterator = this.zzXGt.getPossibleBorderKeys().zzW3C().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX3E(n)) continue;
            this.getByBorderType(n).zzv9(zzUi2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXGt.getPossibleBorderKeys().zzW3C().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX3E(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXGt.getPossibleBorderKeys().zzW3C().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzX3E(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzWGp(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzX3E(int n) {
        return n != 6 && n != 7;
    }

    static final class zzWGp
    implements Iterator<Border> {
        private BorderCollection zzWm9;
        private int zzVQF;

        zzWGp(BorderCollection borderCollection) {
            this.zzWm9 = borderCollection;
            this.zzVQF = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzVQF >= this.zzWm9.getCount() - 1) {
                return false;
            }
            ++this.zzVQF;
            return true;
        }

        private Border zzZjN() {
            try {
                return this.zzWm9.get(this.zzVQF);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzZjN();
        }
    }
}

